/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcodeInject;

import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.app.util.pcodeInject.ConstantPoolJava;
import ghidra.app.util.pcodeInject.PcodeInjectLibraryJava;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.pcodeCPort.slgh_compile.PcodeParser;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.InjectPayloadCallother;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.sleigh.grammar.Location;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.io.IOException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class InjectPayloadJava
extends InjectPayloadCallother {
    private SleighLanguage language;
    private SAXParser saxParser;

    abstract String getPcodeText(Program var1, String var2);

    public InjectPayloadJava(String sourceName, SleighLanguage language) {
        super(sourceName);
        this.language = language;
        try {
            this.saxParser = InjectPayloadJava.getSAXParser();
        }
        catch (PcodeXMLException e) {
            e.printStackTrace();
        }
    }

    SleighLanguage getLanguage() {
        return this.language;
    }

    InjectContext getInjectContext(Program program, String context) {
        InjectContext injectContext = new InjectContext();
        injectContext.language = this.language;
        try {
            injectContext.restoreXml(this.saxParser, context, program.getAddressFactory());
            this.saxParser.reset();
        }
        catch (PcodeXMLException e1) {
            Msg.info((Object)((Object)this), (Object)e1.getMessage());
            e1.printStackTrace();
        }
        return injectContext;
    }

    AbstractConstantPoolInfoJava[] getConstantPool(Program program) {
        ConstantPoolJava cPool = null;
        try {
            cPool = new ConstantPoolJava(program);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return cPool.getConstantPool();
    }

    private static SAXParser getSAXParser() throws PcodeXMLException {
        try {
            SAXParserFactory saxParserFactory = XmlUtilities.createSecureSAXParserFactory((boolean)false);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", false);
            saxParserFactory.setFeature("http://xml.org/sax/features/validation", false);
            return saxParserFactory.newSAXParser();
        }
        catch (Exception e) {
            Msg.error(PcodeInjectLibraryJava.class, (Object)e.getMessage());
            throw new PcodeXMLException("Failed to instantiate XML parser", (Throwable)e);
        }
    }

    public OpTpl[] getPcode(PcodeParser parser, Program program, String context) {
        InjectPayload.InjectParameter[] output;
        InjectPayload.InjectParameter[] input;
        String sourceName = this.getSource();
        Location loc = new Location(sourceName, 1);
        for (InjectPayload.InjectParameter element : input = this.getInput()) {
            parser.addOperand(loc, element.getName(), element.getIndex());
        }
        for (InjectPayload.InjectParameter element : output = this.getOutput()) {
            parser.addOperand(loc, element.getName(), element.getIndex());
        }
        String pcodeText = this.getPcodeText(program, context);
        String constructTplXml = PcodeParser.stringifyTemplate((ghidra.pcodeCPort.semantics.ConstructTpl)parser.compilePcode(pcodeText, sourceName, 1));
        if (constructTplXml == null) {
            throw new SleighException("pcode compile failed " + sourceName);
        }
        final SAXParseException[] exception = new SAXParseException[1];
        XmlPullParser xmlParser = null;
        try {
            xmlParser = XmlPullParserFactory.create((String)constructTplXml, (String)sourceName, (ErrorHandler)new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    Msg.warn((Object)this, (Object)e.getMessage());
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    exception[0] = e;
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    exception[0] = e;
                }
            }, (boolean)false);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        ConstructTpl constructTpl = new ConstructTpl();
        try {
            constructTpl.restoreXml(xmlParser, this.language.getAddressFactory());
        }
        catch (UnknownInstructionException e) {
            e.printStackTrace();
        }
        if (exception[0] != null) {
            throw new SleighException("pcode compiler returned invalid xml " + sourceName, (Throwable)exception[0]);
        }
        OpTpl[] opTemplates = constructTpl.getOpVec();
        this.setTemplate(constructTpl);
        return opTemplates;
    }
}

