/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.state.ChildNodeEntries;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.NameSet;
import org.apache.jackrabbit.core.state.NodeStateListener;
import org.apache.jackrabbit.spi.Name;

public class NodeState
extends ItemState {
    private Name nodeTypeName;
    private NameSet mixinTypeNames = new NameSet();
    private NodeId id;
    private NodeId parentId;
    private NodeDefId defId;
    private ChildNodeEntries childNodeEntries = new ChildNodeEntries();
    private NameSet propertyNames = new NameSet();
    private Set sharedSet = Collections.EMPTY_SET;
    private boolean sharedSetRW;
    private transient NodeStateListener listener;

    public NodeState(NodeState overlayedState, int initialStatus, boolean isTransient) {
        super(overlayedState, initialStatus, isTransient);
        this.pull();
    }

    public NodeState(NodeId id, Name nodeTypeName, NodeId parentId, int initialStatus, boolean isTransient) {
        super(initialStatus, isTransient);
        this.id = id;
        this.parentId = parentId;
        this.nodeTypeName = nodeTypeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void copy(ItemState state, boolean syncModCount) {
        ItemState itemState = state;
        synchronized (itemState) {
            NodeState nodeState = (NodeState)state;
            this.id = nodeState.id;
            this.parentId = nodeState.parentId;
            this.nodeTypeName = nodeState.nodeTypeName;
            this.mixinTypeNames = (NameSet)nodeState.mixinTypeNames.clone();
            this.defId = nodeState.defId;
            this.propertyNames = (NameSet)nodeState.propertyNames.clone();
            this.childNodeEntries = (ChildNodeEntries)nodeState.childNodeEntries.clone();
            if (syncModCount) {
                this.setModCount(state.getModCount());
            }
            this.sharedSet = nodeState.sharedSet;
            this.sharedSetRW = false;
        }
    }

    public final boolean isNode() {
        return true;
    }

    public NodeId getParentId() {
        return this.parentId;
    }

    public ItemId getId() {
        return this.id;
    }

    public NodeId getNodeId() {
        return this.id;
    }

    public void setParentId(NodeId parentId) {
        this.parentId = parentId;
    }

    public Name getNodeTypeName() {
        return this.nodeTypeName;
    }

    public synchronized Set getMixinTypeNames() {
        return this.mixinTypeNames;
    }

    public synchronized void setMixinTypeNames(Set names) {
        this.mixinTypeNames.replaceAll(names);
    }

    public NodeDefId getDefinitionId() {
        return this.defId;
    }

    public void setDefinitionId(NodeDefId defId) {
        this.defId = defId;
    }

    public boolean hasChildNodeEntries() {
        return !this.childNodeEntries.isEmpty();
    }

    public synchronized boolean hasChildNodeEntry(Name name) {
        return !this.childNodeEntries.get(name).isEmpty();
    }

    public synchronized boolean hasChildNodeEntry(NodeId id) {
        return this.childNodeEntries.get(id) != null;
    }

    public synchronized boolean hasChildNodeEntry(Name name, int index) {
        return this.childNodeEntries.get(name, index) != null;
    }

    public synchronized boolean hasPropertyName(Name propName) {
        return this.propertyNames.contains(propName);
    }

    public synchronized ChildNodeEntry getChildNodeEntry(Name nodeName, int index) {
        return this.childNodeEntries.get(nodeName, index);
    }

    public synchronized ChildNodeEntry getChildNodeEntry(NodeId id) {
        return this.childNodeEntries.get(id);
    }

    public synchronized List getChildNodeEntries() {
        return this.childNodeEntries;
    }

    public synchronized List getChildNodeEntries(Name nodeName) {
        return this.childNodeEntries.get(nodeName);
    }

    public synchronized ChildNodeEntry addChildNodeEntry(Name nodeName, NodeId id) {
        ChildNodeEntry entry = this.childNodeEntries.add(nodeName, id);
        this.notifyNodeAdded(entry);
        return entry;
    }

    public synchronized boolean renameChildNodeEntry(Name oldName, int index, Name newName) {
        ChildNodeEntry oldEntry = this.childNodeEntries.remove(oldName, index);
        if (oldEntry != null) {
            ChildNodeEntry newEntry = this.childNodeEntries.add(newName, oldEntry.getId());
            this.notifyNodeAdded(newEntry);
            this.notifyNodeRemoved(oldEntry);
            return true;
        }
        return false;
    }

    public synchronized boolean removeChildNodeEntry(Name nodeName, int index) {
        ChildNodeEntry entry = this.childNodeEntries.remove(nodeName, index);
        if (entry != null) {
            this.notifyNodeRemoved(entry);
        }
        return entry != null;
    }

    public synchronized boolean removeChildNodeEntry(NodeId id) {
        ChildNodeEntry entry = this.childNodeEntries.remove(id);
        if (entry != null) {
            this.notifyNodeRemoved(entry);
        }
        return entry != null;
    }

    public synchronized void removeAllChildNodeEntries() {
        this.childNodeEntries.removeAll();
        this.notifyNodesReplaced();
    }

    public synchronized void setChildNodeEntries(List nodeEntries) {
        if (nodeEntries instanceof ChildNodeEntries) {
            ChildNodeEntries entries = (ChildNodeEntries)nodeEntries;
            this.childNodeEntries = (ChildNodeEntries)entries.clone();
        } else {
            this.childNodeEntries.removeAll();
            this.childNodeEntries.addAll(nodeEntries);
        }
        this.notifyNodesReplaced();
    }

    public synchronized Set getPropertyNames() {
        return this.propertyNames;
    }

    public synchronized void addPropertyName(Name propName) {
        this.propertyNames.add(propName);
    }

    public synchronized boolean removePropertyName(Name propName) {
        return this.propertyNames.remove(propName);
    }

    public synchronized void removeAllPropertyNames() {
        this.propertyNames.removeAll();
    }

    public synchronized void setPropertyNames(Set propNames) {
        this.propertyNames.replaceAll(propNames);
    }

    public synchronized void setNodeTypeName(Name nodeTypeName) {
        this.nodeTypeName = nodeTypeName;
    }

    public synchronized boolean isShareable() {
        return this.sharedSet != Collections.EMPTY_SET;
    }

    public synchronized boolean addShare(NodeId parentId) {
        if (this.sharedSet.contains(parentId)) {
            return false;
        }
        if (!this.sharedSetRW) {
            this.sharedSet = new LinkedHashSet(this.sharedSet);
            this.sharedSetRW = true;
        }
        return this.sharedSet.add(parentId);
    }

    public synchronized boolean containsShare(NodeId parentId) {
        return this.sharedSet.contains(parentId);
    }

    public Set getSharedSet() {
        if (this.sharedSet != Collections.EMPTY_SET) {
            return Collections.unmodifiableSet(this.sharedSet);
        }
        return Collections.EMPTY_SET;
    }

    public synchronized void setSharedSet(Set set) {
        if (set != Collections.EMPTY_SET) {
            this.sharedSet = new LinkedHashSet(set);
            this.sharedSetRW = true;
        } else {
            this.sharedSet = Collections.EMPTY_SET;
            this.sharedSetRW = false;
        }
    }

    public synchronized int removeShare(NodeId parentId) {
        if (this.sharedSet.contains(parentId)) {
            if (!this.sharedSetRW) {
                this.sharedSet = new LinkedHashSet(this.sharedSet);
                this.sharedSetRW = true;
            }
            this.sharedSet.remove(parentId);
            if (parentId.equals(this.parentId)) {
                this.parentId = !this.sharedSet.isEmpty() ? (NodeId)this.sharedSet.iterator().next() : null;
            }
        }
        return this.sharedSet.size();
    }

    public synchronized Set getAddedPropertyNames() {
        if (!this.hasOverlayedState()) {
            return this.propertyNames;
        }
        NodeState other = (NodeState)this.getOverlayedState();
        HashSet set = new HashSet(this.propertyNames);
        set.removeAll(other.propertyNames);
        return set;
    }

    public synchronized List getAddedChildNodeEntries() {
        if (!this.hasOverlayedState()) {
            return this.childNodeEntries;
        }
        NodeState other = (NodeState)this.getOverlayedState();
        return this.childNodeEntries.removeAll(other.childNodeEntries);
    }

    public synchronized Set getRemovedPropertyNames() {
        if (!this.hasOverlayedState()) {
            return Collections.EMPTY_SET;
        }
        NodeState other = (NodeState)this.getOverlayedState();
        HashSet set = new HashSet(other.propertyNames);
        set.removeAll(this.propertyNames);
        return set;
    }

    public synchronized List getRemovedChildNodeEntries() {
        if (!this.hasOverlayedState()) {
            return Collections.EMPTY_LIST;
        }
        NodeState other = (NodeState)this.getOverlayedState();
        return other.childNodeEntries.removeAll(this.childNodeEntries);
    }

    public synchronized List getRenamedChildNodeEntries() {
        if (!this.hasOverlayedState()) {
            return Collections.EMPTY_LIST;
        }
        ChildNodeEntries otherChildNodeEntries = ((NodeState)this.overlayedState).childNodeEntries;
        ArrayList<ChildNodeEntry> renamed = null;
        Iterator iter = this.childNodeEntries.iterator();
        while (iter.hasNext()) {
            ChildNodeEntry cne = (ChildNodeEntry)iter.next();
            ChildNodeEntry cneOther = otherChildNodeEntries.get(cne.getId());
            if (cneOther == null || cne.getName().equals(cneOther.getName())) continue;
            if (renamed == null) {
                renamed = new ArrayList<ChildNodeEntry>();
            }
            renamed.add(cne);
        }
        if (renamed == null) {
            return Collections.EMPTY_LIST;
        }
        return renamed;
    }

    public synchronized List getReorderedChildNodeEntries() {
        if (!this.hasOverlayedState()) {
            return Collections.EMPTY_LIST;
        }
        ChildNodeEntries otherChildNodeEntries = ((NodeState)this.overlayedState).childNodeEntries;
        if (this.childNodeEntries.isEmpty() || otherChildNodeEntries.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List ours = this.childNodeEntries.retainAll(otherChildNodeEntries);
        List others = otherChildNodeEntries.retainAll(this.childNodeEntries);
        ArrayList<ChildNodeEntry> reordered = null;
        int i = 0;
        while (i < ours.size()) {
            int j;
            ChildNodeEntry other;
            ChildNodeEntry entry = (ChildNodeEntry)ours.get(i);
            if (entry == (other = (ChildNodeEntry)others.get(i)) || entry.getId().equals(other.getId())) {
                ++i;
                continue;
            }
            if (reordered == null) {
                reordered = new ArrayList<ChildNodeEntry>();
            }
            if (i + 1 < ours.size() && entry.getId().equals(((ChildNodeEntry)others.get(i + 1)).getId())) {
                for (j = i; j < ours.size(); ++j) {
                    if (!((ChildNodeEntry)ours.get(j)).getId().equals(other.getId())) continue;
                    entry = (ChildNodeEntry)ours.get(j);
                    break;
                }
            }
            reordered.add(entry);
            for (j = i; j < ours.size(); ++j) {
                if (!((ChildNodeEntry)ours.get(j)).getId().equals(entry.getId())) continue;
                ours.remove(j);
            }
            for (j = i; j < ours.size(); ++j) {
                if (!((ChildNodeEntry)others.get(j)).getId().equals(entry.getId())) continue;
                others.remove(j);
            }
        }
        if (reordered == null) {
            return Collections.EMPTY_LIST;
        }
        return reordered;
    }

    public void setContainer(ItemStateListener listener) {
        if (listener instanceof NodeStateListener) {
            if (this.listener != null) {
                throw new IllegalStateException("State already connected to a listener: " + this.listener);
            }
            this.listener = (NodeStateListener)listener;
        }
        super.setContainer(listener);
    }

    public long calculateMemoryFootprint() {
        return 350 + this.mixinTypeNames.size() * 250 + this.childNodeEntries.size() * 300 + this.propertyNames.size() * 250;
    }

    protected void notifyNodeAdded(ChildNodeEntry added) {
        if (this.listener != null) {
            this.listener.nodeAdded(this, added.getName(), added.getIndex(), added.getId());
        }
    }

    protected void notifyNodesReplaced() {
        if (this.listener != null) {
            this.listener.nodesReplaced(this);
        }
    }

    protected void notifyNodeRemoved(ChildNodeEntry removed) {
        if (this.listener != null) {
            this.listener.nodeRemoved(this, removed.getName(), removed.getIndex(), removed.getId());
        }
    }
}

