/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.app.util.SymbolPathParser;
import ghidra.program.model.listing.Library;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.SystemUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class SymbolPath
implements Comparable<SymbolPath> {
    private final SymbolPath parentPath;
    private final String symbolName;

    public SymbolPath(String symbolPathString) {
        this(SymbolPathParser.parse(symbolPathString));
    }

    public SymbolPath(String[] symbolPath) {
        this(Arrays.asList(symbolPath));
    }

    public SymbolPath(List<String> symbolList) {
        if (symbolList == null || symbolList.isEmpty()) {
            throw new IllegalArgumentException("Symbol list must contain at least one symbol name!");
        }
        this.symbolName = symbolList.get(symbolList.size() - 1);
        this.parentPath = symbolList.size() == 1 ? null : this.checkGlobal(new SymbolPath(symbolList.subList(0, symbolList.size() - 1)));
    }

    public SymbolPath(Symbol symbol) {
        this(symbol, false);
    }

    public SymbolPath(Symbol symbol, boolean excludeLibrary) {
        this.symbolName = symbol.getName();
        Namespace parentNamespace = symbol.getParentNamespace();
        this.parentPath = parentNamespace == null || parentNamespace.isGlobal() ? null : (excludeLibrary && parentNamespace instanceof Library ? null : new SymbolPath(parentNamespace.getSymbol()));
    }

    public SymbolPath(SymbolPath parent, String name) {
        this.symbolName = Objects.requireNonNull(name);
        this.parentPath = this.checkGlobal(parent);
    }

    public SymbolPath replaceInvalidChars() {
        ArrayList<String> modList = new ArrayList<String>();
        for (String str : this.asList()) {
            modList.add(SymbolUtilities.replaceInvalidChars(str, true));
        }
        return new SymbolPath(modList);
    }

    public String getName() {
        return this.symbolName;
    }

    public SymbolPath getParent() {
        return this.parentPath;
    }

    public String getParentPath() {
        if (this.parentPath == null) {
            return null;
        }
        return this.parentPath.getPath();
    }

    public String getPath() {
        if (this.parentPath != null) {
            return this.parentPath.getPath() + "::" + this.symbolName;
        }
        return this.symbolName;
    }

    public SymbolPath append(SymbolPath path) {
        List<String> list = this.asList();
        list.addAll(path.asList());
        return new SymbolPath(list);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parentPath == null ? 0 : this.parentPath.hashCode());
        result = 31 * result + (this.symbolName == null ? 0 : this.symbolName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SymbolPath other = (SymbolPath)obj;
        if (!SystemUtilities.isEqual((Object)this.parentPath, (Object)other.parentPath)) {
            return false;
        }
        return SystemUtilities.isEqual((Object)this.symbolName, (Object)other.symbolName);
    }

    public List<String> asList() {
        ArrayList<String> list = new ArrayList<String>();
        this.addToList(list);
        return list;
    }

    public String[] asArray() {
        ArrayList<String> list = new ArrayList<String>();
        this.addToList(list);
        return list.toArray(new String[list.size()]);
    }

    public String toString() {
        return this.getPath();
    }

    private void addToList(List<String> list) {
        if (this.parentPath != null) {
            this.parentPath.addToList(list);
        }
        list.add(this.symbolName);
    }

    private SymbolPath checkGlobal(SymbolPath path) {
        if (path == null) {
            return null;
        }
        if (path.parentPath == null && path.getName().equalsIgnoreCase("Global")) {
            return null;
        }
        return path;
    }

    @Override
    public int compareTo(SymbolPath o) {
        SymbolPath otherParentPath = o.getParent();
        int result = 0;
        if (this.parentPath == null) {
            if (otherParentPath != null) {
                return -1;
            }
        } else {
            if (otherParentPath == null) {
                return 1;
            }
            result = this.parentPath.compareTo(otherParentPath);
        }
        if (result == 0) {
            result = this.symbolName.compareTo(o.getName());
        }
        return result;
    }
}

