/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.CharsetSettingsDefinition;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeWithCharset;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.RenderUnicodeSettingsDefinition;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.StringLayoutEnum;
import ghidra.program.model.data.TranslationSettingsDefinition;
import ghidra.program.model.mem.MemBuffer;

public abstract class AbstractStringDataType
extends BuiltIn
implements Dynamic,
DataTypeWithCharset {
    public static final SettingsDefinition[] COMMON_STRING_SETTINGS_DEFS = new SettingsDefinition[]{TranslationSettingsDefinition.TRANSLATION, RenderUnicodeSettingsDefinition.RENDER};
    public static final SettingsDefinition[] COMMON_WITH_CHARSET_STRING_SETTINGS_DEFS = SettingsDefinition.concat((SettingsDefinition[])COMMON_STRING_SETTINGS_DEFS, (SettingsDefinition[])new SettingsDefinition[]{CharsetSettingsDefinition.CHARSET});
    public static final String DEFAULT_UNICODE_LABEL = "UNICODE";
    public static final String DEFAULT_UNICODE_LABEL_PREFIX = "UNI";
    public static final String DEFAULT_UNICODE_ABBREV_PREFIX = "u";
    public static final String DEFAULT_LABEL = "STRING";
    public static final String DEFAULT_LABEL_PREFIX = "STR";
    public static final String DEFAULT_ABBREV_PREFIX = "s";
    public static final String USE_CHARSET_DEF_DEFAULT = null;
    private final String charsetName;
    private final SettingsDefinition[] settingsDefinition;
    private final String mnemonic;
    private final String description;
    private final DataType replacementDataType;
    private final StringLayoutEnum stringLayout;
    private final String defaultLabel;
    private final String defaultLabelPrefix;
    private final String defaultAbbrevLabelPrefix;

    protected AbstractStringDataType(String name, String mnemonic, String defaultLabel, String defaultLabelPrefix, String defaultAbbrevLabelPrefix, String description, String charsetName, DataType replacementDataType, StringLayoutEnum stringLayout, DataTypeManager dtm) {
        super(null, name, dtm);
        this.mnemonic = mnemonic;
        this.defaultLabel = defaultLabel;
        this.defaultLabelPrefix = defaultLabelPrefix;
        this.defaultAbbrevLabelPrefix = defaultAbbrevLabelPrefix;
        this.description = description;
        this.settingsDefinition = charsetName != null ? COMMON_STRING_SETTINGS_DEFS : COMMON_WITH_CHARSET_STRING_SETTINGS_DEFS;
        this.charsetName = charsetName;
        this.replacementDataType = replacementDataType;
        this.stringLayout = stringLayout;
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.mnemonic;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.defaultLabelPrefix;
    }

    @Override
    public String getDefaultAbbreviatedLabelPrefix() {
        return this.defaultAbbrevLabelPrefix;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return this.settingsDefinition;
    }

    public StringDataInstance getStringDataInstance(MemBuffer buf, Settings settings, int length) {
        return new StringDataInstance(this, settings, buf, length);
    }

    public StringLayoutEnum getStringLayout() {
        return this.stringLayout;
    }

    @Override
    public String getCharsetName(Settings settings) {
        if (this.charsetName != null) {
            return this.charsetName;
        }
        return CharsetSettingsDefinition.CHARSET.getCharset(settings, "US-ASCII");
    }

    @Override
    public boolean isDynamicallySized() {
        return true;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public boolean canSpecifyLength() {
        return true;
    }

    @Override
    public int getLength(MemBuffer buf, int maxLength) {
        return this.getStringDataInstance(buf, SettingsImpl.NO_SETTINGS, maxLength).getStringLength();
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return String.class;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return this.getStringDataInstance(buf, settings, length).getStringValue();
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return this.getStringDataInstance(buf, settings, length).getStringRepresentation();
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        return this.getStringDataInstance(buf, settings, len).getLabel(this.defaultAbbrevLabelPrefix + "_", this.defaultLabelPrefix, this.defaultLabel, options);
    }

    @Override
    public String getDefaultOffcutLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options, int offcutLength) {
        return this.getStringDataInstance(buf, settings, len).getOffcutLabelString(this.defaultAbbrevLabelPrefix + "_", this.defaultLabelPrefix, this.defaultLabel, options, offcutLength);
    }

    @Override
    public DataType getReplacementBaseType() {
        return this.replacementDataType;
    }
}

