/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.classfinder.ClassTranslator;

public class SegmentedCodePointerDataType
extends BuiltIn {
    public SegmentedCodePointerDataType() {
        this(null);
    }

    public SegmentedCodePointerDataType(DataTypeManager dtm) {
        super(null, "SegmentedCodeAddress", dtm);
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new SegmentedCodePointerDataType(dtm);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "segAddr";
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public boolean isDynamicallySized() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Code address from 16 bit segment and 16 bit offset";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        Address addr = buf.getAddress();
        try {
            long segment = buf.getShort(0) & 0xFFFF;
            long offset = buf.getShort(2) & 0xFFFF;
            long addrValue = segment << 16 | offset;
            return addr.getNewAddress(addrValue, true);
        }
        catch (AddressOutOfBoundsException | MemoryAccessException object) {
            return null;
        }
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Address.class;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        Object obj = this.getValue(buf, settings, length);
        if (obj == null) {
            return "??";
        }
        return obj.toString();
    }

    static {
        ClassTranslator.put((String)"ghidra.program.model.data.SegmentedCodePointer", (String)SegmentedCodePointerDataType.class.getName());
    }
}

