/*
 * Decompiled with CFR 0.152.
 */
package docking.util;

import docking.util.AnimationPainter;
import docking.util.SwingAnimationCallback;
import generic.util.WindowUtilities;
import generic.util.image.ImageUtils;
import ghidra.util.Msg;
import ghidra.util.bean.GGlassPane;
import ghidra.util.bean.GGlassPanePainter;
import ghidra.util.exception.AssertException;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import org.jdesktop.animation.timing.interpolation.PropertySetter;
import resources.ResourceManager;

public class AnimationUtils {
    private static boolean animationEnabled = true;

    private AnimationUtils() {
    }

    public static boolean isAnimationEnabled() {
        return animationEnabled;
    }

    public static void setAnimationEnabled(boolean enabled) {
        animationEnabled = enabled;
    }

    public static Animator focusComponent(Component component) {
        if (!animationEnabled) {
            return null;
        }
        GGlassPane glassPane = AnimationUtils.getGlassPane(component);
        if (glassPane == null) {
            return null;
        }
        FocusDriver driver = new FocusDriver(glassPane, component);
        return driver.animator;
    }

    public static Animator transitionUserFocusToComponent(Component activeComponent, Component toFocusComponent) {
        if (!animationEnabled) {
            return null;
        }
        if (activeComponent == null) {
            Msg.error(AnimationUtils.class, (Object)"No active component for animation!");
            return null;
        }
        if (!AnimationUtils.componentsAreInTheSameWindow(activeComponent, toFocusComponent)) {
            throw new IllegalArgumentException("The active component and the component to focus must be in the same window");
        }
        GGlassPane glassPane = AnimationUtils.getGlassPane(activeComponent);
        if (glassPane == null) {
            return null;
        }
        PointToComponentDriver driver = new PointToComponentDriver(glassPane, activeComponent, toFocusComponent);
        return driver.animator;
    }

    public static Animator transitionFromComponentToComponent(Component fromComponent, Component toComponent) {
        if (!animationEnabled) {
            return null;
        }
        if (!AnimationUtils.componentsAreInTheSameWindow(fromComponent, toComponent)) {
            throw new IllegalArgumentException("The fromComponent and the component to focus must be in the same window");
        }
        GGlassPane glassPane = AnimationUtils.getGlassPane(fromComponent);
        if (glassPane == null) {
            return null;
        }
        ComponentToComponentDriver driver = new ComponentToComponentDriver(glassPane, fromComponent, toComponent);
        return driver.animator;
    }

    public static Animator createPaintingAnimator(Component window, AnimationPainter painter) {
        if (!animationEnabled) {
            return null;
        }
        GGlassPane paneComponent = AnimationUtils.getGlassPane(window);
        if (paneComponent == null) {
            return null;
        }
        if (!(paneComponent instanceof GGlassPane)) {
            Msg.debug(AnimationUtils.class, (Object)("Cannot animate without a " + GGlassPane.class.getName() + " installed"));
            return null;
        }
        GGlassPane glassPane = paneComponent;
        BasicAnimationDriver driver = new BasicAnimationDriver(glassPane, new UserDefinedPainter(painter));
        return driver.animator;
    }

    public static Animator shakeComponent(Component component) {
        if (!animationEnabled) {
            return null;
        }
        GGlassPane glassPane = AnimationUtils.getGlassPane(component);
        if (glassPane == null) {
            return null;
        }
        ShakeDriver shaker = new ShakeDriver(glassPane, component);
        return shaker.animator;
    }

    public static Animator rotateComponent(Component component) {
        if (!animationEnabled) {
            return null;
        }
        GGlassPane glassPane = AnimationUtils.getGlassPane(component);
        if (glassPane == null) {
            return null;
        }
        RotateDriver rotator = new RotateDriver(glassPane, component);
        return rotator.animator;
    }

    public static Animator pulseComponent(Component component) {
        return AnimationUtils.pulseComponent(component, 2);
    }

    public static Animator pulseComponent(Component component, int pulseCount) {
        if (!animationEnabled) {
            return null;
        }
        GGlassPane glassPane = AnimationUtils.getGlassPane(component);
        if (glassPane == null) {
            return null;
        }
        PulseDriver pulser = new PulseDriver(glassPane, component, false, pulseCount);
        return pulser.animator;
    }

    public static Animator pulseAndShakeComponent(Component component) {
        if (!animationEnabled) {
            return null;
        }
        GGlassPane glassPane = AnimationUtils.getGlassPane(component);
        if (glassPane == null) {
            return null;
        }
        PulseDriver pulser = new PulseDriver(glassPane, component, true, 2);
        return pulser.animator;
    }

    public static Animator showTheDragonOverComponent(Component component) {
        if (!animationEnabled) {
            return null;
        }
        GGlassPane glassPane = AnimationUtils.getGlassPane(component);
        if (glassPane == null) {
            return null;
        }
        DragonImageDriver pulser = new DragonImageDriver(component);
        return pulser.animator;
    }

    public static Animator executeSwingAnimationCallback(SwingAnimationCallback callback) {
        int duration = callback.getDuration();
        SwingAnimationCallbackDriver driver = new SwingAnimationCallbackDriver(callback, duration);
        return driver.animator;
    }

    public static GGlassPane getGlassPane(Component c) {
        Window window = WindowUtilities.windowForComponent((Component)c);
        if (window instanceof JFrame) {
            JFrame frame = (JFrame)window;
            Component glass = frame.getGlassPane();
            if (!(glass instanceof GGlassPane)) {
                Msg.error(AnimationUtils.class, (Object)("GGlassPane not installed on window: " + window), (Throwable)new AssertException());
                return null;
            }
            return (GGlassPane)glass;
        }
        if (window instanceof JDialog) {
            JDialog frame = (JDialog)window;
            Component glass = frame.getGlassPane();
            if (!(glass instanceof GGlassPane)) {
                Msg.error(AnimationUtils.class, (Object)("GGlassPane not installed on window: " + window), (Throwable)new AssertException());
                return null;
            }
            return (GGlassPane)glass;
        }
        return null;
    }

    private static boolean componentsAreInTheSameWindow(Component activeComponent, Component toFocusComponent) {
        Window toWindow;
        Window startWindow = WindowUtilities.windowForComponent((Component)activeComponent);
        return startWindow == (toWindow = WindowUtilities.windowForComponent((Component)toFocusComponent));
    }

    private static class DragonImagePainter
    implements GGlassPanePainter {
        private Component component;
        private double percentComplete = 0.0;

        DragonImagePainter(Component component) {
            this.component = component;
        }

        void setPercentComplete(double percent) {
            this.percentComplete = percent;
        }

        public void paint(GGlassPane glassPane, Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            float alpha = (float)this.percentComplete;
            alpha = Math.min(alpha, 0.5f);
            Composite originaComposite = g2d.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), alpha);
            g2d.setComposite(alphaComposite);
            ImageIcon ghidra = ResourceManager.loadImage((String)"images/GhidraIcon256.png");
            Image ghidraImage = ghidra.getImage();
            Rectangle fullBounds = this.component.getBounds();
            fullBounds = SwingUtilities.convertRectangle(this.component.getParent(), fullBounds, (Component)glassPane);
            int gw = ghidraImage.getWidth(null);
            int gh = ghidraImage.getHeight(null);
            double smallest = fullBounds.width > fullBounds.height ? (double)fullBounds.height : (double)fullBounds.width;
            double scale = (smallest -= 10.0) / (double)gw;
            int w = (int)((double)gw * scale);
            int h = (int)((double)gh * scale);
            double cx = fullBounds.getCenterX();
            double cy = fullBounds.getCenterY();
            int offsetX = (int)(cx - (double)(w >> 1));
            int offsetY = (int)(cy - (double)(h >> 1));
            g2d.setClip(fullBounds);
            g2d.drawImage(ghidraImage, offsetX, offsetY, w, h, null);
            g2d.setComposite(originaComposite);
        }
    }

    public static class DragonImageDriver {
        private Animator animator;
        private GGlassPane glassPane;
        private DragonImagePainter rotatePainter;

        DragonImageDriver(Component component) {
            this.glassPane = AnimationUtils.getGlassPane(component);
            this.rotatePainter = new DragonImagePainter(component);
            double start = 0.0;
            double max = 1.0;
            int duration = 1500;
            this.animator = PropertySetter.createAnimator((int)duration, (Object)this, (String)"percentComplete", (Object[])new Double[]{start, max, start});
            this.animator.setAcceleration(0.2f);
            this.animator.setDeceleration(0.8f);
            this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

                public void end() {
                    this.done();
                }
            });
            this.glassPane.addPainter((GGlassPanePainter)this.rotatePainter);
            this.animator.start();
        }

        public void setPercentComplete(double percentComplete) {
            this.rotatePainter.setPercentComplete(percentComplete);
            this.glassPane.repaint();
        }

        void done() {
            this.glassPane.repaint();
            this.glassPane.removePainter((GGlassPanePainter)this.rotatePainter);
        }
    }

    private static class PulseAndShakePainter
    extends PulsePainter {
        private double lastDirection = 1.0;

        PulseAndShakePainter(Component component) {
            super(component);
        }

        @Override
        public void paint(GGlassPane glassPane, Graphics g) {
            Rectangle defaultBounds = this.component.getBounds();
            int width = (int)((double)defaultBounds.width * this.emphasis);
            int height = (int)((double)defaultBounds.height * this.emphasis);
            Rectangle emphasizedBounds = new Rectangle(defaultBounds.x, defaultBounds.y, width, height);
            emphasizedBounds = SwingUtilities.convertRectangle(this.component.getParent(), emphasizedBounds, (Component)glassPane);
            Graphics2D g2d = (Graphics2D)g;
            int offsetX = emphasizedBounds.x - (width - defaultBounds.width >> 1);
            int offsetY = emphasizedBounds.y - (height - defaultBounds.height >> 1);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            if (this.lastDirection > 0.0) {
                this.lastDirection = -0.01;
                this.lastDirection = -0.01 * this.emphasis;
            } else {
                this.lastDirection = 0.01;
                this.lastDirection = 0.01 * this.emphasis;
            }
            g2d.rotate(this.lastDirection, emphasizedBounds.getCenterX(), emphasizedBounds.getCenterY());
            g.drawImage(this.image, offsetX, offsetY, width, height, null);
        }
    }

    private static class ShakePainter
    implements GGlassPanePainter {
        private Component component;
        private Image image;
        private double lastDirection = 1.0;

        ShakePainter(Component component) {
            this.component = component;
            this.image = ImageUtils.createImage((Component)component);
        }

        public void paint(GGlassPane glassPane, Graphics g) {
            Rectangle defaultBounds = this.component.getBounds();
            int width = defaultBounds.width;
            int height = defaultBounds.height;
            Rectangle emphasizedBounds = new Rectangle(defaultBounds.x, defaultBounds.y, width, height);
            emphasizedBounds = SwingUtilities.convertRectangle(this.component.getParent(), emphasizedBounds, (Component)glassPane);
            Graphics2D g2d = (Graphics2D)g;
            int offsetX = emphasizedBounds.x - (width - defaultBounds.width >> 1);
            int offsetY = emphasizedBounds.y - (height - defaultBounds.height >> 1);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            this.lastDirection = this.lastDirection > 0.0 ? -0.031 : 0.031;
            g2d.rotate(this.lastDirection, emphasizedBounds.getCenterX(), emphasizedBounds.getCenterY());
            g.drawImage(this.image, offsetX, offsetY, width, height, null);
        }
    }

    private static class PulsePainter
    implements GGlassPanePainter {
        protected Component component;
        protected Image image;
        protected double emphasis = 1.0;

        PulsePainter(Component component) {
            this.component = component;
            this.image = ImageUtils.createImage((Component)component);
        }

        void setEmphasis(double emphasis) {
            this.emphasis = emphasis;
        }

        public void paint(GGlassPane glassPane, Graphics g) {
            Rectangle defaultBounds = this.component.getBounds();
            int width = (int)((double)defaultBounds.width * this.emphasis);
            int height = (int)((double)defaultBounds.height * this.emphasis);
            Rectangle emphasizedBounds = new Rectangle(defaultBounds.x, defaultBounds.y, width, height);
            emphasizedBounds = SwingUtilities.convertRectangle(this.component.getParent(), emphasizedBounds, (Component)glassPane);
            Graphics2D g2d = (Graphics2D)g;
            int offsetX = emphasizedBounds.x - (width - defaultBounds.width >> 1);
            int offsetY = emphasizedBounds.y - (height - defaultBounds.height >> 1);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(this.image, offsetX, offsetY, width, height, null);
        }
    }

    public static class PulseDriver {
        private Animator animator;
        private GGlassPane glassPane;
        private PulsePainter pulsePainter;

        PulseDriver(GGlassPane glassPane, Component component, boolean shake, int pulseCount) {
            this.pulsePainter = shake ? new PulseAndShakePainter(component) : new PulsePainter(component);
            this.glassPane = glassPane;
            double emphasis = 1.75;
            this.animator = PropertySetter.createAnimator((int)425, (Object)this, (String)"emphasis", (Object[])new Double[]{1.0, emphasis, 1.0});
            this.animator.setAcceleration(0.2f);
            this.animator.setDeceleration(0.8f);
            this.animator.setRepeatCount((double)pulseCount);
            this.animator.setRepeatBehavior(Animator.RepeatBehavior.REVERSE);
            this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

                public void end() {
                    this.done();
                }
            });
            glassPane.addPainter((GGlassPanePainter)this.pulsePainter);
            this.animator.start();
        }

        public void setEmphasis(double emphasis) {
            this.pulsePainter.setEmphasis(emphasis);
            this.glassPane.repaint();
        }

        void cancel() {
            this.animator.stop();
            this.done();
        }

        void done() {
            this.pulsePainter.setEmphasis(0.0);
            this.glassPane.repaint();
            this.glassPane.removePainter((GGlassPanePainter)this.pulsePainter);
        }
    }

    public static class ShakeDriver {
        private Animator animator;
        private GGlassPane glassPane;
        private ShakePainter shakePainter;

        ShakeDriver(GGlassPane glassPane, Component component) {
            this.shakePainter = new ShakePainter(component);
            this.glassPane = glassPane;
            double emphasis = 1.0;
            this.animator = PropertySetter.createAnimator((int)425, (Object)this, (String)"emphasis", (Object[])new Double[]{1.0, emphasis, 1.0});
            this.animator.setAcceleration(0.2f);
            this.animator.setDeceleration(0.8f);
            this.animator.setRepeatCount(2.0);
            this.animator.setRepeatBehavior(Animator.RepeatBehavior.REVERSE);
            this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

                public void end() {
                    this.done();
                }
            });
            glassPane.addPainter((GGlassPanePainter)this.shakePainter);
            this.animator.start();
        }

        public void setEmphasis(double emphasis) {
            this.glassPane.repaint();
        }

        void cancel() {
            this.animator.stop();
            this.done();
        }

        void done() {
            this.glassPane.repaint();
            this.glassPane.removePainter((GGlassPanePainter)this.shakePainter);
        }
    }

    private static class RotatePainter
    implements GGlassPanePainter {
        private Image image;
        private Component component;
        private double percentComplete = 0.0;

        RotatePainter(Component component) {
            this.component = component;
            this.image = ImageUtils.createImage((Component)component);
        }

        void setPercentComplete(double percent) {
            this.percentComplete = percent;
        }

        public void paint(GGlassPane glassPane, Graphics g) {
            double smallest;
            Color background = new Color(218, 232, 250);
            g.setColor(background);
            Rectangle defaultBounds = this.component.getBounds();
            Rectangle bounds = SwingUtilities.convertRectangle(this.component.getParent(), defaultBounds, (Component)glassPane);
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            int width = defaultBounds.width;
            int height = defaultBounds.height;
            double transition = 1.0 - this.percentComplete;
            double shrinkage = smallest = 0.5;
            if (transition > smallest) {
                shrinkage = transition;
            } else if (transition < 1.0 - smallest) {
                shrinkage = 1.0 - transition;
            }
            int biggest = Math.min(defaultBounds.width, defaultBounds.height);
            double maxShrink = (double)biggest * 0.5;
            int offset = (int)(maxShrink - maxShrink * shrinkage);
            int x = defaultBounds.x + offset;
            int y = defaultBounds.y + offset;
            int w = defaultBounds.width - offset * 2;
            int h = defaultBounds.height - offset * 2;
            Rectangle emphasizedBounds = new Rectangle(x, y, w, h);
            emphasizedBounds = SwingUtilities.convertRectangle(this.component.getParent(), emphasizedBounds, (Component)glassPane);
            Graphics2D g2d = (Graphics2D)g;
            int offsetX = emphasizedBounds.x - (width - defaultBounds.width >> 1);
            int offsetY = emphasizedBounds.y - (height - defaultBounds.height >> 1);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            double spinDivisor = 0.5;
            double cycleAndProgress = this.percentComplete / spinDivisor;
            int cycle = (int)cycleAndProgress;
            double progress = cycleAndProgress - (double)cycle;
            int startDegree = 360;
            int degrees = (int)((double)startDegree * progress);
            double rad = Math.toRadians(degrees);
            double cx = emphasizedBounds.getCenterX();
            double cy = emphasizedBounds.getCenterY();
            g2d.rotate(rad, cx, cy);
            g.setColor(Color.BLACK);
            int iw = emphasizedBounds.width;
            int ih = emphasizedBounds.height;
            g.drawRect(offsetX, offsetY, iw, ih);
            g.drawImage(this.image, offsetX, offsetY, iw, ih, null);
        }
    }

    public static class RotateDriver {
        private Animator animator;
        private GGlassPane glassPane;
        private RotatePainter rotatePainter;

        RotateDriver(GGlassPane glassPane, Component component) {
            this.rotatePainter = new RotatePainter(component);
            this.glassPane = glassPane;
            double start = 0.0;
            double max = 1.0;
            this.animator = PropertySetter.createAnimator((int)1000, (Object)this, (String)"percentComplete", (Object[])new Double[]{start, max});
            this.animator.setAcceleration(0.2f);
            this.animator.setDeceleration(0.8f);
            this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

                public void end() {
                    this.done();
                }
            });
            glassPane.addPainter((GGlassPanePainter)this.rotatePainter);
            this.animator.start();
        }

        public void setPercentComplete(double percentComplete) {
            this.rotatePainter.setPercentComplete(percentComplete);
            this.glassPane.repaint();
        }

        void cancel() {
            this.animator.stop();
            this.done();
        }

        void done() {
            this.glassPane.repaint();
            this.glassPane.removePainter((GGlassPanePainter)this.rotatePainter);
        }
    }

    static class ComponentToComponentPainter
    extends BasicAnimationPainter {
        private Image startImage;
        private Image endImage;
        private Component startComponent;
        private Component endComponent;

        ComponentToComponentPainter(Component startComponent, Component endComponent) {
            this.startComponent = startComponent;
            this.endComponent = endComponent;
            this.startImage = this.paintImage(startComponent);
            this.endImage = this.paintImage(endComponent);
        }

        public void paint(GGlassPane glassPane, Graphics graphics) {
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            Composite originalComposite = g2d.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), (float)(1.0 - this.percentComplete));
            g2d.setComposite(alphaComposite);
            Rectangle startBounds = this.startComponent.getBounds();
            startBounds = SwingUtilities.convertRectangle(this.startComponent.getParent(), startBounds, (Component)glassPane);
            Rectangle endBounds = this.endComponent.getBounds();
            endBounds = SwingUtilities.convertRectangle(this.endComponent.getParent(), endBounds, (Component)glassPane);
            Point startPoint = startBounds.getLocation();
            Point endPoint = endBounds.getLocation();
            int distanceX = endPoint.x - startPoint.x;
            int distanceY = endPoint.y - startPoint.y;
            double transition = 1.0 - this.percentComplete;
            double currentX = (double)endPoint.x - (double)distanceX * transition;
            double currentY = (double)endPoint.y - (double)distanceY * transition;
            int scaledWidth = (int)((double)startBounds.width * transition);
            int scaledHeight = (int)((double)startBounds.height * transition);
            scaledWidth = endBounds.width < startBounds.width ? Math.max(scaledWidth, endBounds.width) : Math.min(scaledWidth, endBounds.width);
            scaledHeight = endBounds.height < startBounds.height ? Math.max(scaledHeight, endBounds.height) : Math.min(scaledHeight, endBounds.height);
            g2d.drawImage(this.startImage, (int)currentX, (int)currentY, scaledWidth, scaledHeight, null);
            alphaComposite = AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), (float)this.percentComplete);
            g2d.setComposite(alphaComposite);
            currentX = (double)endPoint.x - (double)distanceX * transition;
            currentY = (double)endPoint.y - (double)distanceY * transition;
            scaledWidth = (int)((double)endBounds.width * this.percentComplete);
            scaledHeight = (int)((double)endBounds.height * this.percentComplete);
            g2d.drawImage(this.endImage, (int)currentX, (int)currentY, scaledWidth, scaledHeight, null);
            g2d.setComposite(originalComposite);
        }
    }

    public static class ComponentToComponentDriver
    extends BasicAnimationDriver {
        ComponentToComponentDriver(GGlassPane glassPane, Component fromComponent, Component toComponent) {
            super(glassPane, new ComponentToComponentPainter(fromComponent, toComponent));
        }
    }

    private static class UserDefinedPainter
    extends BasicAnimationPainter {
        private AnimationPainter painter;

        UserDefinedPainter(AnimationPainter painter) {
            this.painter = painter;
        }

        public void paint(GGlassPane glassPane, Graphics graphics) {
            this.painter.paint(glassPane, graphics, this.percentComplete);
        }
    }

    public static abstract class BasicAnimationPainter
    implements GGlassPanePainter {
        protected double percentComplete = 0.0;

        void setPercentComplete(double percent) {
            this.percentComplete = percent;
        }

        protected Image paintImage(Component component) {
            Rectangle bounds = component.getBounds();
            BufferedImage bufferedImage = new BufferedImage(bounds.width, bounds.height, 2);
            Graphics g = bufferedImage.getGraphics();
            component.paint(g);
            g.dispose();
            return bufferedImage;
        }
    }

    public static class BasicAnimationDriver {
        protected Animator animator;
        protected BasicAnimationPainter painter;
        protected GGlassPane glassPane;

        protected BasicAnimationDriver(GGlassPane glassPane, BasicAnimationPainter painter) {
            this.glassPane = glassPane;
            this.painter = painter;
            double start = 0.0;
            double max = 1.0;
            this.animator = PropertySetter.createAnimator((int)2000, (Object)this, (String)"percentComplete", (Object[])new Double[]{start, max});
            this.animator.setAcceleration(0.2f);
            this.animator.setDeceleration(0.8f);
            this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

                public void end() {
                    this.done();
                }
            });
            glassPane.addPainter((GGlassPanePainter)painter);
            this.animator.start();
        }

        public void setPercentComplete(double percent) {
            this.painter.setPercentComplete(percent);
            this.glassPane.repaint();
        }

        void done() {
            this.painter.setPercentComplete(0.0);
            this.glassPane.repaint();
            this.glassPane.removePainter((GGlassPanePainter)this.painter);
        }
    }

    private static class PointToComponentPainter
    implements GGlassPanePainter {
        private Image image;
        private Component component;
        private double percentComplete = 0.0;
        private Point startPoint;

        PointToComponentPainter(Point startPoint, Component component) {
            this.startPoint = startPoint;
            this.component = component;
            this.image = ImageUtils.createImage((Component)component);
        }

        void setPercentComplete(double percent) {
            this.percentComplete = percent;
        }

        public void paint(GGlassPane glassPane, Graphics graphics) {
            Graphics2D g2d = (Graphics2D)graphics;
            Rectangle defaultBounds = this.component.getBounds();
            defaultBounds = SwingUtilities.convertRectangle(this.component.getParent(), defaultBounds, (Component)glassPane);
            Point endPoint = defaultBounds.getLocation();
            int distanceX = endPoint.x - this.startPoint.x;
            int distanceY = endPoint.y - this.startPoint.y;
            double currentX = (double)endPoint.x - (double)distanceX * (1.0 - this.percentComplete);
            double currentY = (double)endPoint.y - (double)distanceY * (1.0 - this.percentComplete);
            int scaledWidth = (int)((double)defaultBounds.width * this.percentComplete);
            int scaledHeight = (int)((double)defaultBounds.height * this.percentComplete);
            g2d.drawImage(this.image, (int)currentX, (int)currentY, scaledWidth, scaledHeight, null);
        }
    }

    public static class PointToComponentDriver {
        private Animator animator;
        private PointToComponentPainter painter;
        private GGlassPane glassPane;

        PointToComponentDriver(GGlassPane glassPane, Component fromComponent, Component toComponent) {
            this.glassPane = glassPane;
            this.painter = new PointToComponentPainter(this.getStartPointFromComponent(fromComponent), toComponent);
            double start = 0.0;
            double max = 1.0;
            this.animator = PropertySetter.createAnimator((int)500, (Object)this, (String)"percentComplete", (Object[])new Double[]{start, max});
            this.animator.setAcceleration(0.2f);
            this.animator.setDeceleration(0.8f);
            this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

                public void end() {
                    this.done();
                }
            });
            glassPane.addPainter((GGlassPanePainter)this.painter);
            this.animator.start();
        }

        private Point getStartPointFromComponent(Component component) {
            if (SwingUtilities.isDescendingFrom(component, (Component)this.glassPane)) {
                Rectangle startBounds = component.getBounds();
                Point relativeStartCenter = new Point((int)startBounds.getCenterX(), (int)startBounds.getCenterY());
                return SwingUtilities.convertPoint(component.getParent(), relativeStartCenter, (Component)this.glassPane);
            }
            Rectangle startBounds = component.getBounds();
            Point relativeStartCenter = new Point((int)startBounds.getCenterX(), (int)startBounds.getCenterY());
            return SwingUtilities.convertPoint(component.getParent(), relativeStartCenter, (Component)this.glassPane);
        }

        public void setPercentComplete(double percent) {
            this.painter.setPercentComplete(percent);
            this.glassPane.repaint();
        }

        void done() {
            this.painter.setPercentComplete(0.0);
            this.glassPane.repaint();
            this.glassPane.removePainter((GGlassPanePainter)this.painter);
        }
    }

    private static class FocusPainter
    implements GGlassPanePainter {
        private Image image;
        private Component component;
        private double magnification = 0.0;
        private double percentComplete = 0.0;
        private double max;

        FocusPainter(Component component, double max) {
            this.component = component;
            this.max = max;
            this.image = ImageUtils.createImage((Component)component);
        }

        void setPercentComplete(double percent) {
            this.percentComplete = percent;
        }

        public void paint(GGlassPane glassPane, Graphics g) {
            Color gray = Color.GRAY;
            gray = new Color(gray.getRed(), gray.getGreen(), gray.getBlue());
            Graphics2D g2d = (Graphics2D)g;
            Composite originaComposite = g2d.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), (float)this.percentComplete);
            g2d.setComposite(alphaComposite);
            g.setColor(gray);
            Rectangle displayBounds = glassPane.getBounds();
            g.fillRect(displayBounds.x, displayBounds.y, displayBounds.width, displayBounds.height);
            g2d.setComposite(originaComposite);
            Rectangle defaultBounds = this.component.getBounds();
            double emphasis = 1.0 + this.magnification * this.percentComplete;
            int width = (int)((double)defaultBounds.width * emphasis);
            int height = (int)((double)defaultBounds.height * emphasis);
            Rectangle emphasizedBounds = new Rectangle(defaultBounds.x, defaultBounds.y, width, height);
            emphasizedBounds = SwingUtilities.convertRectangle(this.component.getParent(), emphasizedBounds, (Component)glassPane);
            double asPercent = this.percentComplete * (1.0 / this.max);
            double displayCenterX = displayBounds.getCenterX();
            double displayCenterY = displayBounds.getCenterY();
            double currentCenterX = emphasizedBounds.getCenterX();
            double currentCenterY = emphasizedBounds.getCenterY();
            double deltaCenterX = displayCenterX - currentCenterX;
            double deltaCenterY = displayCenterY - currentCenterY;
            double progressX = deltaCenterX * asPercent;
            double progressY = deltaCenterY * asPercent;
            double newCenterX = currentCenterX + progressX;
            double newCenterY = currentCenterY + progressY;
            int x = (int)(newCenterX - (double)(width >> 1));
            int y = (int)(newCenterY - (double)(height >> 1));
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(this.image, x, y, width, height, null);
        }
    }

    public static class FocusDriver {
        private Animator animator;
        private FocusPainter painter;
        private GGlassPane glassPane;

        FocusDriver(GGlassPane glassPane, Component component) {
            this.glassPane = glassPane;
            double start = 0.0;
            double max = 0.5;
            this.painter = new FocusPainter(component, max);
            this.animator = PropertySetter.createAnimator((int)1000, (Object)this, (String)"percentComplete", (Object[])new Double[]{start, max, max, max, max, max, start});
            this.animator.setAcceleration(0.2f);
            this.animator.setDeceleration(0.8f);
            this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

                public void end() {
                    this.done();
                }
            });
            glassPane.addPainter((GGlassPanePainter)this.painter);
            this.animator.start();
        }

        public void setPercentComplete(double percent) {
            this.painter.setPercentComplete(percent);
            this.glassPane.repaint();
        }

        void done() {
            this.painter.setPercentComplete(0.0);
            this.glassPane.repaint();
            this.glassPane.removePainter((GGlassPanePainter)this.painter);
        }
    }

    public static class SwingAnimationCallbackDriver {
        private Animator animator;
        private SwingAnimationCallback callback;

        SwingAnimationCallbackDriver(SwingAnimationCallback swingCallback, int duration) {
            this.callback = swingCallback;
            double start = 0.0;
            double max = 1.0;
            if (!animationEnabled) {
                this.callback.done();
                return;
            }
            this.animator = PropertySetter.createAnimator((int)duration, (Object)this, (String)"percentComplete", (Object[])new Double[]{start, max});
            this.animator.setAcceleration(0.2f);
            this.animator.setDeceleration(0.8f);
            this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

                public void end() {
                    callback.done();
                }
            });
            this.animator.start();
        }

        public void setPercentComplete(double percent) {
            this.callback.progress(percent);
        }
    }
}

