/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.util;

import com.googlecode.d2j.DexException;
import ghidra.util.NumericUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public final class Leb128 {
    private Leb128() {
    }

    public static int unsignedLeb128Size(int value) {
        int remaining = value >> 7;
        int count = 0;
        while (remaining != 0) {
            remaining >>= 7;
            ++count;
        }
        return count + 1;
    }

    public static int signedLeb128Size(int value) {
        int end;
        int remaining = value >> 7;
        int count = 0;
        boolean hasMore = true;
        int n = end = (value & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1) != (value >> 6 & 1);
            value = remaining;
            remaining >>= 7;
            ++count;
        }
        return count;
    }

    public static int readSignedLeb128(byte[] bytes) {
        return Leb128.readSignedLeb128(new ByteArrayInputStream(bytes));
    }

    public static int readSignedLeb128(ByteArrayInputStream in) {
        int cur;
        int result = 0;
        int count = 0;
        int signBits = -1;
        do {
            cur = in.read() & 0xFF;
            result |= (cur & 0x7F) << count * 7;
            signBits <<= 7;
        } while ((cur & 0x80) == 128 && ++count < 5);
        if ((cur & 0x80) == 128) {
            throw new DexException("invalid LEB128 sequence");
        }
        if ((signBits >> 1 & result) != 0) {
            result |= signBits;
        }
        return result;
    }

    public static int readUnsignedLeb128(byte[] bytes) {
        return Leb128.readUnsignedLeb128(new ByteArrayInputStream(bytes));
    }

    public static int readUnsignedLeb128(ByteArrayInputStream in) {
        int cur;
        int result = 0;
        int count = 0;
        do {
            cur = in.read() & 0xFF;
            result |= (cur & 0x7F) << count * 7;
        } while ((cur & 0x80) == 128 && ++count < 5);
        if ((cur & 0x80) == 128) {
            throw new DexException("invalid LEB128 sequence");
        }
        return result;
    }

    public static void writeUnsignedLeb128(ByteArrayOutputStream out, int value) {
        for (int remaining = value >>> 7; remaining != 0; remaining >>>= 7) {
            out.write((byte)(value & 0x7F | 0x80));
            value = remaining;
        }
        out.write((byte)(value & 0x7F));
    }

    public static void writeSignedLeb128(ByteArrayOutputStream out, int value) {
        int end;
        int remaining = value >> 7;
        boolean hasMore = true;
        int n = end = (value & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1) != (value >> 6 & 1);
            out.write((byte)(value & 0x7F | (hasMore ? 128 : 0)));
            value = remaining;
            remaining >>= 7;
        }
    }

    public static void main(String[] args) {
        System.out.println(Leb128.readUnsignedLeb128(NumericUtilities.convertStringToBytes((String)"807f")));
    }
}

