/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img3;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.ios.img3.Img3;
import ghidra.file.formats.ios.img3.Img3Constants;
import ghidra.file.formats.ios.img3.tag.DataTag;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileCacheEntry;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;

@FileSystemInfo(type="img3", description="iOS Img3", factory=GFileSystemBaseFactory.class)
public class Img3FileSystem
extends GFileSystemBase {
    private Img3 header;
    private List<GFile> dataFileList = new ArrayList<GFile>();

    public Img3FileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        byte[] bytes = this.provider.readBytes(0L, (long)Img3Constants.IMG3_SIGNATURE_LENGTH);
        return Arrays.equals(bytes, Img3Constants.IMG3_SIGNATURE_BYTES);
    }

    public void open(TaskMonitor monitor) throws IOException {
        monitor.setMessage("Opening IMG3...");
        this.header = new Img3(this.provider);
        if (!this.header.getMagic().equals("Img3")) {
            throw new IOException("Unable to decrypt file: invalid IMG3 file!");
        }
        List<DataTag> tags = this.header.getTags(DataTag.class);
        monitor.initialize((long)tags.size());
        for (int i = 0; i < tags.size() && !monitor.isCancelled(); ++i) {
            monitor.setProgress((long)i);
            DataTag dataTag = tags.get(i);
            String filename = this.getDataTagFilename(dataTag, i, tags.size() > 1);
            GFileImpl dataFile = GFileImpl.fromPathString((GFileSystem)this, (GFile)this.root, (String)filename, null, (boolean)false, (long)dataTag.getTotalLength());
            this.dataFileList.add((GFile)dataFile);
        }
    }

    private String getDataTagFilename(DataTag dataTag, int index, boolean isMulti) {
        String filename = dataTag.getMagic();
        return isMulti ? filename + index : filename;
    }

    public void close() throws IOException {
        super.close();
    }

    public InputStream getData(GFile file, TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        FSRLRoot fsFSRL = this.getFSRL();
        if (fsFSRL.getNestingDepth() < 3) {
            throw new CryptoException("Unable to decrypt IMG3 data because IMG3 crypto keys are specific to the container it is embedded in and this IMG3 was not in a container");
        }
        List<DataTag> tags = this.header.getTags(DataTag.class);
        for (int i = 0; i < tags.size(); ++i) {
            DataTag dataTag = tags.get(i);
            String filename = this.getDataTagFilename(dataTag, i, tags.size() > 1);
            if (!file.getName().equals(filename)) continue;
            FileCacheEntry derivedFile = this.fsService.getDerivedFile(fsFSRL.getContainer(), "decrypted_img3_" + filename, srcFile -> dataTag.getDecryptedInputStream(fsFSRL.getName(2), fsFSRL.getName(1)), monitor);
            return new FileInputStream(derivedFile.file);
        }
        throw new IOException("Unable to get DATA for " + file.getPath());
    }

    public Icon getIcon() {
        return null;
    }

    public String getInfo(GFile file, TaskMonitor monitor) {
        return null;
    }

    public List<GFile> getListing(GFile directory) {
        if (directory == null || directory.equals(this.root)) {
            if (this.dataFileList.isEmpty() && this.header != null) {
                List<DataTag> tags = this.header.getTags(DataTag.class);
                for (int i = 0; i < tags.size(); ++i) {
                    DataTag dataTag = tags.get(i);
                    Object name = dataTag.getMagic();
                    if (tags.size() > 1) {
                        name = (String)name + i;
                    }
                    GFileImpl dataFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)name, (boolean)false, (long)dataTag.getTotalLength(), null);
                    this.dataFileList.add((GFile)dataFile);
                }
            }
            return this.dataFileList;
        }
        return new ArrayList<GFile>();
    }

    public boolean isDirectory(GFileImpl directory) {
        return directory.equals((Object)this.root);
    }

    public boolean isFile(GFileImpl file) {
        return !file.equals((Object)this.root);
    }
}

