/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.component.hover.DecompilerHoverService;
import ghidra.app.plugin.core.hover.AbstractReferenceHover;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import javax.swing.JComponent;

public class ReferenceDecompilerHover
extends AbstractReferenceHover
implements DecompilerHoverService {
    protected static final String NAME = "Decompiler Reference Viewer";
    private static final String DESCRIPTION = "Shows \"referred to\" code and data from the decompiler.";
    private static final int PRIORITY = 25;

    public ReferenceDecompilerHover(PluginTool tool) {
        super(tool, 25);
    }

    public void initializeOptions() {
        this.options = this.tool.getOptions("Decompiler Popups");
        this.options.setOptionsHelpLocation(new HelpLocation("CodeBrowserPlugin", "MouseHover"));
        HelpLocation help = new HelpLocation("CodeBrowserPlugin", "ReferenceHover");
        this.options.getOptions(NAME).setOptionsHelpLocation(help);
        this.options.registerOption(NAME, (Object)true, null, DESCRIPTION);
        this.options.registerOption("Decompiler Reference Viewer.Dialog Height", (Object)400, help, "Height of the popup window");
        this.options.registerOption("Decompiler Reference Viewer.Dialog Width", (Object)600, help, "Width of the popup window");
        this.setOptions((Options)this.options, NAME);
        this.options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public JComponent getHoverComponent(Program program, ProgramLocation location, FieldLocation fieldLocation, Field field) {
        if (!this.enabled || location == null) {
            return null;
        }
        Address refAddr = location.getRefAddress();
        if (refAddr == null) {
            return null;
        }
        Function other = program.getListing().getFunctionAt(refAddr);
        if (other != null) {
            return null;
        }
        return super.getHoverComponent(program, location, fieldLocation, field);
    }
}

