/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.MenuData;
import ghidra.app.actions.AbstractFindReferencesDataTypeAction;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;

public class FindReferencesToDataTypeAction
extends AbstractFindReferencesDataTypeAction {
    private final DecompilerController controller;

    public FindReferencesToDataTypeAction(String owner, PluginTool tool, DecompilerController controller) {
        super(tool, "Find References To", owner, DEFAULT_KEY_STROKE);
        this.controller = controller;
        this.setPopupMenuData(new MenuData(new String[]{"References", "Find Uses of "}));
    }

    public DataType getDataType(ActionContext context) {
        return DecompilerUtils.getDataType((DecompilerActionContext)context);
    }

    protected String getDataTypeField() {
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        if (tokenAtCursor instanceof ClangFieldToken) {
            return tokenAtCursor.getText();
        }
        return null;
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DecompilerActionContext)) {
            return false;
        }
        DecompilerActionContext decompilerContext = (DecompilerActionContext)context;
        return decompilerContext.checkActionEnablement(() -> {
            DataType dataType = this.getDataType(context);
            this.updateMenuName(dataType);
            return super.isEnabledForContext(context);
        });
    }

    public void actionPerformed(ActionContext context) {
        DecompilerActionContext decompilerContext = (DecompilerActionContext)context;
        decompilerContext.performAction(() -> super.actionPerformed(context));
    }

    private void updateMenuName(DataType type) {
        if (type == null) {
            return;
        }
        String typeName = type.getName();
        String menuName = "Find Uses of " + typeName;
        String fieldName = this.getDataTypeField();
        if (fieldName != null) {
            menuName = menuName + "." + fieldName;
        }
        MenuData data = this.getPopupMenuData().cloneData();
        data.setMenuPath(new String[]{"References", menuName});
        this.setPopupMenuData(data);
    }
}

