/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.message;

import io.netty.channel.Channel;
import java.util.Map;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.io.InputStreamHandler;
import org.rzo.netty.ahessian.io.OutputStreamHandler;
import org.rzo.netty.ahessian.rpc.message.GroupedMessage;
import org.rzo.netty.ahessian.session.ServerSessionFilter;
import org.rzo.netty.ahessian.session.Session;

public class HessianRPCCallMessage
implements Constants,
GroupedMessage {
    String _method;
    Object[] _args;
    Map<Object, Object> _headers;
    transient OutputStreamHandler _outputStreamEncoder;
    boolean _hasSessionFilter = false;
    transient boolean _isServer = false;
    transient Session _session;
    transient InputStreamHandler _handler;

    public Map<Object, Object> getHeaders() {
        return this._headers;
    }

    public HessianRPCCallMessage(String method, Object[] args, Map<Object, Object> headers, OutputStreamHandler outputStreamEncoder) {
        this._method = method;
        this._args = args;
        this._headers = headers;
        this._outputStreamEncoder = outputStreamEncoder;
    }

    public String getMethod() {
        return this._method;
    }

    public Object[] getArgs() {
        return this._args;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("HessianRPCCallMessage");
        if (this._headers != null && this._headers.get(CALL_ID_HEADER_KEY) != null) {
            sb.append('#');
            sb.append(this._headers.get(CALL_ID_HEADER_KEY));
        }
        sb.append('[');
        sb.append(this._method);
        sb.append('(');
        if (this._args != null) {
            for (int i = 0; i < this._args.length; ++i) {
                if (this._args[i] != null) {
                    sb.append(this._args[i].toString());
                } else {
                    sb.append("null");
                }
                if (i == this._args.length - 1) continue;
                sb.append(',');
            }
        }
        sb.append(")]");
        return sb.toString();
    }

    public boolean isValid() {
        boolean result = false;
        if (!this._hasSessionFilter || !this._isServer) {
            result = this._outputStreamEncoder != null && this._outputStreamEncoder.getBuffer() != null && this._outputStreamEncoder.getBuffer().getContext() != null && this._outputStreamEncoder.getBuffer().getContext().channel().isActive();
        } else if (this._outputStreamEncoder != null && this._outputStreamEncoder.getBuffer() != null && this._outputStreamEncoder.getBuffer().getContext() != null) {
            ServerSessionFilter session = ServerSessionFilter.getServerSessionFilter(this._outputStreamEncoder.getBuffer().getContext());
            result = session == null || session.isValid();
        }
        return result;
    }

    public Channel getChannel() {
        if (this._outputStreamEncoder != null && this._outputStreamEncoder.getBuffer() != null && this._outputStreamEncoder.getBuffer().getContext() != null) {
            return this._outputStreamEncoder.getBuffer().getContext().channel();
        }
        return null;
    }

    public void setHasSessionFilter(boolean hasSessionFilter) {
        this._hasSessionFilter = hasSessionFilter;
        this._headers.put(HAS_SESSION_FILTER_HEADER_KEY, this._hasSessionFilter);
    }

    public void setServer(boolean isServer) {
        this._isServer = isServer;
    }

    @Override
    public Integer getGroup() {
        if (this._headers == null || this._headers.get(GROUP_HEADER_KEY) == null) {
            return 0;
        }
        return (Integer)this._headers.get(GROUP_HEADER_KEY);
    }

    public void setSession(Session session) {
        this._session = session;
    }

    public Session getSession() {
        return this._session;
    }

    public void setHandler(InputStreamHandler handler) {
        this._handler = handler;
    }

    public InputStreamHandler getHandler() {
        return this._handler;
    }
}

