/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.checksums;

import ghidra.app.plugin.core.checksums.ChecksumAlgorithm;
import ghidra.app.plugin.core.checksums.ComputeChecksumsProvider;
import ghidra.app.plugin.core.checksums.MemoryInputStream;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;

public class Adler32ChecksumAlgorithm
extends ChecksumAlgorithm {
    public Adler32ChecksumAlgorithm() {
        super("Adler-32");
    }

    @Override
    public void updateChecksum(Memory memory, AddressSetView addrSet, TaskMonitor monitor, ComputeChecksumsProvider provider) throws MemoryAccessException, CancelledException {
        if (provider == null) {
            this.updateChecksum(memory, addrSet, monitor, false, false);
        } else {
            this.updateChecksum(memory, addrSet, monitor, provider.isOnes(), provider.isTwos());
        }
    }

    public void updateChecksum(Memory memory, AddressSetView addrSet, TaskMonitor monitor, boolean onesComp, boolean twosComp) throws MemoryAccessException, CancelledException {
        long sum;
        byte[] bytes = new byte[1024];
        try (CheckedInputStream cis = new CheckedInputStream(new MemoryInputStream(memory, addrSet), new Adler32());){
            while (cis.read(bytes) > 0) {
                if (!monitor.isCancelled()) continue;
                throw new CancelledException();
            }
            sum = cis.getChecksum().getValue();
        }
        catch (IOException e) {
            throw new MemoryAccessException(e.getMessage());
        }
        if (onesComp) {
            sum ^= 0xFFFFFFFFFFFFFFFFL;
        } else if (twosComp) {
            sum = -sum;
        }
        this.checksum = Adler32ChecksumAlgorithm.toArray(sum, 4);
    }

    @Override
    public boolean supportsDecimal() {
        return true;
    }
}

