/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.fieldpanel.support.ViewerPosition;
import ghidra.GhidraOptions;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramHighlightPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.events.ViewChangedPluginEvent;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.codebrowser.CodeBrowserPluginInterface;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.app.plugin.core.codebrowser.MarkerServiceBackgroundColorModel;
import ghidra.app.plugin.core.codebrowser.actions.ClearSelectionAction;
import ghidra.app.plugin.core.codebrowser.actions.SelectAllAction;
import ghidra.app.plugin.core.codebrowser.actions.SelectComplementAction;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.services.ButtonPressedListener;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.CodeFormatService;
import ghidra.app.services.CodeViewerService;
import ghidra.app.services.CoordinatedListingPanelListener;
import ghidra.app.services.FieldMouseHandlerService;
import ghidra.app.services.GoToService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.ViewManagerService;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.PluginConstants;
import ghidra.app.util.ProgramDropProvider;
import ghidra.app.util.query.TableService;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.format.FormatModelListener;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.listingpanel.MarginProvider;
import ghidra.app.util.viewer.listingpanel.OverviewProvider;
import ghidra.app.util.viewer.options.ListingDisplayOptionsEditor;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.OptionsEditor;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.ManualViewerCommandEditor;
import ghidra.util.ManualViewerCommandWrappedOption;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.CustomLoadingAddressTableModel;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.table.TableModelLoader;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom.Element;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Code Viewer", description="This plugin provides the main program listing display window. It also includes the header component which allows the various program fields to be arranged as desired.  In addition, this plugin provides the \"CodeViewerService\" which allows other plugins to extend the basic functionality to include such features as flow arrows, margin markers and difference tracking.  The listing component created by this plugin generates ProgramLocation events and ProgramSelection events as the user moves the cursor and makes selections respectively.", servicesRequired={ProgramManager.class, GoToService.class, ClipboardService.class}, servicesProvided={CodeViewerService.class, CodeFormatService.class, FieldMouseHandlerService.class}, eventsConsumed={ProgramSelectionPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramClosedPluginEvent.class, ProgramLocationPluginEvent.class, ViewChangedPluginEvent.class, ProgramHighlightPluginEvent.class}, eventsProduced={ProgramLocationPluginEvent.class, ProgramSelectionPluginEvent.class})
public class CodeBrowserPlugin
extends Plugin
implements CodeViewerService,
CodeFormatService,
OptionsChangeListener,
FormatModelListener,
DomainObjectListener,
CodeBrowserPluginInterface {
    private static final Color CURSOR_LINE_COLOR = GhidraOptions.DEFAULT_CURSOR_LINE_COLOR;
    private static final String CURSOR_COLOR = "Cursor.Cursor Color - Focused";
    private static final String UNFOCUSED_CURSOR_COLOR = "Cursor.Cursor Color - Unfocused";
    private static final String BLINK_CURSOR = "Cursor.Blink Cursor";
    private static final String MOUSE_WHEEL_HORIZONTAL_SCROLLING = "Mouse.Horizontal Scrolling";
    private ImageIcon CURSOR_LOC_ICON = ResourceManager.loadImage((String)"images/cursor_arrow_flipped.gif");
    private CodeViewerProvider connectedProvider;
    private List<CodeViewerProvider> disconnectedProviders = new ArrayList<CodeViewerProvider>();
    private FormatManager formatMgr;
    private ViewManagerService viewManager;
    private MarkerService markerService;
    private AddressSetView currentView;
    private Program currentProgram;
    private boolean selectionChanging;
    private MarkerSet currentSelectionMarkers;
    private MarkerSet currentHighlightMarkers;
    private MarkerSet currentCursorMarkers;
    private ChangeListener markerChangeListener;
    private FocusingMouseListener focusingMouseListener = new FocusingMouseListener();
    private DockingAction tableFromSelectionAction;
    private Color cursorHighlightColor;
    private boolean isHighlightCursorLine;
    private ProgramDropProvider dndProvider;

    public CodeBrowserPlugin(PluginTool tool) {
        super(tool);
        tool.registerOptionsNameChange("Browser Fields", "Listing Fields");
        tool.registerOptionsNameChange("Browser Display", "Listing Display");
        tool.registerOptionsNameChange("Browser Popups", "Listing Popups");
        ToolOptions displayOptions = tool.getOptions("Listing Display");
        ToolOptions fieldOptions = tool.getOptions("Listing Fields");
        displayOptions.registerOptionsEditor((OptionsEditor)new ListingDisplayOptionsEditor((Options)displayOptions));
        displayOptions.setOptionsHelpLocation(new HelpLocation(this.getName(), "Listing Display"));
        fieldOptions.setOptionsHelpLocation(new HelpLocation(this.getName(), "Listing Display"));
        this.formatMgr = new FormatManager(displayOptions, fieldOptions);
        this.formatMgr.addFormatModelListener(this);
        this.formatMgr.setServiceProvider((ServiceProvider)tool);
        this.connectedProvider = new CodeViewerProvider(this, this.formatMgr, true);
        tool.showComponentProvider((ComponentProvider)this.connectedProvider, true);
        this.initOptions((Options)fieldOptions);
        this.initDisplayOptions((Options)displayOptions);
        this.initMiscellaneousOptions();
        this.initActions();
        displayOptions.addOptionsChangeListener((OptionsChangeListener)this);
        fieldOptions.addOptionsChangeListener((OptionsChangeListener)this);
        tool.setDefaultComponent((ComponentProvider)this.connectedProvider);
        this.markerChangeListener = new MarkerChangeListener(this.connectedProvider);
        this.registerServiceProvided(FieldMouseHandlerService.class, this.connectedProvider.getFieldNavigator());
        this.createActions();
    }

    private void createActions() {
        SelectAllAction selectAllAction = new SelectAllAction(this.getName());
        selectAllAction.getMenuBarData().setMenuSubGroup("a");
        this.tool.addAction((DockingActionIf)selectAllAction);
        ClearSelectionAction selectNoneAction = new ClearSelectionAction(this.getName());
        selectNoneAction.getMenuBarData().setMenuSubGroup("a");
        this.tool.addAction((DockingActionIf)selectNoneAction);
        SelectComplementAction selectComplementAction = new SelectComplementAction(this.getName());
        selectComplementAction.getMenuBarData().setMenuSubGroup("b");
        this.tool.addAction((DockingActionIf)selectComplementAction);
    }

    void viewChanged(AddressSetView addrSet) {
        ProgramLocation currLoc = this.getCurrentLocation();
        this.currentView = addrSet;
        if (addrSet != null && !addrSet.isEmpty()) {
            this.connectedProvider.setView(addrSet);
            if (currLoc != null && addrSet.contains(currLoc.getAddress())) {
                this.goTo(currLoc, true);
            }
        } else {
            this.connectedProvider.setView((AddressSetView)new AddressSet());
        }
        this.updateBackgroundColorModel();
        this.setHighlight(this.connectedProvider.getHighlight());
        this.setSelection(this.connectedProvider.getSelection());
    }

    protected void init() {
        ClipboardService clipboardService;
        this.markerService = (MarkerService)this.tool.getService(MarkerService.class);
        if (this.markerService != null) {
            this.markerService.addChangeListener(this.markerChangeListener);
        }
        this.updateBackgroundColorModel();
        if (this.viewManager == null) {
            this.viewManager = (ViewManagerService)this.tool.getService(ViewManagerService.class);
        }
        if ((clipboardService = (ClipboardService)this.tool.getService(ClipboardService.class)) != null) {
            this.connectedProvider.setClipboardService(clipboardService);
            for (CodeViewerProvider provider : this.disconnectedProviders) {
                provider.setClipboardService(clipboardService);
            }
        }
    }

    private void updateBackgroundColorModel() {
        ListingPanel listingPanel = this.connectedProvider.getListingPanel();
        if (this.markerService != null) {
            AddressIndexMap indexMap = this.connectedProvider.getListingPanel().getAddressIndexMap();
            listingPanel.setBackgroundColorModel(new MarkerServiceBackgroundColorModel(this.markerService, indexMap));
        } else {
            listingPanel.setBackgroundColorModel(null);
        }
    }

    @Override
    public CodeViewerProvider createNewDisconnectedProvider() {
        ListingHoverService[] hoverServices;
        CodeViewerProvider newProvider = new CodeViewerProvider(this, this.formatMgr.createClone(), false);
        newProvider.setClipboardService((ClipboardService)this.tool.getService(ClipboardService.class));
        this.disconnectedProviders.add(newProvider);
        if (this.dndProvider != null) {
            newProvider.addProgramDropProvider(this.dndProvider);
        }
        this.tool.showComponentProvider((ComponentProvider)newProvider, true);
        for (ListingHoverService hoverService : hoverServices = (ListingHoverService[])this.tool.getServices(ListingHoverService.class)) {
            newProvider.getListingPanel().addHoverService(hoverService);
        }
        return newProvider;
    }

    public void readDataState(SaveState saveState) {
        ProgramManager programManagerService = (ProgramManager)this.tool.getService(ProgramManager.class);
        if (this.connectedProvider != null) {
            this.connectedProvider.readDataState(saveState);
        }
        int numDisconnected = saveState.getInt("Num Disconnected", 0);
        for (int i = 0; i < numDisconnected; ++i) {
            Program program;
            Element xmlElement = saveState.getXmlElement("Provider" + i);
            SaveState providerSaveState = new SaveState(xmlElement);
            String programPath = providerSaveState.getString("Program Path", "");
            DomainFile file = this.tool.getProject().getProjectData().getFile(programPath);
            if (file == null || (program = programManagerService.openProgram(file)) == null) continue;
            CodeViewerProvider provider = this.createNewDisconnectedProvider();
            provider.doSetProgram(program);
            provider.readDataState(providerSaveState);
        }
        FieldSelection highlight = new FieldSelection();
        highlight.load(saveState);
        if (!highlight.isEmpty()) {
            this.setHighlight(highlight);
        }
    }

    private void setHighlight(FieldSelection highlight) {
        MarkerSet highlightMarkers = this.getHighlightMarkers(this.currentProgram);
        if (highlight != null && !highlight.isEmpty()) {
            ListingPanel listingPanel = this.connectedProvider.getListingPanel();
            ProgramSelection programHighlight = listingPanel.getProgramSelection(highlight);
            this.connectedProvider.setHighlight(programHighlight);
            this.firePluginEvent(new ProgramHighlightPluginEvent(this.getName(), programHighlight, this.currentProgram));
            if (highlightMarkers != null) {
                highlightMarkers.clearAll();
                highlightMarkers.add(programHighlight);
            }
        } else {
            this.connectedProvider.setHighlight(new ProgramSelection());
            if (highlightMarkers != null) {
                highlightMarkers.clearAll();
            }
        }
    }

    public void writeDataState(SaveState saveState) {
        if (this.connectedProvider != null) {
            this.connectedProvider.writeDataState(saveState);
        }
        saveState.putInt("Num Disconnected", this.disconnectedProviders.size());
        int i = 0;
        for (CodeViewerProvider provider : this.disconnectedProviders) {
            SaveState providerSaveState = new SaveState();
            DomainFile df = provider.getProgram().getDomainFile();
            if (df.getParent() == null) continue;
            String programPathname = df.getPathname();
            providerSaveState.putString("Program Path", programPathname);
            provider.writeDataState(providerSaveState);
            String elementName = "Provider" + i;
            saveState.putXmlElement(elementName, providerSaveState.saveToXml());
            ++i;
        }
        FieldSelection highlight = this.connectedProvider.getListingPanel().getFieldPanel().getHighlight();
        highlight.save(saveState);
    }

    public Object getTransientState() {
        Object[] state = new Object[5];
        FieldPanel fieldPanel = this.connectedProvider.getListingPanel().getFieldPanel();
        state[0] = fieldPanel.getViewerPosition();
        state[1] = this.connectedProvider.getLocation();
        state[2] = this.connectedProvider.getHighlight();
        state[3] = this.connectedProvider.getSelection();
        state[4] = this.currentView;
        return state;
    }

    public void restoreTransientState(Object objectState) {
        Object[] state = (Object[])objectState;
        ViewerPosition vp = (ViewerPosition)state[0];
        ProgramLocation location = (ProgramLocation)state[1];
        ProgramSelection highlight = (ProgramSelection)state[2];
        ProgramSelection selection = (ProgramSelection)state[3];
        this.viewChanged((AddressSetView)state[4]);
        if (location != null) {
            this.connectedProvider.setLocation(location);
        }
        this.setHighlight(highlight);
        if (selection != null) {
            this.connectedProvider.setSelection(selection);
        }
        if (vp != null) {
            FieldPanel fieldPanel = this.connectedProvider.getListingPanel().getFieldPanel();
            fieldPanel.setViewerPosition(vp.getIndex(), vp.getXOffset(), vp.getYOffset());
        }
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramClosedPluginEvent) {
            Program program = ((ProgramClosedPluginEvent)event).getProgram();
            this.programClosed(program);
            return;
        }
        if (event instanceof ProgramActivatedPluginEvent) {
            if (this.currentProgram != null) {
                this.currentProgram.removeListener((DomainObjectListener)this);
            }
            ProgramActivatedPluginEvent evt = (ProgramActivatedPluginEvent)event;
            this.clearMarkers(this.currentProgram);
            this.currentProgram = evt.getActiveProgram();
            if (this.currentProgram != null) {
                this.currentProgram.addListener((DomainObjectListener)this);
                this.currentView = this.currentProgram.getMemory();
            } else {
                this.currentView = new AddressSet();
            }
            this.connectedProvider.doSetProgram(this.currentProgram);
            this.updateHighlightProvider();
            this.updateBackgroundColorModel();
            this.setHighlight(new FieldSelection());
            AddressFactory currentAddressFactory = this.currentProgram != null ? this.currentProgram.getAddressFactory() : null;
            this.setSelection(new ProgramSelection(currentAddressFactory));
        } else if (event instanceof ProgramLocationPluginEvent) {
            ProgramLocationPluginEvent evt = (ProgramLocationPluginEvent)event;
            ProgramLocation location = evt.getLocation();
            if (!this.connectedProvider.setLocation(location) && this.viewManager != null) {
                this.connectedProvider.setView(this.viewManager.addToView(location));
                ListingPanel lp = this.connectedProvider.getListingPanel();
                lp.goTo(location, true);
            }
        } else if (event instanceof ProgramSelectionPluginEvent) {
            ProgramSelectionPluginEvent evt = (ProgramSelectionPluginEvent)event;
            this.setSelection(evt.getSelection());
        } else if (event instanceof ProgramHighlightPluginEvent) {
            ProgramHighlightPluginEvent evt = (ProgramHighlightPluginEvent)event;
            if (evt.getProgram() == this.currentProgram) {
                this.setHighlight(evt.getHighlight());
            }
        } else if (event instanceof ViewChangedPluginEvent) {
            AddressSet view = ((ViewChangedPluginEvent)event).getView();
            this.viewChanged((AddressSetView)view);
        }
    }

    private void programClosed(Program closedProgram) {
        Iterator<CodeViewerProvider> iterator = this.disconnectedProviders.iterator();
        while (iterator.hasNext()) {
            CodeViewerProvider provider = iterator.next();
            if (provider.getProgram() != closedProgram) continue;
            iterator.remove();
            this.removeProvider(provider);
        }
    }

    void removeProvider(CodeViewerProvider provider) {
        this.tool.removeComponentProvider((ComponentProvider)provider);
        provider.dispose();
    }

    public void serviceAdded(Class<?> interfaceClass, Object service) {
        if (interfaceClass == TableService.class) {
            this.tool.addAction((DockingActionIf)this.tableFromSelectionAction);
        }
        if (interfaceClass == ViewManagerService.class && this.viewManager == null) {
            this.viewManager = (ViewManagerService)service;
            this.viewChanged(this.viewManager.getCurrentView());
        }
        if (interfaceClass == MarkerService.class && this.markerService == null) {
            this.markerService = (MarkerService)this.tool.getService(MarkerService.class);
            this.markerService.addChangeListener(this.markerChangeListener);
            this.updateBackgroundColorModel();
            if (this.viewManager != null) {
                this.viewChanged(this.viewManager.getCurrentView());
            }
        }
        if (interfaceClass == ListingHoverService.class) {
            ListingHoverService hoverService = (ListingHoverService)service;
            this.connectedProvider.getListingPanel().addHoverService(hoverService);
            for (CodeViewerProvider provider : this.disconnectedProviders) {
                provider.getListingPanel().addHoverService(hoverService);
            }
            ListingPanel otherPanel = this.connectedProvider.getOtherPanel();
            if (otherPanel != null) {
                otherPanel.addHoverService(hoverService);
            }
        }
    }

    public void serviceRemoved(Class<?> interfaceClass, Object service) {
        if (interfaceClass == TableService.class && this.tool != null) {
            this.tool.removeAction((DockingActionIf)this.tableFromSelectionAction);
        }
        if (service == this.viewManager && this.currentProgram != null) {
            this.viewManager = null;
            this.viewChanged((AddressSetView)this.currentProgram.getMemory());
        }
        if (service == this.markerService) {
            this.markerService.removeChangeListener(this.markerChangeListener);
            this.clearMarkers(this.currentProgram);
            this.markerService = null;
            this.updateBackgroundColorModel();
        }
        if (interfaceClass == ListingHoverService.class) {
            ListingHoverService hoverService = (ListingHoverService)service;
            this.connectedProvider.getListingPanel().removeHoverService(hoverService);
            for (CodeViewerProvider provider : this.disconnectedProviders) {
                provider.getListingPanel().removeHoverService(hoverService);
            }
            ListingPanel otherPanel = this.connectedProvider.getOtherPanel();
            if (otherPanel != null) {
                otherPanel.removeHoverService(hoverService);
            }
        }
    }

    @Override
    public void addOverviewProvider(OverviewProvider overviewProvider) {
        JComponent component = overviewProvider.getComponent();
        component.removeMouseListener(this.focusingMouseListener);
        component.addMouseListener(this.focusingMouseListener);
        this.connectedProvider.getListingPanel().addOverviewProvider(overviewProvider);
    }

    @Override
    public void addMarginProvider(MarginProvider marginProvider) {
        JComponent component = marginProvider.getComponent();
        component.removeMouseListener(this.focusingMouseListener);
        component.addMouseListener(this.focusingMouseListener);
        this.connectedProvider.getListingPanel().addMarginProvider(marginProvider);
    }

    @Override
    public void removeOverviewProvider(OverviewProvider overviewProvider) {
        JComponent component = overviewProvider.getComponent();
        component.removeMouseListener(this.focusingMouseListener);
        this.connectedProvider.getListingPanel().removeOverviewProvider(overviewProvider);
    }

    @Override
    public void removeMarginProvider(MarginProvider marginProvider) {
        JComponent component = marginProvider.getComponent();
        component.removeMouseListener(this.focusingMouseListener);
        this.connectedProvider.getListingPanel().removeMarginProvider(marginProvider);
    }

    @Override
    public void addLocalAction(DockingAction action) {
        this.tool.addLocalAction((ComponentProvider)this.connectedProvider, (DockingActionIf)action);
    }

    @Override
    public void removeLocalAction(DockingAction action) {
        if (this.tool != null) {
            this.tool.removeLocalAction((ComponentProvider)this.connectedProvider, (DockingActionIf)action);
        }
    }

    @Override
    public void addProgramDropProvider(ProgramDropProvider dnd) {
        this.dndProvider = dnd;
        this.connectedProvider.addProgramDropProvider(dnd);
        for (CodeViewerProvider provider : this.disconnectedProviders) {
            provider.addProgramDropProvider(dnd);
        }
    }

    @Override
    public void addButtonPressedListener(ButtonPressedListener listener) {
        this.connectedProvider.getListingPanel().addButtonPressedListener(listener);
    }

    @Override
    public void removeButtonPressedListener(ButtonPressedListener listener) {
        this.connectedProvider.getListingPanel().removeButtonPressedListener(listener);
    }

    @Override
    public void removeHighlightProvider(HighlightProvider highlightProvider, Program highlightProgram) {
        this.connectedProvider.removeHighlightProvider(highlightProvider, highlightProgram);
    }

    @Override
    public void setHighlightProvider(HighlightProvider highlightProvider, Program highlightProgram) {
        this.connectedProvider.setHighlightProvider(highlightProvider, highlightProgram);
    }

    private void updateHighlightProvider() {
        this.connectedProvider.updateHighlightProvider();
    }

    @Override
    public void setListingPanel(ListingPanel lp) {
        this.connectedProvider.setPanel(lp);
        this.viewChanged(this.currentView);
    }

    @Override
    public void setCoordinatedListingPanelListener(CoordinatedListingPanelListener listener) {
        this.connectedProvider.setCoordinatedListingPanelListener(listener);
    }

    @Override
    public void setNorthComponent(JComponent comp) {
        this.connectedProvider.setNorthComponent(comp);
    }

    @Override
    public void removeListingPanel(ListingPanel lp) {
        if (this.isDisposed()) {
            return;
        }
        if (this.connectedProvider.getOtherPanel() == lp) {
            this.connectedProvider.clearPanel();
            this.viewChanged(this.currentView);
        }
    }

    protected void dispose() {
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
        this.clearMarkers(this.currentProgram);
        this.formatMgr.dispose();
        this.removeProvider(this.connectedProvider);
        for (CodeViewerProvider provider : this.disconnectedProviders) {
            this.removeProvider(provider);
        }
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        ListingPanel listingPanel = this.connectedProvider.getListingPanel();
        if (options.getName().equals("Listing Display")) {
            if (optionName.equals(OptionsGui.BACKGROUND.getColorOptionName())) {
                Color c = (Color)newValue;
                listingPanel.setTextBackgroundColor(c);
            }
        } else if (options.getName().equals("Listing Fields")) {
            FieldPanel fieldPanel = listingPanel.getFieldPanel();
            if (optionName.equals("Selection Colors.Selection Color")) {
                ListingPanel otherPanel;
                Color color = (Color)newValue;
                fieldPanel.setSelectionColor(color);
                MarkerSet selectionMarkers = this.getSelectionMarkers(this.currentProgram);
                if (selectionMarkers != null) {
                    selectionMarkers.setMarkerColor(color);
                }
                if ((otherPanel = this.connectedProvider.getOtherPanel()) != null) {
                    otherPanel.getFieldPanel().setSelectionColor(color);
                }
            } else if (optionName.equals("Selection Colors.Highlight Color")) {
                Color color = (Color)newValue;
                fieldPanel.setHighlightColor(color);
                MarkerSet highlightMarkers = this.getHighlightMarkers(this.currentProgram);
                if (highlightMarkers != null) {
                    highlightMarkers.setMarkerColor(color);
                }
            } else if (optionName.equals(CURSOR_COLOR)) {
                Color color = (Color)newValue;
                fieldPanel.setFocusedCursorColor(color);
            } else if (optionName.equals(UNFOCUSED_CURSOR_COLOR)) {
                Color color = (Color)newValue;
                fieldPanel.setNonFocusCursorColor(color);
            } else if (optionName.equals(BLINK_CURSOR)) {
                Boolean isBlinkCursor = (Boolean)newValue;
                fieldPanel.setBlinkCursor(isBlinkCursor);
            } else if (optionName.equals("Cursor.Highlight Cursor Line Color")) {
                this.cursorHighlightColor = (Color)newValue;
                if (this.currentCursorMarkers != null) {
                    this.currentCursorMarkers.setMarkerColor(this.cursorHighlightColor);
                }
            } else if (optionName.equals("Cursor.Highlight Cursor Line")) {
                this.isHighlightCursorLine = (Boolean)newValue;
                if (this.currentCursorMarkers != null) {
                    this.currentCursorMarkers.setColoringBackground(this.isHighlightCursorLine);
                }
            } else if (optionName.equals(MOUSE_WHEEL_HORIZONTAL_SCROLLING)) {
                fieldPanel.setHorizontalScrollingEnabled(((Boolean)newValue).booleanValue());
            }
            this.connectedProvider.fieldOptionChanged(optionName, newValue);
        }
    }

    @Override
    public void selectionChanged(CodeViewerProvider provider, ProgramSelection selection) {
        if (provider == this.connectedProvider) {
            MarkerSet selectionMarkers = this.getSelectionMarkers(this.currentProgram);
            if (selectionMarkers != null) {
                selectionMarkers.clearAll();
            }
            if (selection != null && selectionMarkers != null) {
                selectionMarkers.add(selection);
            }
            if (!this.selectionChanging) {
                this.tool.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent(this.getName(), selection, this.connectedProvider.getProgram()));
            }
        }
    }

    @Override
    public void locationChanged(CodeViewerProvider provider, ProgramLocation location) {
        if (provider == this.connectedProvider) {
            MarkerSet cursorMarkers = this.getCursorMarkers(this.currentProgram);
            if (cursorMarkers != null) {
                cursorMarkers.clearAll();
                cursorMarkers.add(location.getAddress());
            }
            this.tool.firePluginEvent((PluginEvent)new ProgramLocationPluginEvent(this.getName(), location, this.connectedProvider.getProgram()));
        }
    }

    @Override
    public void highlightChanged(CodeViewerProvider provider, ProgramSelection highlight) {
        MarkerSet highlightMarkers = this.getHighlightMarkers(this.currentProgram);
        if (highlightMarkers != null) {
            highlightMarkers.clearAll();
        }
        if (highlight != null && this.currentProgram != null && highlightMarkers != null) {
            highlightMarkers.add(highlight);
        }
        if (provider == this.connectedProvider) {
            this.tool.firePluginEvent((PluginEvent)new ProgramHighlightPluginEvent(this.getName(), highlight, this.connectedProvider.getProgram()));
        }
    }

    private void setHighlight(ProgramSelection highlight) {
        this.connectedProvider.setHighlight(highlight);
    }

    void setSelection(ProgramSelection sel) {
        this.selectionChanging = true;
        this.connectedProvider.setSelection(sel);
        this.selectionChanging = false;
    }

    private void clearMarkers(Program program) {
        if (this.markerService == null) {
            return;
        }
        if (program == null) {
            return;
        }
        if (this.currentSelectionMarkers != null) {
            this.markerService.removeMarker(this.currentSelectionMarkers, program);
            this.currentSelectionMarkers = null;
        }
        if (this.currentHighlightMarkers != null) {
            this.markerService.removeMarker(this.currentHighlightMarkers, program);
            this.currentHighlightMarkers = null;
        }
        if (this.currentCursorMarkers != null) {
            this.markerService.removeMarker(this.currentCursorMarkers, program);
            this.currentCursorMarkers = null;
        }
    }

    private MarkerSet getSelectionMarkers(Program program) {
        if (this.markerService == null || program == null) {
            return null;
        }
        if (this.currentSelectionMarkers != null) {
            return this.currentSelectionMarkers;
        }
        FieldPanel fp = this.connectedProvider.getListingPanel().getFieldPanel();
        this.currentSelectionMarkers = this.markerService.createAreaMarker("Selection", "Selection Display", program, 100, false, true, false, fp.getSelectionColor());
        return this.currentSelectionMarkers;
    }

    private MarkerSet getHighlightMarkers(Program program) {
        if (this.markerService == null || program == null) {
            return null;
        }
        if (this.currentHighlightMarkers != null) {
            return this.currentHighlightMarkers;
        }
        FieldPanel fp = this.connectedProvider.getListingPanel().getFieldPanel();
        this.currentHighlightMarkers = this.markerService.createAreaMarker("Highlight", "Highlight Display ", program, 50, false, true, false, fp.getHighlightColor());
        return this.currentHighlightMarkers;
    }

    private MarkerSet getCursorMarkers(Program program) {
        if (this.markerService == null || program == null) {
            return null;
        }
        if (this.currentCursorMarkers != null) {
            return this.currentCursorMarkers;
        }
        this.currentCursorMarkers = this.markerService.createPointMarker("Cursor", "Cursor Location", program, 200, true, true, this.isHighlightCursorLine, this.cursorHighlightColor, this.CURSOR_LOC_ICON);
        return this.currentCursorMarkers;
    }

    private void initOptions(Options fieldOptions) {
        HelpLocation helpLocation = new HelpLocation(this.getName(), "Selection Colors");
        fieldOptions.getOptions("Selection Colors").setOptionsHelpLocation(helpLocation);
        fieldOptions.registerOption("Selection Colors.Selection Color", (Object)GhidraOptions.DEFAULT_SELECTION_COLOR, helpLocation, "The selection color in the browser.");
        fieldOptions.registerOption("Selection Colors.Highlight Color", (Object)GhidraOptions.DEFAULT_HIGHLIGHT_COLOR, helpLocation, "The highlight color in the browser.");
        fieldOptions.registerOption(CURSOR_COLOR, (Object)Color.RED, helpLocation, "The color of the cursor in the browser.");
        fieldOptions.registerOption(UNFOCUSED_CURSOR_COLOR, (Object)Color.PINK, helpLocation, "The color of the cursor in the browser when the browser does not have focus.");
        fieldOptions.registerOption(BLINK_CURSOR, (Object)true, helpLocation, "When selected, the cursor will blink when the containing window is focused.");
        fieldOptions.registerOption("Cursor.Highlight Cursor Line Color", (Object)CURSOR_LINE_COLOR, helpLocation, "The background color of the line where the cursor is located");
        fieldOptions.registerOption("Cursor.Highlight Cursor Line", (Object)true, helpLocation, "Toggles highlighting background color of line containing the cursor");
        helpLocation = new HelpLocation(this.getName(), "Keyboard_Controls_Shift");
        fieldOptions.registerOption(MOUSE_WHEEL_HORIZONTAL_SCROLLING, (Object)true, helpLocation, "Enables horizontal scrolling by holding the Shift key while using the mouse scroll wheel");
        Color color = fieldOptions.getColor("Selection Colors.Selection Color", GhidraOptions.DEFAULT_SELECTION_COLOR);
        FieldPanel fieldPanel = this.connectedProvider.getListingPanel().getFieldPanel();
        fieldPanel.setSelectionColor(color);
        MarkerSet selectionMarkers = this.getSelectionMarkers(this.currentProgram);
        if (selectionMarkers != null) {
            selectionMarkers.setMarkerColor(color);
        }
        color = fieldOptions.getColor("Selection Colors.Highlight Color", new Color(255, 255, 180));
        MarkerSet highlightMarkers = this.getHighlightMarkers(this.currentProgram);
        fieldPanel.setHighlightColor(color);
        if (highlightMarkers != null) {
            highlightMarkers.setMarkerColor(color);
        }
        color = fieldOptions.getColor(CURSOR_COLOR, Color.RED);
        fieldPanel.setFocusedCursorColor(color);
        color = fieldOptions.getColor(UNFOCUSED_CURSOR_COLOR, Color.PINK);
        fieldPanel.setNonFocusCursorColor(color);
        Boolean isBlinkCursor = fieldOptions.getBoolean(BLINK_CURSOR, true);
        fieldPanel.setBlinkCursor(isBlinkCursor);
        boolean horizontalScrollingEnabled = fieldOptions.getBoolean(MOUSE_WHEEL_HORIZONTAL_SCROLLING, true);
        fieldPanel.setHorizontalScrollingEnabled(horizontalScrollingEnabled);
        this.cursorHighlightColor = fieldOptions.getColor("Cursor.Highlight Cursor Line Color", CURSOR_LINE_COLOR);
        this.isHighlightCursorLine = fieldOptions.getBoolean("Cursor.Highlight Cursor Line", true);
    }

    private void initDisplayOptions(Options displayOptions) {
        Color color = displayOptions.getColor(OptionsGui.BACKGROUND.getColorOptionName(), OptionsGui.BACKGROUND.getDefaultColor());
        this.connectedProvider.getListingPanel().setTextBackgroundColor(color);
    }

    private void initMiscellaneousOptions() {
        HelpLocation helpLocation = new HelpLocation("ShowInstructionInfoPlugin", "Processor_Manual_Options");
        ToolOptions options = this.tool.getOptions("Processor Manuals");
        options.registerOption("Manual Viewer Options", OptionType.CUSTOM_TYPE, (Object)ManualViewerCommandWrappedOption.getDefaultBrowserLoaderOptions(), helpLocation, "Options for running manual viewer", (PropertyEditor)new ManualViewerCommandEditor());
    }

    public void initActions() {
        this.tableFromSelectionAction = new DockingAction("Create Table From Selection", this.getName()){
            ImageIcon markerIcon;
            {
                this.markerIcon = ResourceManager.loadImage((String)"images/searchm_obj.gif");
            }

            public void actionPerformed(ActionContext context) {
                Listing listing = CodeBrowserPlugin.this.currentProgram.getListing();
                ProgramSelection selection = CodeBrowserPlugin.this.connectedProvider.getSelection();
                CodeUnitIterator codeUnits = listing.getCodeUnits((AddressSetView)selection, true);
                TableService tableService = (TableService)CodeBrowserPlugin.this.tool.getService(TableService.class);
                if (!codeUnits.hasNext()) {
                    CodeBrowserPlugin.this.tool.setStatusInfo("Unable to create table from selection: no code units in selection");
                    return;
                }
                GhidraProgramTableModel<Address> model = CodeBrowserPlugin.this.createTableModel(codeUnits, selection);
                String title = "Selection Table";
                TableComponentProvider<Address> tableProvider = tableService.showTableWithMarkers(title + " " + model.getName(), "Selection", model, PluginConstants.SEARCH_HIGHLIGHT_COLOR, this.markerIcon, title, null);
                tableProvider.installRemoveItemsAction();
            }

            public boolean isEnabledForContext(ActionContext context) {
                ProgramSelection programSelection = CodeBrowserPlugin.this.connectedProvider.getSelection();
                return programSelection != null && !programSelection.isEmpty();
            }
        };
        this.tableFromSelectionAction.setEnabled(false);
        this.tableFromSelectionAction.setMenuBarData(new MenuData(new String[]{"Se&lect", "Create Table From Selection"}, null, "SelectUtils"));
        this.tableFromSelectionAction.setHelpLocation(new HelpLocation("CodeBrowserPlugin", "Selection_Table"));
    }

    private GhidraProgramTableModel<Address> createTableModel(CodeUnitIterator iterator, ProgramSelection selection) {
        CodeUnitFromSelectionTableModelLoader loader = new CodeUnitFromSelectionTableModelLoader(iterator, selection);
        return new CustomLoadingAddressTableModel(" - from " + selection.getMinAddress(), (ServiceProvider)this.tool, this.currentProgram, loader, null, true);
    }

    @Override
    public void updateDisplay() {
        this.connectedProvider.getListingPanel().updateDisplay(false);
    }

    @Override
    public FieldPanel getFieldPanel() {
        return this.connectedProvider.getListingPanel().getFieldPanel();
    }

    @Override
    public Navigatable getNavigatable() {
        return this.connectedProvider;
    }

    public void updateNow() {
        SystemUtilities.runSwingNow(() -> this.connectedProvider.getListingPanel().updateDisplay(true));
    }

    public boolean goToField(Address address, String fieldName, int row, int col) {
        return this.goToField(address, fieldName, 0, row, col, true);
    }

    public boolean goToField(Address addr, String fieldName, int occurrence, int row, int col) {
        return this.goToField(addr, fieldName, occurrence, row, col, true);
    }

    public boolean goToField(Address a, String fieldName, int occurrence, int row, int col, boolean scroll) {
        boolean result = (Boolean)SystemUtilities.runSwingNow(() -> this.doGoToField(a, fieldName, occurrence, row, col, scroll));
        return result;
    }

    private boolean doGoToField(Address a, String fieldName, int occurrence, int row, int col, boolean scroll) {
        FieldPanel fieldPanel;
        BigInteger index;
        int fieldNum;
        SystemUtilities.assertThisIsTheSwingThread((String)"GoTo must be performed on the Swing thread");
        this.updateNow();
        ListingPanel panel = this.connectedProvider.getListingPanel();
        if (a == null) {
            a = this.getCurrentAddress();
        }
        if ((fieldNum = this.getFieldNumber(fieldName, occurrence, index = panel.getAddressIndexMap().getIndex(a), fieldPanel = panel.getFieldPanel())) < 0) {
            return false;
        }
        if (scroll) {
            fieldPanel.goTo(index, fieldNum, row, col, true);
        } else {
            fieldPanel.setCursorPosition(index, fieldNum, row, col);
        }
        return true;
    }

    private int getFieldNumber(String fieldName, int occurrence, BigInteger index, FieldPanel fieldPanel) {
        if (fieldName == null) {
            return -1;
        }
        int fieldNum = -1;
        LayoutModel model = fieldPanel.getLayoutModel();
        Layout layout = model.getLayout(index);
        if (layout == null) {
            return -1;
        }
        int instanceNum = 0;
        for (int i = 0; i < layout.getNumFields(); ++i) {
            ListingField bf = (ListingField)layout.getField(i);
            if (!bf.getFieldFactory().getFieldName().equals(fieldName) || instanceNum++ != occurrence) continue;
            fieldNum = i;
            break;
        }
        return fieldNum;
    }

    public Address getCurrentAddress() {
        ProgramLocation loc = this.getCurrentLocation();
        if (loc == null) {
            return null;
        }
        return this.getCurrentLocation().getAddress();
    }

    @Override
    public ProgramSelection getCurrentSelection() {
        return this.connectedProvider.getListingPanel().getProgramSelection();
    }

    Program getCurrentProgram() {
        return this.currentProgram;
    }

    public CodeViewerProvider getProvider() {
        return this.connectedProvider;
    }

    public boolean goTo(ProgramLocation location) {
        return this.goTo(location, true);
    }

    @Override
    public boolean goTo(ProgramLocation location, boolean centerOnScreen) {
        AtomicBoolean didGoTo = new AtomicBoolean();
        SystemUtilities.runSwingNow(() -> {
            boolean success = this.connectedProvider.getListingPanel().goTo(location, centerOnScreen);
            didGoTo.set(success);
        });
        return didGoTo.get();
    }

    @Override
    public ProgramLocation getCurrentLocation() {
        return this.connectedProvider.getListingPanel().getProgramLocation();
    }

    public FieldLocation getCurrentFieldLoction() {
        return this.getFieldPanel().getCursorLocation();
    }

    @Override
    public String getCurrentFieldTextSelection() {
        return this.connectedProvider.getStringSelection();
    }

    @Override
    public ListingField getCurrentField() {
        Field f = this.getFieldPanel().getCurrentField();
        if (f instanceof ListingField) {
            return (ListingField)f;
        }
        return null;
    }

    public String getCurrentFieldText() {
        ListingField lf = this.getCurrentField();
        if (lf instanceof ListingTextField) {
            return ((ListingTextField)lf).getText();
        }
        return "";
    }

    @Override
    public AddressSetView getView() {
        return this.currentView;
    }

    @Override
    public FormatManager getFormatManager() {
        return this.formatMgr;
    }

    public void toggleOpen(Data data) {
        this.connectedProvider.getListingPanel().getListingModel().toggleOpen(data);
    }

    @Override
    public AddressIndexMap getAddressIndexMap() {
        return this.getListingPanel().getAddressIndexMap();
    }

    @Override
    public ListingPanel getListingPanel() {
        return this.connectedProvider.getListingPanel();
    }

    Address getAddressTopOfScreen() {
        BigInteger index = this.getFieldPanel().getViewerPosition().getIndex();
        return this.getAddressIndexMap().getAddress(index);
    }

    public void readConfigState(SaveState saveState) {
        this.formatMgr.readState(saveState);
        this.connectedProvider.readState(saveState);
    }

    public void writeConfigState(SaveState saveState) {
        this.formatMgr.saveState(saveState);
        this.connectedProvider.saveState(saveState);
    }

    @Override
    public void formatModelAdded(FieldFormatModel model) {
    }

    @Override
    public void formatModelRemoved(FieldFormatModel model) {
    }

    @Override
    public void formatModelChanged(FieldFormatModel model) {
        this.tool.setConfigChanged(true);
    }

    @Override
    public Layout getLayout(Address addr) {
        return this.connectedProvider.getListingPanel().getLayout(addr);
    }

    @Override
    public ListingModel getListingModel() {
        return this.connectedProvider.getListingPanel().getListingModel();
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.containsEvent(2)) {
            this.connectedProvider.updateTitle();
        }
        if (this.viewManager != null) {
            return;
        }
        if (ev.containsEvent(4)) {
            this.viewChanged((AddressSetView)this.currentProgram.getMemory());
        }
    }

    @Override
    public void providerClosed(CodeViewerProvider codeViewerProvider) {
        this.removeProvider(codeViewerProvider);
        if (!codeViewerProvider.isConnected()) {
            this.disconnectedProviders.remove(codeViewerProvider);
        }
    }

    @Override
    public ViewManagerService getViewManager(CodeViewerProvider codeViewerProvider) {
        if (codeViewerProvider == this.connectedProvider) {
            return this.viewManager;
        }
        return null;
    }

    private class CodeUnitFromSelectionTableModelLoader
    implements TableModelLoader<Address> {
        private CodeUnitIterator iterator;
        private ProgramSelection selection;

        CodeUnitFromSelectionTableModelLoader(CodeUnitIterator iterator, ProgramSelection selection) {
            this.iterator = iterator;
            this.selection = selection;
        }

        @Override
        public void load(Accumulator<Address> accumulator, TaskMonitor monitor) throws CancelledException {
            long size = this.selection.getNumAddresses();
            monitor.initialize(size);
            while (this.iterator.hasNext()) {
                monitor.checkCanceled();
                CodeUnit cu = this.iterator.next();
                accumulator.add((Object)cu.getMinAddress());
                monitor.incrementProgress((long)cu.getLength());
            }
        }
    }

    private class FocusingMouseListener
    extends MouseAdapter {
        private FocusingMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            CodeBrowserPlugin.this.connectedProvider.getListingPanel().getFieldPanel().requestFocus();
        }
    }

    static class MarkerChangeListener
    implements ChangeListener {
        private FieldPanel fieldPanel;

        MarkerChangeListener(CodeViewerProvider provider) {
            this.fieldPanel = provider.getListingPanel().getFieldPanel();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fieldPanel.repaint();
        }
    }
}

