/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import docking.DialogComponentProvider;
import docking.widgets.button.GRadioButton;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.ToolTipUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class CreateStructureDialog
extends DialogComponentProvider {
    private static final String NEW_STRUCTURE_STATUS_PREFIX = "Creating new structure: ";
    private static final String EXISITING_STRUCTURE_STATUS_PREFIX = "Using existing structure: ";
    private static final String STRUCTURE_COLUMN_NAME = "Structure";
    private static final String PATH_COLUMN_NAME = "Path";
    private JTextField nameTextField;
    private GhidraTable matchingStructuresTable;
    private StructureTableModel structureTableModel;
    private Structure currentStructure;
    private Program currentProgram;
    private PluginTool pluginTool;
    private TitledBorder nameBorder;
    private TitledBorder structureBorder;
    private JRadioButton exactMatchButton;
    private JRadioButton sizeMatchButton;
    private GhidraTableFilterPanel<StructureWrapper> filterPanel;

    public CreateStructureDialog(PluginTool tool) {
        super("Create Structure", true, true, true, false);
        this.pluginTool = tool;
        this.setHelpLocation(new HelpLocation("DataPlugin", "Create_Structure_Dialog"));
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.rootPanel.setPreferredSize(new Dimension(600, 600));
        this.setDefaultButton(this.okButton);
    }

    void dispose() {
        this.filterPanel.dispose();
        this.matchingStructuresTable.dispose();
    }

    private JPanel buildMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.buildNameTextFieldPanel());
        mainPanel.add(Box.createVerticalStrut(10));
        mainPanel.add(this.buildMatchingStructurePanel());
        this.setStatusJustification(2);
        this.setCreateStructureByName(true);
        return mainPanel;
    }

    private JPanel buildNameTextFieldPanel() {
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel, 1));
        this.nameBorder = BorderFactory.createTitledBorder("Create Structure By Name");
        namePanel.setBorder(this.nameBorder);
        this.nameTextField = new JTextField(){

            @Override
            public Dimension getMaximumSize() {
                Dimension d = super.getMaximumSize();
                d.height = this.getPreferredSize().height;
                return d;
            }
        };
        this.nameTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                CreateStructureDialog.this.setCreateStructureByName(true);
                CreateStructureDialog.this.nameTextField.requestFocus();
            }
        });
        namePanel.add(this.nameTextField);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
                this.checkText(event.getDocument());
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                this.checkText(event.getDocument());
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                this.checkText(event.getDocument());
            }

            private void checkText(Document document) {
                try {
                    String text = document.getText(0, document.getLength());
                    if (text == null || text.trim().length() == 0) {
                        CreateStructureDialog.this.okButton.setEnabled(false);
                        CreateStructureDialog.this.updateStatusText(true, null);
                    } else {
                        CreateStructureDialog.this.okButton.setEnabled(true);
                        CreateStructureDialog.this.updateStatusText(true, text);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        return namePanel;
    }

    private JPanel buildMatchingStructurePanel() {
        JPanel structurePanel = new JPanel();
        structurePanel.setLayout(new BoxLayout(structurePanel, 1));
        this.structureBorder = BorderFactory.createTitledBorder("Use Existing Structure");
        structurePanel.setBorder(this.structureBorder);
        GTable table = this.buildMatchingStructuresTable();
        this.filterPanel = new GhidraTableFilterPanel<StructureWrapper>((JTable)table, (RowObjectTableModel)this.structureTableModel){

            public Dimension getMaximumSize() {
                Dimension d = super.getMaximumSize();
                d.height = this.getPreferredSize().height;
                return d;
            }
        };
        JScrollPane scrollPane = new JScrollPane((Component)table);
        structurePanel.add(scrollPane);
        structurePanel.add(Box.createVerticalStrut(10));
        structurePanel.add((Component)((Object)this.filterPanel));
        structurePanel.add(Box.createVerticalStrut(10));
        structurePanel.add(this.buildMatchingStyelPanel());
        structurePanel.add(Box.createVerticalStrut(10));
        return structurePanel;
    }

    private GTable buildMatchingStructuresTable() {
        this.structureTableModel = new StructureTableModel();
        this.matchingStructuresTable = new GhidraTable((TableModel)((Object)this.structureTableModel));
        this.matchingStructuresTable.setAutoLookupColumn(0);
        this.matchingStructuresTable.setSelectionMode(0);
        this.matchingStructuresTable.setAutoCreateColumnsFromModel(false);
        this.matchingStructuresTable.setPreferredScrollableViewportSize(new Dimension(200, 100));
        StructureCellRenderer cellRenderer = new StructureCellRenderer();
        TableColumnModel columnModel = this.matchingStructuresTable.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            column.setCellRenderer((TableCellRenderer)((Object)cellRenderer));
        }
        this.matchingStructuresTable.getColumnModel().getColumn(0);
        ListSelectionModel lsm = this.matchingStructuresTable.getSelectionModel();
        lsm.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                ListSelectionModel sourceListSelectionModel = (ListSelectionModel)e.getSource();
                if (sourceListSelectionModel != null && !sourceListSelectionModel.isSelectionEmpty()) {
                    Structure structure = ((StructureWrapper)this.matchingStructuresTable.getValueAt(this.matchingStructuresTable.getSelectedRow(), 0)).getStructure();
                    this.updateStatusText(false, structure.getName());
                    this.setCreateStructureByName(false);
                } else {
                    this.updateStatusText(true, this.nameTextField.getText());
                    this.setCreateStructureByName(true);
                }
            }
        });
        return this.matchingStructuresTable;
    }

    private JPanel buildMatchingStyelPanel() {
        JPanel matchingStylePanel = new JPanel(){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
            }
        };
        matchingStylePanel.setLayout(new BoxLayout(matchingStylePanel, 0));
        matchingStylePanel.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), "Matching: "));
        this.exactMatchButton = new GRadioButton("Exact");
        this.sizeMatchButton = new GRadioButton("Size");
        this.exactMatchButton.setToolTipText("Match structures with the same number and type of data elements");
        this.sizeMatchButton.setToolTipText("Match structures of the same size");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.exactMatchButton);
        buttonGroup.add(this.sizeMatchButton);
        this.sizeMatchButton.setSelected(true);
        ItemListener searchListener = event -> this.searchForMatchingStructures(this.currentProgram, this.currentStructure);
        this.exactMatchButton.addItemListener(searchListener);
        this.sizeMatchButton.addItemListener(searchListener);
        matchingStylePanel.add(this.exactMatchButton);
        matchingStylePanel.add(this.sizeMatchButton);
        return matchingStylePanel;
    }

    private void setCreateStructureByName(boolean createStructureByName) {
        if (createStructureByName) {
            this.nameBorder.setTitleColor(Color.BLACK);
            this.structureBorder.setTitleColor(Color.GRAY);
        } else {
            this.nameBorder.setTitleColor(Color.GRAY);
            this.structureBorder.setTitleColor(Color.BLACK);
        }
        this.nameTextField.setEnabled(createStructureByName);
        if (createStructureByName) {
            this.matchingStructuresTable.clearSelection();
        }
        this.rootPanel.repaint();
    }

    private void searchForMatchingStructures(Program program, Structure structure) {
        SwingUtilities.invokeLater(() -> {
            DataTypeManagerService service = (DataTypeManagerService)this.pluginTool.getService(DataTypeManagerService.class);
            DataTypeManager[] dataTypeManagers = null;
            dataTypeManagers = service != null ? service.getDataTypeManagers() : new DataTypeManager[]{program.getDataTypeManager()};
            this.getMatchingStructuresFromDataTypeManagers(structure, dataTypeManagers);
        });
    }

    private void getMatchingStructuresFromDataTypeManagers(Structure structure, DataTypeManager[] dataTypeManagers) {
        ArrayList<StructureWrapper> dataList = new ArrayList<StructureWrapper>();
        for (DataTypeManager dataTypeManager : dataTypeManagers) {
            Iterator structureIterator = dataTypeManager.getAllStructures();
            while (structureIterator.hasNext()) {
                Structure nextStructure = (Structure)structureIterator.next();
                if (!this.compareStructures(nextStructure, structure)) continue;
                dataList.add(new StructureWrapper(nextStructure));
            }
        }
        this.structureTableModel.setData(dataList);
    }

    private boolean compareStructures(Structure structureA, Structure structureB) {
        if (this.sizeMatchButton.isSelected()) {
            return this.compareStructuresBySize(structureA, structureB);
        }
        return this.compareStructuresByData(structureA, structureB);
    }

    private boolean compareStructuresBySize(Structure structureA, Structure structureB) {
        return structureA.getLength() == structureB.getLength();
    }

    private boolean compareStructuresByData(Structure structureA, Structure structureB) {
        DataTypeComponent[] definedComponentsB;
        if (structureA.getLength() != structureB.getLength()) {
            return false;
        }
        DataTypeComponent[] definedComponentsA = structureA.getDefinedComponents();
        if (definedComponentsA.length == (definedComponentsB = structureB.getDefinedComponents()).length) {
            for (int i = 0; i < definedComponentsA.length; ++i) {
                if (this.compareDataTypeComponents(definedComponentsA[i], definedComponentsB[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean compareDataTypeComponents(DataTypeComponent dtcA, DataTypeComponent dtcB) {
        return dtcA.getLength() == dtcB.getLength() && dtcA.getOffset() == dtcB.getOffset() && dtcA.getOrdinal() == dtcB.getOrdinal() && this.compareDataTypes(dtcA.getDataType(), dtcB.getDataType());
    }

    private boolean compareDataTypes(DataType typeA, DataType typeB) {
        if (typeA instanceof Structure) {
            if (typeB instanceof Structure) {
                return this.compareStructuresByData((Structure)typeA, (Structure)typeB);
            }
            return false;
        }
        return typeA.getName().equals(typeB.getName()) && typeA.getLength() == typeB.getLength();
    }

    public Structure showCreateStructureDialog(Program program, Structure structure) throws NullPointerException {
        if (program == null) {
            throw new NullPointerException("Cannot show Create Structure dialog without a non-null Program.");
        }
        if (structure == null) {
            throw new NullPointerException("Non-null structure is required when showing the Create Structure dialog.");
        }
        this.currentStructure = structure;
        this.nameTextField.setText(this.currentStructure.getName());
        this.updateStatusText(true, this.currentStructure.getName());
        this.searchForMatchingStructures(program, structure);
        this.pluginTool.showDialog((DialogComponentProvider)this);
        return this.currentStructure;
    }

    protected void cancelCallback() {
        this.currentStructure = null;
        super.cancelCallback();
    }

    protected void okCallback() {
        if (this.nameTextField.isEnabled()) {
            String nameText = this.nameTextField.getText();
            try {
                this.currentStructure.setName(nameText);
            }
            catch (InvalidNameException ine) {
                this.setStatusText(ine.getMessage());
                return;
            }
            catch (DuplicateNameException dne) {
                this.setStatusText(dne.getMessage());
                return;
            }
        } else {
            this.currentStructure = ((StructureWrapper)this.matchingStructuresTable.getValueAt(this.matchingStructuresTable.getSelectedRow(), 0)).getStructure();
        }
        this.close();
    }

    private void updateStatusText(boolean creatingNew, String name) {
        if (name == null) {
            this.setStatusText("");
            return;
        }
        String message = null;
        message = creatingNew ? NEW_STRUCTURE_STATUS_PREFIX : EXISITING_STRUCTURE_STATUS_PREFIX;
        this.setStatusText("<HTML>" + message + "<BR>\"" + HTMLUtilities.escapeHTML((String)name) + "\"");
    }

    class StructureCellRenderer
    extends GTableCellRenderer {
        StructureCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JComponent renderer = (JComponent)super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            JTable table = data.getTable();
            int row = data.getRowViewIndex();
            int column = data.getColumnViewIndex();
            String columnName = table.getColumnName(column);
            if (CreateStructureDialog.STRUCTURE_COLUMN_NAME.equals(columnName)) {
                StructureWrapper wrapper = (StructureWrapper)table.getValueAt(row, 0);
                if (wrapper != null) {
                    Structure structure = wrapper.getStructure();
                    renderer.setToolTipText(ToolTipUtils.getToolTipText((DataType)structure));
                }
            } else if (CreateStructureDialog.PATH_COLUMN_NAME.equals(columnName) && value != null) {
                renderer.setToolTipText(value.toString());
            }
            return renderer;
        }
    }

    class StructureWrapper {
        private Structure structure;

        private StructureWrapper(Structure newStructure) {
            this.structure = newStructure;
        }

        Structure getStructure() {
            return this.structure;
        }

        public String toString() {
            return this.structure.getName();
        }
    }

    class StructureTableModel
    extends AbstractSortedTableModel<StructureWrapper> {
        private List<StructureWrapper> data = Collections.emptyList();

        StructureTableModel() {
        }

        public String getName() {
            return CreateStructureDialog.STRUCTURE_COLUMN_NAME;
        }

        void setData(List<StructureWrapper> data) {
            this.data = data;
            this.fireTableDataChanged();
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return CreateStructureDialog.STRUCTURE_COLUMN_NAME;
                }
                case 1: {
                    return CreateStructureDialog.PATH_COLUMN_NAME;
                }
            }
            return null;
        }

        public int getColumnCount() {
            return 2;
        }

        public boolean isSortable(int columnIndex) {
            return true;
        }

        public List<StructureWrapper> getModelData() {
            return this.data;
        }

        public Object getColumnValueForRow(StructureWrapper t, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return t;
                }
                case 1: {
                    Structure structure = t.getStructure();
                    CategoryPath path = structure.getCategoryPath();
                    String name = structure.getName();
                    return path.toString() + "/" + name;
                }
            }
            return null;
        }
    }
}

