/*-
 * Copyright (C) 2008 Erik Larsson
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.catacombae.hfsexplorer.gui;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JDialog;

/**
 *
 * @author  Erik
 */
public class ErrorSummaryPanel extends javax.swing.JPanel {

    private ErrorSummaryPanel(final JDialog dialog, List<String> errorMessages) {
        this(errorMessages);
        
        closeButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        
        
    }
    /** Creates new form ErrorSummaryPanel */
    private ErrorSummaryPanel(List<String> errorMessages) {
        initComponents();
        
        for(String msg : errorMessages) {
            contentsAreaScroller.append(msg + "\n");
        }
    }
    
    public static JDialog createErrorSummaryDialog(Dialog owner, List<String> errorMessages) {
        JDialog dialog = new JDialog(owner, "Error summary", true);
        fillErrorSummaryDialog(dialog, errorMessages);
        return dialog;
    }
    
    public static JDialog createErrorSummaryDialog(Frame owner, List<String> errorMessages) {
        JDialog dialog = new JDialog(owner, "Error summary", true);
        fillErrorSummaryDialog(dialog, errorMessages);
        return dialog;
    }

    private static void fillErrorSummaryDialog(JDialog dialog, List<String> errorMessages) {
        ErrorSummaryPanel esp = new ErrorSummaryPanel(dialog, errorMessages);
        dialog.add(esp);
        
        dialog.pack();
        dialog.setLocationRelativeTo(null);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        titleLabel = new javax.swing.JLabel();
        contantsAreaScroller = new javax.swing.JScrollPane();
        contentsAreaScroller = new javax.swing.JTextArea();
        closeButtonPanel = new javax.swing.JPanel();
        closeButton = new javax.swing.JButton();

        titleLabel.setText("The following errors were encountered when extracting files:");

        contentsAreaScroller.setColumns(20);
        contentsAreaScroller.setEditable(false);
        contentsAreaScroller.setLineWrap(true);
        contentsAreaScroller.setRows(5);
        contantsAreaScroller.setViewportView(contentsAreaScroller);

        closeButtonPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 0, 0));

        closeButton.setText("Close");
        closeButtonPanel.add(closeButton);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, contantsAreaScroller, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 655, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, titleLabel)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, closeButtonPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 655, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(titleLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(contantsAreaScroller, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 258, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(closeButtonPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton closeButton;
    private javax.swing.JPanel closeButtonPanel;
    private javax.swing.JScrollPane contantsAreaScroller;
    private javax.swing.JTextArea contentsAreaScroller;
    private javax.swing.JLabel titleLabel;
    // End of variables declaration//GEN-END:variables

}
