/*
   +----------------------------------------------------------------------+
   | Copyright (c) The PHP Group                                          |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Rasmus Lerdorf <rasmus@php.net>                             |
   |          Zeev Suraski <zeev@php.net>                                 |
   |          Colin Viebrock <colin@viebrock.ca>                          |
   +----------------------------------------------------------------------+
*/

#ifndef INFO_H
#define INFO_H

#define PHP_ENTRY_NAME_COLOR "#ccf"
#define PHP_CONTENTS_COLOR "#ccc"
#define PHP_HEADER_COLOR "#99c"

#define PHP_INFO_GENERAL			(1<<0)
#define PHP_INFO_CREDITS			(1<<1)
#define PHP_INFO_CONFIGURATION		(1<<2)
#define PHP_INFO_MODULES			(1<<3)
#define PHP_INFO_ENVIRONMENT		(1<<4)
#define PHP_INFO_VARIABLES			(1<<5)
#define PHP_INFO_LICENSE			(1<<6)
#define PHP_INFO_ALL				0xFFFFFFFF

#ifndef HAVE_CREDITS_DEFS
#define HAVE_CREDITS_DEFS

#define PHP_CREDITS_GROUP			(1<<0)
#define PHP_CREDITS_GENERAL			(1<<1)
#define PHP_CREDITS_SAPI			(1<<2)
#define PHP_CREDITS_MODULES			(1<<3)
#define PHP_CREDITS_DOCS			(1<<4)
#define PHP_CREDITS_FULLPAGE		(1<<5)
#define PHP_CREDITS_QA				(1<<6)
#define PHP_CREDITS_WEB             (1<<7)
#define PHP_CREDITS_ALL				0xFFFFFFFF

#endif /* HAVE_CREDITS_DEFS */

#define PHP_LOGO_DATA_URI "data:image/png;base64,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"
#define PHP_EGG_LOGO_DATA_URI "data:image/png;base64,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"
#define ZEND_LOGO_DATA_URI "data:image/png;base64,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"

BEGIN_EXTERN_C()
PHPAPI zend_string *php_info_html_esc(const char *string);
PHPAPI void php_print_info_htmlhead(void);
PHPAPI void php_print_info(int flag);
PHPAPI void php_print_style(void);
PHPAPI void php_info_print_style(void);
PHPAPI void php_info_print_table_colspan_header(int num_cols, const char *header);
PHPAPI void php_info_print_table_header(int num_cols, ...);
PHPAPI void php_info_print_table_row(int num_cols, ...);
PHPAPI void php_info_print_table_row_ex(int num_cols, const char *, ...);
PHPAPI void php_info_print_table_start(void);
PHPAPI void php_info_print_table_end(void);
PHPAPI void php_info_print_box_start(int bg);
PHPAPI void php_info_print_box_end(void);
PHPAPI void php_info_print_hr(void);
PHPAPI void php_info_print_module(zend_module_entry *module);
PHPAPI zend_string *php_get_uname(char mode);

void register_phpinfo_constants(INIT_FUNC_ARGS);
END_EXTERN_C()

#endif /* INFO_H */
