(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/os/kqueue#kqueue
    (lambda ()
      (let* ((_fd556_ (let ((_r553_ (std/os/kqueue#_kqueue)))
                        (if (not (let ()
                                   (declare (not safe))
                                   (##fxnegative? _r553_)))
                            _r553_
                            (std/os/error#raise-os-error
                             (let () (declare (not safe)) (##fx- _r553_))
                             std/os/kqueue#kqueue))))
             (_raw558_ (std/os/fd#fdopen _fd556_ 'in 'kqueue)))
        (std/os/fcntl#fd-set-closeonexec _raw558_)
        _raw558_)))
  (define std/os/kqueue#kqueue-close (lambda (_kq550_) (close-port _kq550_)))
  (define std/os/kqueue#make-kevents
    (lambda (_size545_)
      (let ((_r547_ (std/os/kqueue#make_kevents _size545_)))
        (if _r547_ _r547_ (error '"Error allocating memory" 'make_kevents)))))
  (define std/os/kqueue#kevent-set!__%
    (lambda (_g4159_
             _ident496504_
             _filter497506_
             _flags498508_
             _filter-flags499510_
             _data500512_
             _user-data501514_
             _kevts516_
             _ix517_)
      (let* ((_ident519_
              (if (eq? _ident496504_ absent-value)
                  (error '"Missing required keyword argument" 'ident:)
                  _ident496504_))
             (_filter521_
              (if (eq? _filter497506_ absent-value)
                  (error '"Missing required keyword argument" 'filter:)
                  _filter497506_))
             (_flags523_
              (if (eq? _flags498508_ absent-value) '0 _flags498508_))
             (_filter-flags525_
              (if (eq? _filter-flags499510_ absent-value)
                  '0
                  _filter-flags499510_))
             (_data527_ (if (eq? _data500512_ absent-value) '0 _data500512_))
             (_user-data529_
              (if (eq? _user-data501514_ absent-value) '#f _user-data501514_)))
        (std/os/kqueue#ev_set
         _kevts516_
         _ix517_
         _ident519_
         _filter521_
         _flags523_
         _filter-flags525_
         _data527_
         _user-data529_))))
  (define std/os/kqueue#kevent-set!__@
    (lambda (_keys495534_ . _args536_)
      (apply std/os/kqueue#kevent-set!__%
             _keys495534_
             (table-ref _keys495534_ 'ident: absent-value)
             (table-ref _keys495534_ 'filter: absent-value)
             (table-ref _keys495534_ 'flags: absent-value)
             (table-ref _keys495534_ 'filter-flags: absent-value)
             (table-ref _keys495534_ 'data: absent-value)
             (table-ref _keys495534_ 'user-data: absent-value)
             _args536_)))
  (define std/os/kqueue#kevent-set!
    (lambda _args502542_
      (apply keyword-dispatch
             '#(#f
                #f
                #f
                #f
                #f
                filter:
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                data:
                #f
                filter-flags:
                #f
                #f
                flags:
                #f
                #f
                ident:
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                user-data:
                #f
                #f
                #f
                #f
                #f
                #f)
             std/os/kqueue#kevent-set!__@
             _args502542_)))
  (define std/os/kqueue#kevent
    (lambda (_kqueue478_
             _change-list479_
             _nchanges480_
             _event-list481_
             _nevents482_)
      (let _lp484_ ()
        (let ((_r488_ (std/os/kqueue#_kevent
                       (std/os/fd#fd-e _kqueue478_)
                       _change-list479_
                       _nchanges480_
                       _event-list481_
                       _nevents482_
                       std/os/kqueue#timespec-zero)))
          (if (not (let () (declare (not safe)) (##fxnegative? _r488_)))
              _r488_
              (let ((_errno491_ (let () (declare (not safe)) (##fx- _r488_))))
                (if '#f
                    '#f
                    (if (eq? _errno491_ std/os/error#EINTR)
                        (_lp484_)
                        (std/os/error#raise-os-error
                         _errno491_
                         std/os/kqueue#kevent
                         _kqueue478_
                         _change-list479_
                         _nchanges480_
                         _event-list481_
                         _nevents482_)))))))))
  (define std/os/kqueue#kqueue-poll
    (lambda (_kqueue474_ _events475_ _nevents476_)
      (std/os/kqueue#kevent _kqueue474_ '#f '0 _events475_ _nevents476_)))
  (define std/os/kqueue#kqueue-kevent-add__%
    (lambda (_kqueue428_
             _dev429_
             _filter430_
             _additional-flags431_
             _filter-flags432_
             _data433_)
      (let ((_kevt435_ (std/os/kqueue#get-kevent-ptr)))
        (std/os/kqueue#kevent-set!__%
         '#f
         (if (std/os/fd#fd? _dev429_) (std/os/fd#fd-e _dev429_) _dev429_)
         _filter430_
         (let ()
           (declare (not safe))
           (##fxior std/os/kqueue#EV_ADD _additional-flags431_))
         _filter-flags432_
         _data433_
         absent-value
         _kevt435_
         '0)
        (std/os/kqueue#kevent _kqueue428_ _kevt435_ '1 '#f '0))))
  (define std/os/kqueue#kqueue-kevent-add__0
    (lambda (_kqueue440_ _dev441_ _filter442_)
      (let* ((_additional-flags444_ '0) (_filter-flags446_ '0) (_data448_ '0))
        (std/os/kqueue#kqueue-kevent-add__%
         _kqueue440_
         _dev441_
         _filter442_
         _additional-flags444_
         _filter-flags446_
         _data448_))))
  (define std/os/kqueue#kqueue-kevent-add__1
    (lambda (_kqueue450_ _dev451_ _filter452_ _additional-flags453_)
      (let* ((_filter-flags455_ '0) (_data457_ '0))
        (std/os/kqueue#kqueue-kevent-add__%
         _kqueue450_
         _dev451_
         _filter452_
         _additional-flags453_
         _filter-flags455_
         _data457_))))
  (define std/os/kqueue#kqueue-kevent-add__2
    (lambda (_kqueue459_
             _dev460_
             _filter461_
             _additional-flags462_
             _filter-flags463_)
      (let ((_data465_ '0))
        (std/os/kqueue#kqueue-kevent-add__%
         _kqueue459_
         _dev460_
         _filter461_
         _additional-flags462_
         _filter-flags463_
         _data465_))))
  (define std/os/kqueue#kqueue-kevent-add
    (lambda _g4161_
      (let ((_g4160_ (let () (declare (not safe)) (##length _g4161_))))
        (cond ((let () (declare (not safe)) (##fx= _g4160_ 3))
               (apply std/os/kqueue#kqueue-kevent-add__0 _g4161_))
              ((let () (declare (not safe)) (##fx= _g4160_ 4))
               (apply std/os/kqueue#kqueue-kevent-add__1 _g4161_))
              ((let () (declare (not safe)) (##fx= _g4160_ 5))
               (apply std/os/kqueue#kqueue-kevent-add__2 _g4161_))
              ((let () (declare (not safe)) (##fx= _g4160_ 6))
               (apply std/os/kqueue#kqueue-kevent-add__% _g4161_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/kqueue#kqueue-kevent-add
                _g4161_))))))
  (define std/os/kqueue#kqueue-kevent-del
    (lambda (_kqueue421_ _dev422_ _filter423_)
      (let ((_kevt425_ (std/os/kqueue#get-kevent-ptr)))
        (std/os/kqueue#kevent-set!__%
         '#f
         (if (std/os/fd#fd? _dev422_) (std/os/fd#fd-e _dev422_) _dev422_)
         _filter423_
         std/os/kqueue#EV_DELETE
         absent-value
         absent-value
         absent-value
         _kevt425_
         '0)
        (std/os/kqueue#kevent _kqueue421_ _kevt425_ '1 '#f '0))))
  (define std/os/kqueue#kqueue-kevent-disable
    (lambda (_kqueue415_ _dev416_ _filter417_)
      (let ((_kevt419_ (std/os/kqueue#get-kevent-ptr)))
        (std/os/kqueue#kevent-set!__%
         '#f
         (if (std/os/fd#fd? _dev416_) (std/os/fd#fd-e _dev416_) _dev416_)
         _filter417_
         std/os/kqueue#EV_DISABLE
         absent-value
         absent-value
         absent-value
         _kevt419_
         '0)
        (std/os/kqueue#kevent _kqueue415_ _kevt419_ '1 '#f '0))))
  (define std/os/kqueue#kevent-ptr-key 'std/os/kqueue#kevent-ptr)
  (define std/os/kqueue#get-kevent-ptr
    (lambda ()
      (let ((_$e407_ (gerbil/gambit/threads#thread-local-get
                      std/os/kqueue#kevent-ptr-key)))
        (if _$e407_
            (values _$e407_)
            (let ((_kevent-ptr413_
                   (let ((_r410_ (std/os/kqueue#make_kevents '1)))
                     (if _r410_
                         _r410_
                         (error '"Error allocating memory" 'make_kevents)))))
              (gerbil/gambit/threads#thread-local-set!
               std/os/kqueue#kevent-ptr-key
               _kevent-ptr413_)
              _kevent-ptr413_)))))
  (define std/os/kqueue#timespec-zero (std/os/kqueue#make-timespec '0 '0))
  (define std/os/kqueue#make-timespec
    (lambda (_seconds398_ _nanoseconds399_)
      (let ((_timespec404_
             (let ((_r401_ (std/os/kqueue#make_timespec)))
               (if _r401_
                   _r401_
                   (error '"Error allocating memory" 'make_timespec)))))
        (std/os/kqueue#timespec_seconds_set _timespec404_ _seconds398_)
        (std/os/kqueue#timespec_nanoseconds_set _timespec404_ _nanoseconds399_)
        _timespec404_)))
  (define std/os/kqueue#kevent-ident std/os/kqueue#kevent_ident)
  (define std/os/kqueue#kevent-filter std/os/kqueue#kevent_filter)
  (define std/os/kqueue#kevent-flags std/os/kqueue#kevent_flags)
  (define std/os/kqueue#kevent-fflags std/os/kqueue#kevent_fflags)
  (define std/os/kqueue#kevent-data std/os/kqueue#kevent_data)
  (define std/os/kqueue#kevent-udata std/os/kqueue#kevent_udata)
  (define std/os/kqueue#set-kevent-ident! std/os/kqueue#kevent_ident_set)
  (define std/os/kqueue#set-kevent-filter! std/os/kqueue#kevent_filter_set)
  (define std/os/kqueue#set-kevent-flags! std/os/kqueue#kevent_flags_set)
  (define std/os/kqueue#set-kevent-fflags! std/os/kqueue#kevent_fflags_set)
  (define std/os/kqueue#set-kevent-data! std/os/kqueue#kevent_data_set)
  (define std/os/kqueue#set-kevent-udata! std/os/kqueue#kevent_udata_set)
  (define-cond-expand-feature openbsd)
  (define-macro (define-guard guard defn)
    (if (eval `(cond-expand (,guard #t) (else #f)))
        '(begin)
        (begin (eval `(define-cond-expand-feature ,guard)) defn)))
  (define-macro (define-c-lambda id args ret #!optional (name #f))
    (let ((name (or name (symbol->string id))))
      `(define ,id (c-lambda ,args ,ret ,name))))
  (define-macro (define-const symbol)
    (let* ((str (symbol->string symbol))
           (ref (string-append "___return (" str ");")))
      `(define ,symbol ((c-lambda () int ,ref)))))
  (define-macro (define-const* symbol)
    (let* ((str (symbol->string symbol))
           (code (string-append
                  "#ifdef "
                  str
                  "\n"
                  "___return (___FIX ("
                  str
                  "));\n"
                  "#else \n"
                  "___return (___FAL);\n"
                  "#endif")))
      `(define ,symbol ((c-lambda () scheme-object ,code)))))
  (define-macro (define-with-errno symbol ffi-symbol args)
    `(define (,symbol ,@args)
       (declare (not interrupts-enabled))
       (let ((r (,ffi-symbol ,@args)))
         (if (##fx< r 0) (##fx- (##c-code "___RESULT = ___FIX (errno);")) r))))
  (define-macro (define-c-struct
                 struct
                 #!optional
                 (members '())
                 release-function)
    (let* ((struct-str (symbol->string struct))
           (struct-ptr (string->symbol (string-append struct-str "*")))
           (shallow-ptr
            (string->symbol (string-append struct-str "-shallow-ptr*")))
           (borrowed-ptr
            (string->symbol (string-append struct-str "-borrowed-ptr*")))
           (string-types
            '(char-string
              nonull-char-string
              UTF-8-string
              nonnull-UTF-8-string
              UTF-16-string
              nonnull-UTF16-string))
           (string-compat-required?
            (let loop ((m members))
              (cond ((null? m) #f)
                    ((member (cdr (car m)) string-types) #t)
                    (else (loop (cdr m))))))
           (string-setter-body
            (lambda (member-name)
              (let ((m (string-append "___arg1->" member-name)))
                (string-append
                 "if("
                 m
                 " == NULL)"
                 "\n"
                 m
                 "= strdup(___arg2);"
                 "\n"
                 "else if (strcmp("
                 m
                 ", ___arg2) != 0) {"
                 "\n"
                 "free("
                 m
                 ");"
                 "\n"
                 m
                 "= strdup(___arg2);"
                 "\n"
                 "}"
                 "\n"
                 "___return;"
                 "\n"))))
           (default-free-body
            (and string-compat-required?
                 (string-append
                  "___SCMOBJ "
                  struct-str
                  "_ffi_free (void *ptr) {"
                  "\n"
                  "struct "
                  struct-str
                  " *obj = (struct "
                  struct-str
                  "*) ptr;"
                  "\n"
                  (apply string-append
                         (map (lambda (m)
                                (cond ((memq (cdr m) string-types)
                                       (let ((mem-name
                                              (symbol->string (car m))))
                                         (string-append
                                          "if(obj->"
                                          mem-name
                                          ") "
                                          "free(obj->"
                                          mem-name
                                          ");"
                                          "\n")))
                                      (else "")))
                              members))
                  "free(obj);"
                  "\n"
                  "return ___FIX (___NO_ERR);"
                  "\n"
                  "}")))
           (release-function
            (or release-function
                (if string-compat-required?
                    (string-append struct-str "_ffi_free")
                    "ffi_free")))
           (string-compat-types
            (if string-compat-required?
                `((c-declare ,default-free-body)
                  (c-define-type
                   ,shallow-ptr
                   (pointer ,struct (,struct-ptr) "ffi_free")))
                '())))
      `(begin
         (c-define-type ,struct (struct ,struct-str))
         (c-define-type
          ,struct-ptr
          (pointer ,struct (,struct-ptr) ,release-function))
         (c-define-type ,borrowed-ptr (pointer ,struct (,struct-ptr)))
         ,@string-compat-types
         (define ,(string->symbol (string-append struct-str "-ptr?"))
           (lambda (obj)
             (and (foreign? obj) (equal? (foreign-tags obj) '(,struct-ptr)))))
         ,@(apply append
                  (map (lambda (m)
                         (let* ((member-name (symbol->string (car m)))
                                (member-type (cdr m))
                                (getter-name
                                 (string-append struct-str "-" member-name))
                                (setter-body
                                 (cond ((member member-type string-types)
                                        (string-setter-body member-name))
                                       (else
                                        (string-append
                                         "___arg1->"
                                         member-name
                                         " = ___arg2;"
                                         "\n"
                                         "___return;"
                                         "\n")))))
                           `((define ,(string->symbol getter-name)
                               (c-lambda
                                (,struct-ptr)
                                ,member-type
                                ,(string-append
                                  "___return(___arg1->"
                                  member-name
                                  ");")))
                             (define ,(string->symbol
                                       (string-append getter-name "-set!"))
                               (c-lambda
                                (,struct-ptr ,member-type)
                                void
                                ,setter-body)))))
                       members))
         (define ,(string->symbol (string-append "malloc-" struct-str))
           (c-lambda
            ()
            ,struct-ptr
            ,(string-append
              "struct "
              struct-str
              "* var = (struct "
              struct-str
              " *) malloc(sizeof(struct "
              struct-str
              "));"
              "\n"
              "if (var == NULL)"
              "\n"
              "    ___return (NULL);"
              "\n"
              "memset(var, 0, sizeof(struct "
              struct-str
              "));"
              "___return(var);")))
         (define ,(string->symbol (string-append "ptr->" struct-str))
           (c-lambda (,struct-ptr) ,struct "___return(*___arg1);"))
         (define ,(string->symbol
                   (string-append "malloc-" struct-str "-array"))
           (c-lambda
            (unsigned-int32)
            ,(if string-compat-required? shallow-ptr struct-ptr)
            ,(string-append
              "struct "
              struct-str
              " *arr_var=(struct "
              struct-str
              " *) malloc(___arg1*sizeof(struct "
              struct-str
              "));"
              "\n"
              "if (arr_var == NULL)"
              "\n"
              "    ___return (NULL);"
              "\n"
              "memset(arr_var, 0, ___arg1*sizeof(struct "
              struct-str
              "));"
              "\n"
              "___return(arr_var);")))
         (define ,(string->symbol (string-append struct-str "-array-ref"))
           (c-lambda
            (,struct-ptr unsigned-int32)
            ,borrowed-ptr
            "___return (___arg1 + ___arg2);"))
         (define ,(string->symbol (string-append struct-str "-array-set!"))
           (c-lambda
            (,struct-ptr unsigned-int32 ,struct-ptr)
            void
            "*(___arg1 + ___arg2) = *___arg3; ___return;")))))
  (c-declare "#include <stdlib.h>")
  (c-declare "#include <string.h>")
  (c-declare "#include <errno.h>")
  (c-declare "static ___SCMOBJ ffi_free (void *ptr);")
  (c-declare
   "#ifndef ___HAVE_FFI_U8VECTOR\n#define ___HAVE_FFI_U8VECTOR\n#define U8_DATA(obj) ___CAST (___U8*, ___BODY_AS (obj, ___tSUBTYPED))\n#define U8_LEN(obj) ___HD_BYTES (___HEADER (obj))\n#endif")
  (namespace
   ("std/os/kqueue#"
    ev_set
    kevent_udata_set
    kevent_udata
    kevent_data_set
    kevent_data
    kevent_fflags_set
    kevent_fflags
    kevent_flags_set
    kevent_flags
    kevent_filter_set
    kevent_filter
    kevent_ident_set
    kevent_ident
    make_kevents
    __kevent
    __kqueue
    _kevent
    _kqueue
    timespec_nanoseconds_set
    timespec_seconds_set
    make_timespec
    timespec*
    timespec
    kevent*
    NOTE_WRITE
    NOTE_USECONDS
    NOTE_TRUNCATE
    NOTE_TRACKERR
    NOTE_TRACK
    NOTE_SIGNAL
    NOTE_SECONDS
    NOTE_REVOKE
    NOTE_RENAME
    NOTE_REAP
    NOTE_READ
    NOTE_OPEN
    NOTE_OOB
    NOTE_NSECONDS
    NOTE_MSECONDS
    NOTE_MACHTIME
    NOTE_LOWAT
    NOTE_LINK
    NOTE_LEEWAY
    NOTE_FUNLOCK
    NOTE_FORK
    NOTE_FFOR
    NOTE_FFNOP
    NOTE_FFLAGSMASK
    NOTE_FFCTRLMASK
    NOTE_FFCOPY
    NOTE_FFAND
    NOTE_EXTEND
    NOTE_EXITSTATUS
    NOTE_EXIT
    NOTE_EXEC
    NOTE_DELETE
    NOTE_CRITICAL
    NOTE_CLOSE_WRITE
    NOTE_CLOSE
    NOTE_CHANGE
    NOTE_BACKGROUND
    NOTE_ATTRIB
    NOTE_ABSOLUTE
    EV_RECEIPT
    EV_OOBAND
    EV_ONESHOT
    EV_ERROR
    EV_EOF
    EV_ENABLE
    EV_DISPATCH
    EV_DISABLE
    EV_DELETE
    EV_CLEAR
    EV_ADD
    EVFILT_WRITE
    EVFILT_VNODE
    EVFILT_USER
    EVFILT_TIMER
    EVFILT_SIGNAL
    EVFILT_READ
    EVFILT_PROCDESC
    EVFILT_PROC
    EVFILT_MACHPORT
    EVFILT_FS
    EVFILT_EXCEPT
    EVFILT_DEVICE
    EVFILT_AIO))
  (c-declare "#include <sys/types.h>")
  (c-declare "#include <sys/event.h>")
  (c-declare "#include <sys/time.h>")
  (namespace ("std/os/kqueue#" kevent))
  (define-const EV_ADD)
  (define-const EV_ENABLE)
  (define-const EV_DISABLE)
  (define-const EV_DELETE)
  (define-const EV_ONESHOT)
  (define-const EV_CLEAR)
  (define-const EV_EOF)
  (define-const EV_ERROR)
  (cond-expand
   ((or openbsd freebsd) (define-const EV_RECEIPT) (define-const EV_DISPATCH))
   (netbsd)
   (darwin (define-const EV_RECEIPT) (define-const EV_OOBAND)))
  (define-const EVFILT_READ)
  (define-const EVFILT_WRITE)
  (define-const EVFILT_VNODE)
  (define-const EVFILT_PROC)
  (define-const EVFILT_SIGNAL)
  (define-const EVFILT_TIMER)
  (cond-expand
   (openbsd (define-const EVFILT_DEVICE))
   (netbsd (define-const EVFILT_AIO))
   (freebsd (define-const EVFILT_AIO)
            (define-const EVFILT_PROCDESC)
            (define-const EVFILT_USER))
   (darwin (define-const EVFILT_AIO) (define-const EVFILT_MACHPORT)))
  (define-const NOTE_WRITE)
  (define-const NOTE_DELETE)
  (define-const NOTE_EXTEND)
  (define-const NOTE_ATTRIB)
  (define-const NOTE_LINK)
  (define-const NOTE_RENAME)
  (define-const NOTE_REVOKE)
  (define-const NOTE_EXIT)
  (define-const NOTE_FORK)
  (define-const NOTE_EXEC)
  (define-const NOTE_LOWAT)
  (cond-expand
   (openbsd (define-const NOTE_TRUNCATE)
            (define-const NOTE_TRACK)
            (define-const NOTE_TRACKERR)
            (define-const NOTE_CHANGE))
   (netbsd (define-const NOTE_TRACK) (define-const NOTE_TRACKERR))
   (freebsd (define-const NOTE_CLOSE)
            (define-const NOTE_CLOSE_WRITE)
            (define-const NOTE_OPEN)
            (define-const NOTE_READ)
            (define-const NOTE_TRACK)
            (define-const NOTE_SECONDS)
            (define-const NOTE_MSECONDS)
            (define-const NOTE_USECONDS)
            (define-const NOTE_NSECONDS)
            (define-const NOTE_FFNOP)
            (define-const NOTE_FFAND)
            (define-const NOTE_FFOR)
            (define-const NOTE_FFCOPY)
            (define-const NOTE_FFCTRLMASK)
            (define-const NOTE_FFLAGSMASK))
   (darwin (define-const NOTE_EXITSTATUS)
           (define-const NOTE_SIGNAL)
           (define-const NOTE_REAP)
           (define-const NOTE_SECONDS)
           (define-const NOTE_USECONDS)
           (define-const NOTE_NSECONDS)
           (define-const NOTE_ABSOLUTE)
           (define-const NOTE_CRITICAL)
           (define-const NOTE_BACKGROUND)
           (define-const NOTE_LEEWAY)))
  (c-define-type kevent (struct "kevent"))
  (c-define-type kevent* (pointer kevent (kevent*) "ffi_free"))
  (define-guard ffi-have-timespec (c-define-type timespec (struct "timespec")))
  (define-guard
   ffi-have-timespec*
   (c-define-type timespec* (pointer timespec (timespec*) "ffi_free")))
  (define-c-lambda
   make_timespec
   ()
   timespec*
   "___return ((struct timespec*)malloc(sizeof(struct timespec)));")
  (define-c-lambda
   timespec_seconds_set
   (timespec* int)
   void
   "___arg1->tv_sec = ___arg2; ___return ;")
  (define-c-lambda
   timespec_nanoseconds_set
   (timespec* int)
   void
   "___arg1->tv_nsec = ___arg2; ___return ;")
  (define-c-lambda __kqueue () int "kqueue")
  (define-c-lambda
   __kevent
   (int kevent* int kevent* int timespec*)
   int
   "kevent")
  (define-with-errno _kqueue __kqueue ())
  (define-with-errno _kevent __kevent (kqfd chgs nchgs evts nevts timeo))
  (define-c-lambda
   make_kevents
   (int)
   kevent*
   "___return ((struct kevent*)malloc (___arg1 * sizeof (struct kevent)));")
  (define-c-lambda
   kevent_ident
   (kevent* int)
   unsigned-int
   "___return (___arg1[___arg2].ident);")
  (define-c-lambda
   kevent_ident_set
   (kevent* int unsigned-int)
   void
   "___arg1[___arg2].ident = ___arg3; ___return;")
  (define-c-lambda
   kevent_filter
   (kevent* int)
   short
   "___return (___arg1[___arg2].filter);")
  (define-c-lambda
   kevent_filter_set
   (kevent* int short)
   void
   "___arg1[___arg2].filter = ___arg3; ___return;")
  (define-c-lambda
   kevent_flags
   (kevent* int)
   unsigned-short
   "___return (___arg1[___arg2].flags);")
  (define-c-lambda
   kevent_flags_set
   (kevent* int unsigned-short)
   void
   "___arg1[___arg2].flags = ___arg3; ___return;")
  (define-c-lambda
   kevent_fflags
   (kevent* int)
   unsigned-int
   "___return (___arg1[___arg2].fflags);")
  (define-c-lambda
   kevent_fflags_set
   (kevent* int unsigned-int)
   void
   "___arg1[___arg2].fflags = ___arg3; ___return;")
  (define-c-lambda
   kevent_data
   (kevent* int)
   int64
   "___return (___arg1[___arg2].data);")
  (define-c-lambda
   kevent_data_set
   (kevent* int int64)
   void
   "___arg1[___arg2].data = ___arg3; ___return;")
  (define-c-lambda
   kevent_udata
   (kevent* int)
   (pointer void)
   "___return (___arg1[___arg2].udata);")
  (define-c-lambda
   kevent_udata_set
   (kevent* int (pointer void))
   void
   "___arg1[___arg2].udata = ___arg3; ___return;")
  (define-c-lambda
   ev_set
   (kevent* int
            unsigned-int
            short
            unsigned-short
            unsigned-int
            int64
            (pointer void))
   void
   "EV_SET(&___arg1[___arg2], ___arg3, ___arg4, ___arg5, ___arg6, ___arg7, ___arg8); ___return;")
  (c-declare
   "#ifndef ___HAVE_FFI_FREE\n#define ___HAVE_FFI_FREE\n___SCMOBJ ffi_free (void *ptr)\n{\n free (ptr);\n return ___FIX (___NO_ERR);\n}\n#endif"))
