/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

public class Lock {
    private Thread owner;
    private int cnt = 0;
    private String name;

    public Lock(String name) {
        this.name = name;
    }

    public synchronized void acquire() {
        Thread currThread = Thread.currentThread();
        while (true) {
            if (this.owner == null) {
                this.cnt = 1;
                this.owner = currThread;
                return;
            }
            if (this.owner == currThread) {
                ++this.cnt;
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public synchronized void release() {
        Thread currThread = Thread.currentThread();
        if (this.cnt > 0 && this.owner == currThread) {
            if (--this.cnt == 0) {
                this.owner = null;
                this.notify();
            }
        } else {
            throw new IllegalStateException("Attempted to release an unowned lock: " + this.name);
        }
    }

    public Thread getOwner() {
        return this.owner;
    }
}

