/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.support.RowColLocation;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;

public abstract class AbstractTextFieldElement
implements FieldElement {
    protected AttributedString attributedString;
    protected int row;
    protected int column;

    protected AbstractTextFieldElement(AttributedString attributedString, int row, int column) {
        this.attributedString = attributedString;
        this.row = row;
        this.column = column;
    }

    @Override
    public String getText() {
        return this.attributedString.getText();
    }

    @Override
    public char charAt(int index) {
        return this.attributedString.getText().charAt(index);
    }

    @Override
    public int length() {
        return this.getText().length();
    }

    @Override
    public int getStringWidth() {
        return this.attributedString.getStringWidth();
    }

    @Override
    public int getHeightAbove() {
        return this.attributedString.getHeightAbove();
    }

    @Override
    public int getHeightBelow() {
        return this.attributedString.getHeightBelow();
    }

    @Override
    public int getMaxCharactersForWidth(int width) {
        return this.attributedString.getColumnPosition(width);
    }

    @Override
    public Color getColor(int charIndex) {
        return this.attributedString.getColor(charIndex);
    }

    @Override
    public FieldElement getFieldElement(int characterOffset) {
        return this;
    }

    @Override
    public FieldElement substring(int start) {
        return this.substring(start, this.attributedString.length());
    }

    public String toString() {
        return this.attributedString.getText();
    }

    @Override
    public RowColLocation getDataLocationForCharacterIndex(int characterIndex) {
        if (characterIndex < 0 || characterIndex > this.attributedString.getText().length()) {
            throw new IllegalArgumentException("columnPosition is out of range: " + characterIndex);
        }
        return new RowColLocation(this.row, this.column + characterIndex);
    }

    @Override
    public int getCharacterIndexForDataLocation(int dataRow, int dataColumn) {
        if (dataRow == this.row && dataColumn >= this.column && dataColumn <= this.column + this.length()) {
            return dataColumn - this.column;
        }
        return -1;
    }

    @Override
    public void paint(JComponent c, Graphics g, int x, int y) {
        this.attributedString.paint(c, g, x, y);
    }
}

