/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.cparser;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.TaskScheduler;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.OptionDialog;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.dialogs.InputDialog;
import docking.widgets.dialogs.InputDialogListener;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.pathmanager.PathnameTablePanel;
import generic.jar.ResourceFile;
import ghidra.app.plugin.core.cparser.CParserPlugin;
import ghidra.app.plugin.core.cparser.IncludeFileFinder;
import ghidra.framework.Application;
import ghidra.framework.options.SaveState;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.store.db.PackedDatabase;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import resources.Icons;
import resources.ResourceManager;

class ParseDialog
extends DialogComponentProvider {
    static final String PROFILE_DIR = "parserprofiles";
    private static String FILE_EXTENSION = ".prf";
    private static String CURRENT_PROFILE = "CurrentProfile";
    private static String USER_DEFINED = "IsUserDefined";
    private static String LAST_IMPORT_C_DIRECTORY = "LastImportCDirectory";
    private JPanel mainPanel;
    private CParserPlugin plugin;
    private JButton parseButton;
    private JButton parseToFileButton;
    private PathnameTablePanel pathPanel;
    private JTextArea parseOptionsField;
    private GhidraComboBox<ComboBoxItem> comboBox;
    private DefaultComboBoxModel<ComboBoxItem> comboModel;
    private DockingAction saveAction;
    private DockingAction saveAsAction;
    private DockingAction clearAction;
    private DockingAction deleteAction;
    private DockingAction refreshAction;
    private DocumentListener docListener;
    private TableModelListener tableListener;
    private ItemListener comboItemListener;
    private TableModel tableModel;
    private ArrayList<ComboBoxItem> itemList;
    private ComboBoxItemComparator comparator;
    private ResourceFile parentUserFile;
    private GhidraFileChooser fileChooser;
    private boolean saveAsInProgress;

    ParseDialog(CParserPlugin plugin) {
        super("Parse C Source", false);
        this.plugin = plugin;
        this.itemList = new ArrayList();
        this.comparator = new ComboBoxItemComparator();
        this.addWorkPanel(this.buildMainPanel());
        this.addDismissButton();
        this.createActions();
        this.setActionsEnabled();
    }

    void writeState(SaveState saveState) {
        ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
        saveState.putString(CURRENT_PROFILE, item.file.getName());
        saveState.putBoolean(USER_DEFINED, item.isUserDefined);
    }

    void readState(SaveState saveState) {
        String name = saveState.getString(CURRENT_PROFILE, null);
        if (name != null) {
            boolean userDefined = saveState.getBoolean(USER_DEFINED, true);
            for (int i = 0; i < this.itemList.size(); ++i) {
                ComboBoxItem item = this.itemList.get(i);
                if (userDefined != item.isUserDefined || !name.equals(item.file.getName())) continue;
                this.comboBox.setSelectedIndex(i);
                break;
            }
        }
    }

    void closeProfile() {
        ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
        if (item.isChanged) {
            this.processItemChanged(item);
        }
    }

    protected TaskScheduler getTaskScheduler() {
        return super.getTaskScheduler();
    }

    protected JPanel buildMainPanel() {
        this.mainPanel = new JPanel(new BorderLayout(10, 5));
        this.comboModel = new DefaultComboBoxModel();
        this.populateComboBox();
        this.comboBox = new GhidraComboBox(this.comboModel);
        this.comboItemListener = e -> this.selectionChanged(e);
        this.comboBox.addItemListener(this.comboItemListener);
        JPanel cPanel = new JPanel(new BorderLayout());
        cPanel.setBorder(BorderFactory.createTitledBorder("Parse Configuration"));
        cPanel.add((Component)this.comboBox);
        JPanel comboPanel = new JPanel(new BorderLayout());
        comboPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        comboPanel.add(cPanel);
        this.pathPanel = new PathnameTablePanel(null, true, false);
        this.pathPanel.setBorder((Border)BorderFactory.createTitledBorder("Source files to parse"));
        String importDir = Preferences.getProperty((String)LAST_IMPORT_C_DIRECTORY);
        if (importDir == null && (importDir = Preferences.getProperty((String)"LastImportDirectory")) != null) {
            Preferences.setProperty((String)LAST_IMPORT_C_DIRECTORY, (String)importDir);
        }
        this.pathPanel.setFileChooserProperties("Choose Source Files", LAST_IMPORT_C_DIRECTORY, GhidraFileChooserMode.FILES_AND_DIRECTORIES, true, (GhidraFileFilter)new ExtensionFileFilter(new String[]{"h"}, "C Header Files"));
        this.tableListener = e -> {
            ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
            item.isChanged = true;
            this.setActionsEnabled();
        };
        this.tableModel = this.pathPanel.getTable().getModel();
        this.tableModel.addTableModelListener(this.tableListener);
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.setBorder(BorderFactory.createTitledBorder("Parse Options"));
        this.parseOptionsField = new JTextArea(5, 70);
        JScrollPane pane = new JScrollPane(this.parseOptionsField);
        pane.getViewport().setPreferredSize(new Dimension(300, 200));
        optionsPanel.add((Component)pane, "Center");
        this.parseButton = new JButton("Parse to Program");
        this.parseButton.addActionListener(ev -> this.doParse(false));
        this.parseButton.setToolTipText("Parse files and add data types to current program");
        this.addButton(this.parseButton);
        this.parseToFileButton = new JButton("Parse to File...");
        this.parseToFileButton.addActionListener(ev -> this.doParse(true));
        this.parseToFileButton.setToolTipText("Parse files and output to archive file");
        this.addButton(this.parseToFileButton);
        this.pathPanel.setPreferredSize(new Dimension(this.pathPanel.getPreferredSize().width, 200));
        JSplitPane splitPane = new JSplitPane(0, (Component)this.pathPanel, optionsPanel);
        splitPane.setResizeWeight(0.5);
        this.mainPanel.add((Component)comboPanel, "North");
        this.mainPanel.add((Component)splitPane, "Center");
        this.setHelpLocation(new HelpLocation(this.plugin.getName(), "Parse_C_Source"));
        this.loadProfile();
        return this.mainPanel;
    }

    private void selectionChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            ComboBoxItem item = (ComboBoxItem)e.getItem();
            if (item.isChanged && !this.saveAsInProgress) {
                if (item.isUserDefined) {
                    if (OptionDialog.showOptionDialog((Component)this.rootPanel, (String)"Save Changes to Profile?", (String)("Profile " + item.file.getName() + " has changed.\nDo you want to save your changes?"), (String)"Yes", (int)3) == 1) {
                        this.save(item);
                    }
                } else if (OptionDialog.showOptionDialog((Component)this.rootPanel, (String)"Save Changes to Another Profile?", (String)("You have made changes to the default profile " + item.file.getName() + ",\nhowever, updating default profiles is not allowed.\nDo you want to save your changes to another profile?"), (String)"Yes", (int)3) == 1) {
                    this.saveAs(item);
                }
            }
        }
        if (e.getStateChange() == 1) {
            this.loadProfile();
        }
    }

    private void processItemChanged(ComboBoxItem item) {
        if (item.isUserDefined) {
            if (OptionDialog.showOptionDialog((Component)this.rootPanel, (String)"Save Changes to Profile?", (String)("Profile " + item.file.getName() + " has changed.\nDo you want to save your changes?"), (String)"Yes", (int)3) == 1) {
                this.save(item);
            }
        } else if (OptionDialog.showOptionDialog((Component)this.rootPanel, (String)"Save Changes to Another Profile?", (String)("You have made changes to the default profile " + item.file.getName() + ",\nhowever, updating default profiles is not allowed.\nDo you want to save your changes to another profile?"), (String)"Yes", (int)3) == 1) {
            this.saveAs(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProfile() {
        if (this.docListener != null) {
            this.parseOptionsField.getDocument().removeDocumentListener(this.docListener);
        }
        this.tableModel.removeTableModelListener(this.tableListener);
        ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
        StringBuffer sb = new StringBuffer();
        ArrayList<String> pathList = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(item.file.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("-") || line.length() == 0 && sb.length() > 0) {
                    sb.append(line + "\n");
                    continue;
                }
                if (line.length() <= 0) continue;
                File f = new File(line);
                pathList.add(f.getPath());
            }
            String[] paths = new String[pathList.size()];
            paths = pathList.toArray(paths);
            this.pathPanel.setPaths(paths);
            this.parseOptionsField.setText(sb.toString());
            br.close();
        }
        catch (FileNotFoundException e) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"File Not Found", (Object)("Could not find file\n" + item.file.getAbsolutePath()));
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Error Loading Profile", (Object)("Exception occurred while reading file\n" + item.file.getAbsolutePath() + ": " + e));
        }
        finally {
            this.addDocumentListener();
            this.tableModel.addTableModelListener(this.tableListener);
            this.setActionsEnabled();
        }
    }

    private void addDocumentListener() {
        if (this.docListener == null) {
            this.docListener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ParseDialog.this.itemChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ParseDialog.this.itemChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ParseDialog.this.itemChanged();
                }
            };
        }
        this.parseOptionsField.getDocument().addDocumentListener(this.docListener);
    }

    private void itemChanged() {
        ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
        item.isChanged = true;
        this.setActionsEnabled();
    }

    private void createActions() {
        this.saveAction = new DockingAction("Save Profile", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ParseDialog.this.save((ComboBoxItem)ParseDialog.this.comboBox.getSelectedItem());
            }
        };
        this.saveAction.setEnabled(false);
        ImageIcon icon = ResourceManager.loadImage((String)"images/disk.png");
        String saveGroup = "save";
        this.saveAction.setMenuBarData(new MenuData(new String[]{"Save"}, (Icon)icon, saveGroup));
        this.saveAction.setToolBarData(new ToolBarData((Icon)icon, saveGroup));
        this.saveAction.setDescription("Save profile");
        this.addAction((DockingActionIf)this.saveAction);
        this.saveAsAction = new DockingAction("Save Profile As", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ParseDialog.this.saveAs((ComboBoxItem)ParseDialog.this.comboBox.getSelectedItem());
            }
        };
        this.saveAsAction.setEnabled(true);
        icon = ResourceManager.loadImage((String)"images/disk_save_as.png");
        this.saveAsAction.setMenuBarData(new MenuData(new String[]{"Save As..."}, (Icon)icon, saveGroup));
        this.saveAsAction.setToolBarData(new ToolBarData((Icon)icon, saveGroup));
        this.saveAsAction.setDescription("Save profile to new name");
        this.addAction((DockingActionIf)this.saveAsAction);
        this.clearAction = new DockingAction("Clear Profile", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ParseDialog.this.clear();
            }
        };
        this.clearAction.setEnabled(true);
        icon = ResourceManager.loadImage((String)"images/erase16.png");
        String clearGroup = "clear";
        this.clearAction.setMenuBarData(new MenuData(new String[]{"Clear Profile"}, (Icon)icon, clearGroup));
        this.clearAction.setToolBarData(new ToolBarData((Icon)icon, clearGroup));
        this.clearAction.setDescription("Clear profile");
        this.addAction((DockingActionIf)this.clearAction);
        this.refreshAction = new DockingAction("Refresh User Profiles", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ParseDialog.this.refresh();
            }
        };
        this.refreshAction.setEnabled(true);
        icon = Icons.REFRESH_ICON;
        String refreshGroup = "refresh";
        this.refreshAction.setMenuBarData(new MenuData(new String[]{"Refresh"}, (Icon)icon, refreshGroup));
        this.refreshAction.setToolBarData(new ToolBarData((Icon)icon, refreshGroup));
        this.refreshAction.setDescription("Refresh list of user profiles");
        this.addAction((DockingActionIf)this.refreshAction);
        this.deleteAction = new DockingAction("Delete Profile", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ParseDialog.this.delete();
            }
        };
        this.deleteAction.setEnabled(false);
        icon = ResourceManager.loadImage((String)"images/edit-delete.png");
        String deleteGroup = "Xdelete";
        this.deleteAction.setMenuBarData(new MenuData(new String[]{"Delete"}, (Icon)icon, deleteGroup));
        this.deleteAction.setToolBarData(new ToolBarData((Icon)icon, deleteGroup));
        this.deleteAction.setDescription("Delete profile");
        this.addAction((DockingActionIf)this.deleteAction);
    }

    private void refresh() {
        ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
        if (item.isChanged) {
            this.processItemChanged(item);
        }
        this.comboBox.removeItemListener(this.comboItemListener);
        this.itemList.clear();
        this.comboModel.removeAllElements();
        this.populateComboBox();
        this.comboBox.addItemListener(this.comboItemListener);
        if (this.itemList.contains(item)) {
            this.comboBox.setSelectedItem((Object)item);
        } else {
            this.loadProfile();
        }
    }

    private void clear() {
        this.pathPanel.clear();
        this.parseOptionsField.setText("");
        ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
        item.isChanged = true;
    }

    private void save(ComboBoxItem item) {
        if (!item.isUserDefined) {
            this.saveAs(item);
        } else {
            this.writeProfile(item.file);
            item.isChanged = false;
            this.setActionsEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAs(ComboBoxItem item) {
        InputDialog d = new InputDialog("Enter Profile Name", "Profile Name", (InputDialogListener)null);
        this.plugin.getTool().showDialog((DialogComponentProvider)d, (Component)this.getComponent());
        Object name = d.getValue();
        if (name != null && ((String)name).length() > 0) {
            int index;
            ComboBoxItem newItem;
            ResourceFile file;
            if (!((String)name).endsWith(FILE_EXTENSION)) {
                name = (String)name + FILE_EXTENSION;
            }
            if ((file = new ResourceFile(this.parentUserFile, (String)name)).equals((Object)item.file)) {
                this.save(item);
                return;
            }
            if (file.exists()) {
                if (OptionDialog.showOptionDialog((Component)this.rootPanel, (String)"Overwrite Existing File?", (String)("The file " + file.getAbsolutePath() + " already exists.\nDo you want to overwrite it?"), (String)"Yes", (int)3) != 1) {
                    return;
                }
                file.delete();
            }
            if (this.itemList.contains(newItem = new ComboBoxItem(file, true))) {
                this.itemList.remove(newItem);
                this.comboModel.removeElement(newItem);
            }
            if ((index = Collections.binarySearch(this.itemList, newItem, this.comparator)) < 0) {
                index = -index - 1;
            }
            this.itemList.add(index, newItem);
            this.saveAsInProgress = true;
            this.writeProfile(newItem.file);
            newItem.isChanged = false;
            item.isChanged = false;
            try {
                this.comboModel.insertElementAt(newItem, index);
                this.comboBox.setSelectedIndex(index);
            }
            finally {
                this.saveAsInProgress = false;
            }
            this.setActionsEnabled();
        }
    }

    private void writeProfile(ResourceFile outputFile) {
        try {
            String[] paths;
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputFile.getOutputStream()));
            for (String path : paths = this.pathPanel.getPaths()) {
                writer.write(path);
                writer.newLine();
            }
            writer.newLine();
            String optStr = this.parseOptionsField.getText();
            StringTokenizer st = new StringTokenizer(optStr, "\n");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                writer.write(tok);
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Error Writing Profile", (Object)("Writing profile " + outputFile.getName() + " failed"), (Throwable)e);
        }
    }

    private void delete() {
        ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
        if (item.isUserDefined && OptionDialog.showOptionDialog((Component)this.getComponent(), (String)"Delete Profile?", (String)("Are you sure you want to delete profile " + item.getName()), (String)"Delete", (int)3) == 1) {
            item.file.delete();
            this.itemList.remove(item);
            this.comboModel.removeElement(item);
        }
    }

    private void doParse(boolean parseToFile) {
        this.clearStatusText();
        String options = this.getParseOptions();
        String[] paths = this.pathPanel.getPaths();
        if (paths.length == 0) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.rootPanel, (String)"Source Files Not Specified", (Object)"Please specify source files to parse.");
            return;
        }
        paths = this.expandPaths(paths);
        this.pathPanel.setPaths(paths);
        if (parseToFile) {
            File file = this.getSaveFile();
            if (file != null) {
                this.plugin.parse(paths, options, file.getAbsolutePath());
            }
        } else {
            this.plugin.parse(paths, options);
        }
    }

    private String[] expandPaths(String[] paths) {
        ArrayList<String> list = new ArrayList<String>();
        for (String path : paths) {
            File file = new File(path);
            if (file.isDirectory()) {
                IncludeFileFinder includeFileFinder = new IncludeFileFinder(file);
                try {
                    List<String> includeFileRoots = includeFileFinder.getIncludeFileRoots(true);
                    for (String element : includeFileRoots) {
                        String string = element;
                        if (!string.endsWith(".h")) continue;
                        list.add(string);
                    }
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            list.add(path);
        }
        return list.toArray(new String[0]);
    }

    private void populateComboBox() {
        ResourceFile parent = null;
        try {
            parent = Application.getModuleDataSubDirectory((String)PROFILE_DIR);
        }
        catch (IOException e) {
            Msg.error((Object)((Object)this), (Object)"Couldn't find user parser profile dir: parserprofiles", (Throwable)e);
        }
        this.addToComboModel(parent, false);
        this.parentUserFile = new ResourceFile(this.plugin.getUserProfileDir());
        this.addToComboModel(this.parentUserFile, true);
    }

    private void addToComboModel(ResourceFile parent, boolean isUserDefined) {
        ResourceFile[] children;
        for (ResourceFile resourceFile : children = parent.listFiles()) {
            if (resourceFile.getName().startsWith(".")) continue;
            ComboBoxItem item = new ComboBoxItem(resourceFile, isUserDefined);
            this.comboModel.addElement(item);
            this.itemList.add(item);
        }
    }

    private void setActionsEnabled() {
        ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
        if (this.saveAction != null) {
            this.saveAction.setEnabled(item.isChanged && item.isUserDefined);
            this.deleteAction.setEnabled(item.isUserDefined);
        }
    }

    private File getSaveFile() {
        if (this.fileChooser == null) {
            this.fileChooser = new GhidraFileChooser((Component)this.rootPanel);
            String dir = Preferences.getProperty((String)"LastExportDirectory");
            if (dir != null) {
                File file = new File(dir);
                this.fileChooser.setCurrentDirectory(file);
                this.fileChooser.setTitle("Choose Save Archive File");
                this.fileChooser.setApproveButtonText("Choose Save Archive File");
                this.fileChooser.setApproveButtonToolTipText("Choose filename for archive");
            }
        }
        this.fileChooser.rescanCurrentDirectory();
        File file = this.fileChooser.getSelectedFile();
        if (file != null) {
            File parent = file.getParentFile();
            if (parent != null) {
                Preferences.setProperty((String)"LastExportDirectory", (String)parent.getAbsolutePath());
            }
            String name = file.getName();
            if (!file.getName().endsWith(".gdt")) {
                file = new File(file.getParentFile(), name + ".gdt");
            }
            if (file.exists()) {
                if (OptionDialog.showOptionDialog((Component)this.rootPanel, (String)"Overwrite Existing File?", (String)("The file " + file.getAbsolutePath() + " already exists.\nDo you want to overwrite it?"), (String)"Yes", (int)3) != 1) {
                    file = null;
                } else {
                    try {
                        PackedDatabase.delete((File)file);
                    }
                    catch (IOException e) {
                        Msg.showError((Object)((Object)this), (Component)this.mainPanel, (String)"Archive Overwrite Failed", (Object)e.getMessage());
                        return null;
                    }
                }
            }
        }
        return file;
    }

    protected void dismissCallback() {
        this.close();
    }

    void setDialogText(String text) {
        this.setStatusText(text);
    }

    public void close() {
        this.cancelCurrentTask();
        super.close();
    }

    public String getParseOptions() {
        return this.parseOptionsField.getText();
    }

    private class ComboBoxItemComparator
    implements Comparator<ComboBoxItem> {
        private ComboBoxItemComparator() {
        }

        @Override
        public int compare(ComboBoxItem item1, ComboBoxItem item2) {
            if (item1.isUserDefined == item2.isUserDefined) {
                return item1.getName().compareToIgnoreCase(item2.getName());
            }
            if (!item1.isUserDefined) {
                return -1;
            }
            return 1;
        }
    }

    private class ComboBoxItem {
        private ResourceFile file;
        private boolean isUserDefined;
        private boolean isChanged;

        ComboBoxItem(ResourceFile file, boolean isUserDefined) {
            this.file = file;
            this.isUserDefined = isUserDefined;
        }

        public String toString() {
            String name = this.file.getName();
            return name + (this.isUserDefined ? "" : " (Default)");
        }

        public String getName() {
            return this.file.getName();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ComboBoxItem item = (ComboBoxItem)obj;
                return this.file.equals((Object)item.file) && this.isUserDefined == item.isUserDefined;
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
            result = 31 * result + (this.isUserDefined ? 1231 : 1237);
            return result;
        }
    }
}

