/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.dialogs.NumberInputDialog;
import docking.widgets.tree.DefaultGTreeFilterProvider;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeFilterProvider;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.CombinedGTreeFilter;
import docking.widgets.tree.support.GTreeFilter;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.program.model.data.DataType;
import ghidra.util.HelpLocation;

public class FindDataTypesBySizeAction
extends DockingAction {
    private DataTypeManagerPlugin plugin;

    public FindDataTypesBySizeAction(DataTypeManagerPlugin plugin) {
        super("Find Data Types By Size", plugin.getName());
        this.plugin = plugin;
        this.setMenuBarData(new MenuData(new String[]{"Find Data Types by Size..."}, null, "VeryLast", -1, "2"));
        this.setEnabled(true);
        this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Find_Data_Types_By_Size"));
    }

    public void actionPerformed(ActionContext context) {
        NumberInputDialog numberInputDialog = new NumberInputDialog("bytes", 1, 1);
        if (!numberInputDialog.show()) {
            return;
        }
        int value = numberInputDialog.getValue();
        String title = "Find Data Types With Size";
        DataTypesProvider newProvider = this.plugin.createProvider();
        newProvider.setTitle(title);
        DataTypeArchiveGTree tree = newProvider.getGTree();
        tree.setFilterProvider((GTreeFilterProvider)new MyTreeFilterProvider(tree, new SizeGTreeFilter(value)));
        newProvider.setVisible(true);
    }

    private class SizeGTreeFilter
    implements GTreeFilter {
        private final int size;

        SizeGTreeFilter(int size) {
            this.size = size;
        }

        public boolean showFilterMatches() {
            return true;
        }

        public boolean acceptsNode(GTreeNode node) {
            if (!(node instanceof DataTypeNode)) {
                return false;
            }
            DataTypeNode dataTypeNode = (DataTypeNode)node;
            DataType dataType = dataTypeNode.getDataType();
            int length = dataType.getLength();
            return length == this.size;
        }
    }

    private class MyTreeFilterProvider
    extends DefaultGTreeFilterProvider {
        private GTreeFilter secondaryFilter;

        MyTreeFilterProvider(GTree tree, GTreeFilter secondaryFilter) {
            super(tree);
            this.secondaryFilter = secondaryFilter;
        }

        public GTreeFilter getFilter() {
            GTreeFilter filter = super.getFilter();
            if (filter == null) {
                return this.secondaryFilter;
            }
            return new CombinedGTreeFilter(filter, this.secondaryFilter);
        }
    }
}

