/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class UnsupportedLoadCommand
extends LoadCommand {
    private int type;

    static UnsupportedLoadCommand createUnsupportedLoadCommand(FactoryBundledWithBinaryReader reader, int type) throws IOException {
        UnsupportedLoadCommand command = (UnsupportedLoadCommand)reader.getFactory().create(UnsupportedLoadCommand.class, new Object[0]);
        command.initUnsupportedLoadCommand(reader, type);
        return command;
    }

    private void initUnsupportedLoadCommand(FactoryBundledWithBinaryReader reader, int type) throws IOException {
        this.initLoadCommand(reader);
        this.type = type;
    }

    @Override
    public String getCommandName() {
        return "Unsupported Load Command Type = 0x" + Integer.toHexString(this.type);
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        if (isBinary) {
            try {
                this.createFragment(api, baseAddress, parentModule);
                Address address = baseAddress.getNewAddress(this.getStartIndex());
                api.createData(address, this.toDataType());
            }
            catch (Exception e) {
                log.appendMsg("Unable to create " + this.getCommandName() + " - " + e.getMessage());
            }
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

