/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.html.PlaceHolderLine;
import ghidra.app.util.html.TextLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.util.exception.AssertException;
import java.awt.Color;

public class EmptyTextLine
extends TextLine
implements PlaceHolderLine {
    private int widthInCharacters;

    public EmptyTextLine(int widthInCharacters) {
        super(EmptyTextLine.buildDisplayText(widthInCharacters));
        this.widthInCharacters = widthInCharacters;
    }

    private static String buildDisplayText(int numberOfCharacters) {
        StringBuffer buffy = new StringBuffer();
        for (int i = 0; i < numberOfCharacters; ++i) {
            buffy.append(' ');
        }
        return buffy.toString();
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public ValidatableLine copy() {
        return new EmptyTextLine(this.widthInCharacters);
    }

    @Override
    boolean matches(TextLine otherLine) {
        return false;
    }

    @Override
    public void updateColor(ValidatableLine otherValidatableLine, Color invalidColor) {
        if (invalidColor == null) {
            throw new NullPointerException("Color cannot be null");
        }
        if (otherValidatableLine == null || otherValidatableLine instanceof EmptyTextLine) {
            return;
        }
        if (!(otherValidatableLine instanceof TextLine)) {
            throw new AssertException("TextLine can only be matched against other TextLine implementations.");
        }
        TextLine otherLine = (TextLine)otherValidatableLine;
        otherLine.setTextColor(invalidColor);
    }

    @Override
    public String toString() {
        return "<FixedWidthEmptyTextLine>";
    }
}

