/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import generic.jar.ResourceFile;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.ScaledImageIconWrapper;
import resources.icons.TranslateIcon;
import util.CollectionUtils;

public class FileIconService {
    public static final String OVERLAY_IMPORTED = "imported";
    public static final String OVERLAY_FILESYSTEM = "filesystem";
    private static final String FILEEXT_MAPPING_FILE = "file_extension_icons.xml";
    private static final long DELAY_BETWEEN_TS_CHECKS_MS = 10000L;
    private Map<String, String> fileExtToIconName = new HashMap<String, String>();
    private Map<String, String> fileSubstrToIconName = new HashMap<String, String>();
    private Map<String, String> overlayNameToIconName = new HashMap<String, String>();
    private Map<String, OVERLAYQUAD> overlayNameToQuad = new HashMap<String, OVERLAYQUAD>();
    private String defaultIconPath = "images/famfamfam_silk_icons_v013/page_white.png";
    private int maxExtLevel = 1;
    private boolean debug = false;
    private Map<String, Icon> iconKeyToIcon = new HashMap<String, Icon>();
    private long lastModifiedTS;
    private long lastCheckedTS;
    private ResourceFile xmlFile = Application.findDataFileInAnyModule((String)"file_extension_icons.xml");

    public static FileIconService getInstance() {
        return Singleton.INSTANCE;
    }

    private FileIconService() {
        if (this.xmlFile == null) {
            Msg.error((Object)this, (Object)"cannot find file_extension_icons.xml");
        }
    }

    private String makeKey(String key, String[] overlays) {
        StringBuilder sb = new StringBuilder();
        sb.append(key).append("__");
        for (String o : overlays) {
            if (o == null || o.isEmpty()) continue;
            sb.append(o).append("__");
        }
        return sb.toString();
    }

    private Icon getCachedIcon(String key, String path, String ... overlays) {
        Icon cachedIcon = this.iconKeyToIcon.get(key = this.makeKey(key, overlays));
        if (cachedIcon == null) {
            cachedIcon = ResourceManager.loadImage((String)path);
            if (overlays.length > 0) {
                int expectedOW = cachedIcon.getIconWidth() / 2;
                int expectedOH = cachedIcon.getIconHeight() / 2;
                EnumSet<OVERLAYQUAD> usedQuads = EnumSet.noneOf(OVERLAYQUAD.class);
                MultiIcon multiIcon = new MultiIcon(cachedIcon);
                for (String overlay : overlays) {
                    if (overlay == null || overlay.isEmpty()) continue;
                    String overlayPath = this.overlayNameToIconName.get(overlay);
                    OVERLAYQUAD quad = this.overlayNameToQuad.get(overlay);
                    if (overlayPath == null || quad == null) continue;
                    if (usedQuads.contains((Object)quad)) {
                        Msg.warn((Object)this, (Object)("File icon already contains an overlay at " + quad));
                    }
                    usedQuads.add(quad);
                    ImageIcon overlayIcon = ResourceManager.loadImage((String)overlayPath);
                    if (overlayIcon.getIconHeight() != expectedOH || overlayIcon.getIconWidth() != expectedOW) {
                        overlayIcon = new ScaledImageIconWrapper((Icon)overlayIcon, expectedOW, expectedOH);
                    }
                    multiIcon.addIcon((Icon)new TranslateIcon((Icon)overlayIcon, quad.x * expectedOW, quad.y * expectedOH));
                }
                cachedIcon = multiIcon;
            }
            this.iconKeyToIcon.put(key, cachedIcon);
        }
        return cachedIcon;
    }

    public synchronized Icon getImage(String fileName, String ... overlays) {
        String ext;
        this.loadIfNeeded();
        fileName = fileName.toLowerCase();
        for (int extLevel = 1; extLevel <= this.maxExtLevel && (ext = FSUtilities.getExtension(fileName, extLevel)) != null; ++extLevel) {
            String path = this.fileExtToIconName.get(ext);
            if (path == null) continue;
            return this.getCachedIcon(ext, path, overlays);
        }
        for (String substr : this.fileSubstrToIconName.keySet()) {
            if (fileName.indexOf(substr) == -1) continue;
            return this.getCachedIcon("####" + substr, this.fileSubstrToIconName.get(substr), overlays);
        }
        return this.getCachedIcon("", this.defaultIconPath, overlays);
    }

    protected void loadIfNeeded() {
        long now = System.currentTimeMillis();
        if (now - this.lastCheckedTS > 10000L) {
            this.lastCheckedTS = now;
            if (this.debug || this.xmlFile.lastModified() != this.lastModifiedTS) {
                this.lastModifiedTS = this.xmlFile.lastModified();
                this.load();
            }
        }
    }

    private void load() {
        this.fileExtToIconName.clear();
        this.fileSubstrToIconName.clear();
        this.overlayNameToIconName.clear();
        this.overlayNameToQuad.clear();
        this.iconKeyToIcon.clear();
        this.defaultIconPath = null;
        this.maxExtLevel = 1;
        try (InputStream xmlInputStream = this.xmlFile.getInputStream();){
            String iconPath;
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            Document doc = sax.build(xmlInputStream);
            Element root = doc.getRootElement();
            for (Element child : CollectionUtils.asList((List)root.getChildren("file_extension"), Element.class)) {
                String extension = child.getAttributeValue("extension");
                iconPath = child.getAttributeValue("icon");
                if (extension.endsWith(".")) {
                    this.addSubstrMapping(extension, iconPath);
                    continue;
                }
                if (!extension.isEmpty()) {
                    this.addExtMapping(extension, iconPath);
                    continue;
                }
                this.defaultIconPath = iconPath;
            }
            for (Element child : CollectionUtils.asList((List)root.getChildren("file_overlay"), Element.class)) {
                String name = child.getAttributeValue("name");
                iconPath = child.getAttributeValue("icon");
                OVERLAYQUAD quadrant = OVERLAYQUAD.fromString(child.getAttributeValue("quadrant"), OVERLAYQUAD.LR);
                this.overlayNameToIconName.put(name, iconPath);
                this.overlayNameToQuad.put(name, quadrant);
            }
        }
        catch (IOException | JDOMException e) {
            Msg.showError((Object)this, null, (String)"Error reading file icon data", (Object)e.getMessage(), (Throwable)e);
        }
    }

    private void addSubstrMapping(String substr, String iconPath) {
        this.fileSubstrToIconName.put(substr, iconPath);
    }

    private void addExtMapping(String ext, String iconPath) {
        this.fileExtToIconName.put(ext, iconPath);
        this.maxExtLevel = Math.max(this.maxExtLevel, this.countExtLevel(ext));
    }

    private int countExtLevel(String ext) {
        int count = 0;
        for (int i = 0; i < ext.length(); ++i) {
            if (ext.charAt(i) != '.') continue;
            ++count;
        }
        return count;
    }

    private static enum OVERLAYQUAD {
        UL(0, 0),
        UR(1, 0),
        LL(0, 1),
        LR(1, 1);

        int x;
        int y;

        private OVERLAYQUAD(int x, int y) {
            this.x = x;
            this.y = y;
        }

        static OVERLAYQUAD fromString(String s, OVERLAYQUAD defaultValue) {
            if (s != null) {
                try {
                    return OVERLAYQUAD.valueOf(s.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return defaultValue;
        }
    }

    private static final class Singleton {
        private static final FileIconService INSTANCE = new FileIconService();

        private Singleton() {
        }
    }
}

