/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.ProgramConflictException;
import ghidra.program.util.ProgramDiff;
import ghidra.program.util.ProgramDiffFilter;
import ghidra.program.util.ProgramMerge;
import ghidra.program.util.ProgramMergeFilter;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;

public class ProgramMergeManager {
    private StringBuffer errorMsg;
    private StringBuffer infoMsg;
    private Program program1;
    private Program program2;
    private ProgramDiffFilter diffFilter;
    private ProgramDiff programDiff;
    private ProgramMergeFilter mergeFilter;
    private ProgramMerge merger;

    public ProgramMergeManager(Program program1, Program program2, TaskMonitor monitor) throws ProgramConflictException {
        this(program1, program2, null, monitor);
    }

    public ProgramMergeManager(Program program1, Program program2, AddressSetView p1LimitedAddressSet, TaskMonitor monitor) throws ProgramConflictException {
        this.program1 = program1;
        this.program2 = program2;
        if (program1 == null || program2 == null) {
            throw new IllegalArgumentException("program cannot be null.");
        }
        this.programDiff = new ProgramDiff(program1, program2, p1LimitedAddressSet);
        this.diffFilter = this.programDiff.getFilter();
        this.mergeFilter = new ProgramMergeFilter();
        this.merger = new ProgramMerge(program1, program2);
        this.errorMsg = new StringBuffer();
        this.infoMsg = new StringBuffer();
    }

    public boolean memoryMatches() {
        return this.programDiff.memoryMatches();
    }

    public AddressSetView getFilteredDifferences() {
        AddressSetView p2DiffSet = null;
        try {
            p2DiffSet = this.programDiff.getDifferences(this.diffFilter, null);
        }
        catch (CancelledException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        return new AddressSet(p2DiffSet);
    }

    public AddressSetView getFilteredDifferences(TaskMonitor monitor) throws CancelledException {
        return new AddressSet(this.programDiff.getDifferences(this.diffFilter, monitor));
    }

    public ProgramDiffFilter getDiffFilter() {
        return this.diffFilter;
    }

    public void setDiffFilter(ProgramDiffFilter filter) {
        this.programDiff.setFilter(filter);
        this.diffFilter = this.programDiff.getFilter();
    }

    public ProgramMergeFilter getMergeFilter() {
        return new ProgramMergeFilter(this.mergeFilter);
    }

    public void setMergeFilter(ProgramMergeFilter filter) {
        this.mergeFilter = filter != null ? new ProgramMergeFilter(filter) : new ProgramMergeFilter();
    }

    public AddressSetView getCombinedAddresses() {
        return this.programDiff.getCombinedAddresses();
    }

    public AddressSetView getAddressesInCommon() {
        return this.programDiff.getAddressesInCommon();
    }

    public AddressSetView getAddressesOnlyInOne() {
        return this.programDiff.getAddressesOnlyInOne();
    }

    public AddressSetView getAddressesOnlyInTwo() {
        return this.programDiff.getAddressesOnlyInTwo();
    }

    public Program getProgramOne() {
        return this.program1;
    }

    public Program getProgramTwo() {
        return this.program2;
    }

    public AddressSetView getIgnoreAddressSet() {
        return this.programDiff.getIgnoreAddressSet();
    }

    public AddressSetView getLimitedAddressSet() {
        return this.programDiff.getLimitedAddressSet();
    }

    public String getWarnings() {
        return this.programDiff.getWarnings();
    }

    public boolean merge(Address p2Address, ProgramMergeFilter filter) throws MemoryAccessException, CancelledException {
        return this.merge(p2Address, filter, (TaskMonitor)null);
    }

    public boolean merge(Address p2Address, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        return this.merge(p2Address, this.mergeFilter, monitor);
    }

    public boolean merge(Address p2Address, ProgramMergeFilter filter, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        AddressSet p2AddressSet = new AddressSet((AddressRange)new AddressRangeImpl(p2Address, p2Address));
        return this.merge((AddressSetView)p2AddressSet, filter, monitor);
    }

    public void ignore(AddressSetView p1AddressSet) {
        this.programDiff.ignore(p1AddressSet);
    }

    public void restrictResults(AddressSetView p1AddressSet) {
        this.programDiff.setRestrictedAddressSet(p1AddressSet);
    }

    public AddressSetView getRestrictedAddressSet() {
        return this.programDiff.getRestrictedAddressSet();
    }

    public void removeResultRestrictions() {
        this.programDiff.removeRestrictedAddressSet();
    }

    public String getErrorMessage() {
        this.errorMsg.append(this.merger.getErrorMessage());
        this.merger.clearErrorMessage();
        return this.errorMsg.toString();
    }

    public String getInfoMessage() {
        this.infoMsg.append(this.merger.getInfoMessage());
        this.merger.clearInfoMessage();
        return this.infoMsg.toString();
    }

    void clearMessages() {
        if (this.infoMsg.length() > 0) {
            this.infoMsg = new StringBuffer();
        }
        if (this.errorMsg.length() > 0) {
            this.errorMsg = new StringBuffer();
        }
    }

    public boolean merge(AddressSetView p1MergeSet, ProgramMergeFilter filter) throws MemoryAccessException, CancelledException {
        return this.merge(p1MergeSet, filter, (TaskMonitor)null);
    }

    public boolean merge(AddressSetView p1MergeSet, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        return this.merge(p1MergeSet, this.mergeFilter, monitor);
    }

    public boolean merge(AddressSetView p1MergeSet, ProgramMergeFilter filter, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        this.clearMessages();
        this.merger.clearMessages();
        this.merger.clearDuplicateSymbols();
        this.merger.clearDuplicateEquates();
        AddressSet p1CodeUnitSet = DiffUtility.getCodeUnitSet(p1MergeSet, this.program1);
        if (monitor == null) {
            monitor = TaskMonitorAdapter.DUMMY_MONITOR;
        }
        if (!this.hasMergeAddresses(p1MergeSet)) {
            this.errorMsg.append("The Difference cannot be applied.\nThe program does not have memory defined\nfor some of the indicated addresses.\n");
            return false;
        }
        this.mergeBytes(p1MergeSet, filter, monitor);
        this.mergeProgramContext(p1MergeSet, filter, monitor);
        this.mergeCodeUnits(p1MergeSet, filter, monitor);
        this.mergeComments(p1MergeSet, filter, monitor);
        this.mergeFunctions(p1MergeSet, filter, monitor);
        this.mergeLabels(p1MergeSet, filter, monitor);
        this.mergeReferences(p1MergeSet, filter, monitor);
        this.mergeBookmarks(p1MergeSet, filter, monitor);
        this.mergeProperties(p1MergeSet, filter, monitor);
        this.mergeFunctionTags(p1MergeSet, filter, monitor);
        this.merger.reApplyDuplicateEquates();
        String dupEquatesMessage = this.merger.getDuplicateEquatesInfo();
        if (dupEquatesMessage.length() > 0) {
            this.infoMsg.append(dupEquatesMessage);
        }
        this.merger.reApplyDuplicateSymbols();
        String dupSymbolsMessage = this.merger.getDuplicateSymbolsInfo();
        if (dupSymbolsMessage.length() > 0) {
            this.infoMsg.append(dupSymbolsMessage);
        }
        this.programDiff.reDiffSubSet((AddressSetView)p1CodeUnitSet, monitor);
        return this.errorMsg.length() == 0 && !this.merger.hasErrorMessage();
    }

    private boolean hasMergeAddresses(AddressSetView p1AddressSet) {
        return this.program1.getMemory().contains(p1AddressSet);
    }

    void mergeProgramContext(AddressSetView p1MergeSet, ProgramMergeFilter filter, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Applying Program Context...");
        if (filter.getFilter(1) == 0) {
            return;
        }
        ProgramDiffFilter programContextDiffFilter = new ProgramDiffFilter(1);
        AddressSet diffAddrSet = p1MergeSet.intersect(this.programDiff.getDifferences(programContextDiffFilter, monitor));
        AddressSet diffAddrSet2 = DiffUtility.getCompatibleAddressSet((AddressSetView)diffAddrSet, this.program2);
        if (diffAddrSet2.isEmpty()) {
            return;
        }
        this.merger.mergeProgramContext((AddressSetView)diffAddrSet2, monitor);
    }

    void mergeBytes(AddressSetView p1MergeSet, ProgramMergeFilter filter, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        int setting = filter.getFilter(2);
        if (setting == 0) {
            return;
        }
        ProgramDiffFilter byteDiffFilter = new ProgramDiffFilter(2);
        AddressSet diffAddrSet = p1MergeSet.intersect(this.programDiff.getDifferences(byteDiffFilter, monitor));
        AddressSet diffAddrSet2 = DiffUtility.getCompatibleAddressSet((AddressSetView)diffAddrSet, this.program2);
        if (diffAddrSet2.isEmpty()) {
            return;
        }
        this.merger.mergeBytes((AddressSetView)diffAddrSet2, filter.getFilter(4) != 1, monitor);
    }

    void mergeCodeUnits(AddressSetView p1MergeSet, ProgramMergeFilter filter, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        boolean ignoreReferenceDiffs;
        boolean mergeData;
        boolean mergeInstructions = filter.getFilter(4) == 1;
        boolean bl = mergeData = filter.getFilter(8) == 1;
        if (!mergeInstructions && !mergeData) {
            return;
        }
        AddressSet byteDiffs2 = null;
        ProgramDiffFilter byteDiffFilter = new ProgramDiffFilter(2);
        if (filter.getFilter(2) == 0) {
            byteDiffs2 = DiffUtility.getCompatibleAddressSet(this.programDiff.getDifferences(byteDiffFilter, monitor), this.program2);
        }
        ProgramDiffFilter equateDiffFilter = new ProgramDiffFilter(512);
        AddressSetView equateDiffs1 = this.programDiff.getDifferences(equateDiffFilter, monitor);
        AddressSet equateDiffSet1 = equateDiffs1.intersect(p1MergeSet);
        AddressSet equateDiffSet2 = DiffUtility.getCompatibleAddressSet((AddressSetView)equateDiffSet1, this.program2);
        ProgramDiffFilter cuDiffFilter = new ProgramDiffFilter(4);
        AddressSetView codeUnitDiffs1 = this.programDiff.getDifferences(cuDiffFilter, monitor);
        AddressSet codeUnitDiffSet1 = codeUnitDiffs1.intersect(p1MergeSet);
        AddressSet codeUnitDiffSet2 = DiffUtility.getCompatibleAddressSet((AddressSetView)codeUnitDiffSet1, this.program2);
        this.merger.mergeCodeUnits((AddressSetView)codeUnitDiffSet2, (AddressSetView)byteDiffs2, false, monitor);
        boolean onlyKeepDefaults = ignoreReferenceDiffs = filter.getFilter(16) == 0;
        this.merger.mergeReferences((AddressSetView)codeUnitDiffSet2, onlyKeepDefaults, monitor);
        this.merger.mergeEquates((AddressSetView)equateDiffSet2, monitor);
    }

    void mergeFunctionTags(AddressSetView p1AddressSet, ProgramMergeFilter filter, TaskMonitor monitor) {
        int applyTags = filter.getFilter(65536);
        int diffType = 2048;
        try {
            AddressSetView p1DiffSet = this.programDiff.getDifferences(new ProgramDiffFilter(diffType), monitor);
            AddressSet p1MergeSet = p1DiffSet.intersect(p1AddressSet);
            AddressSet p2MergeSet = DiffUtility.getCompatibleAddressSet((AddressSetView)p1MergeSet, this.program2);
            this.merger.applyFunctionTagChanges((AddressSetView)p2MergeSet, applyTags, null, null, monitor);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    void mergeComments(AddressSetView p1MergeSet, ProgramMergeFilter filter, TaskMonitor monitor) throws CancelledException {
        int applyPlateComments = filter.getFilter(32);
        int applyPreComments = filter.getFilter(64);
        int applyEolComments = filter.getFilter(128);
        int applyRepeatableComments = filter.getFilter(256);
        int applyPostComments = filter.getFilter(512);
        this.mergeTypeOfComments(p1MergeSet, 32, applyPlateComments, monitor);
        this.mergeTypeOfComments(p1MergeSet, 64, applyPreComments, monitor);
        this.mergeTypeOfComments(p1MergeSet, 128, applyEolComments, monitor);
        this.mergeTypeOfComments(p1MergeSet, 256, applyRepeatableComments, monitor);
        this.mergeTypeOfComments(p1MergeSet, 512, applyPostComments, monitor);
    }

    void mergeTypeOfComments(AddressSetView p1AddressSet, int mergeCommentType, int applyType, TaskMonitor monitor) throws CancelledException {
        int diffType = 0;
        switch (mergeCommentType) {
            case 32: {
                diffType = 64;
                break;
            }
            case 128: {
                diffType = 8;
                break;
            }
            case 64: {
                diffType = 16;
                break;
            }
            case 512: {
                diffType = 32;
                break;
            }
            case 256: {
                diffType = 128;
                break;
            }
            default: {
                return;
            }
        }
        AddressSetView p1DiffSet = this.programDiff.getDifferences(new ProgramDiffFilter(diffType), monitor);
        AddressSet p1MergeSet = p1DiffSet.intersect(p1AddressSet);
        AddressSet p2MergeSet = DiffUtility.getCompatibleAddressSet((AddressSetView)p1MergeSet, this.program2);
        this.merger.mergeCommentType((AddressSetView)p2MergeSet, mergeCommentType, applyType, monitor);
    }

    void replaceFunctionSymbols(AddressSetView p1MergeSet, ProgramMergeFilter filter, TaskMonitor monitor) throws CancelledException {
        int setting = filter.getFilter(8192);
        if (setting == 0) {
            return;
        }
        AddressSet p2MergeSet = DiffUtility.getCompatibleAddressSet(p1MergeSet, this.program2);
        this.merger.replaceFunctionNames((AddressSetView)p2MergeSet, monitor);
    }

    void mergeFunctions(AddressSetView p1MergeSet, ProgramMergeFilter filter, TaskMonitor monitor) throws CancelledException {
        int setting = filter.getFilter(8192);
        if (setting == 0) {
            return;
        }
        ProgramDiffFilter functionDiffFilter = new ProgramDiffFilter(2048);
        AddressSetView functionDiffSet = this.programDiff.getDifferences(functionDiffFilter, monitor);
        AddressSet diffAddrSet = p1MergeSet.intersect(functionDiffSet);
        AddressSet diffAddrSet2 = DiffUtility.getCompatibleAddressSet((AddressSetView)diffAddrSet, this.program2);
        this.merger.mergeFunctions((AddressSetView)diffAddrSet2, monitor);
    }

    void mergeReferences(AddressSetView p1MergeSet, ProgramMergeFilter filter, TaskMonitor monitor) throws CancelledException {
        boolean mergeRefs;
        boolean bl = mergeRefs = filter.getFilter(16) == 1;
        if (!mergeRefs) {
            return;
        }
        ProgramDiffFilter refDiffFilter = new ProgramDiffFilter(256);
        AddressSetView refDiffSet = this.programDiff.getDifferences(refDiffFilter, monitor);
        AddressSet diffAddrSet = p1MergeSet.intersect(refDiffSet);
        AddressSet diffAddrSet2 = DiffUtility.getCompatibleAddressSet((AddressSetView)diffAddrSet, this.program2);
        this.merger.replaceReferences((AddressSetView)diffAddrSet2, monitor);
    }

    void mergeLabels(AddressSetView p1MergeSet, ProgramMergeFilter filter, TaskMonitor monitor) throws CancelledException {
        int setting = filter.getFilter(1024);
        boolean replacePrimary = filter.getFilter(32768) != 0;
        boolean replaceFunction = filter.getFilter(8192) != 0;
        ProgramDiffFilter symbolDiffFilter = new ProgramDiffFilter(1024);
        AddressSetView symbolDiffSet = this.programDiff.getDifferences(symbolDiffFilter, monitor);
        AddressSet diffAddrSet = p1MergeSet.intersect(symbolDiffSet);
        AddressSet diffAddrSet2 = DiffUtility.getCompatibleAddressSet((AddressSetView)diffAddrSet, this.program2);
        if (setting != 0) {
            this.merger.mergeLabels((AddressSetView)diffAddrSet2, setting, replacePrimary, replaceFunction, monitor);
        } else if (replaceFunction) {
            this.merger.replaceFunctionNames((AddressSetView)diffAddrSet2, monitor);
        }
    }

    void mergeBookmarks(AddressSetView p1MergeSet, ProgramMergeFilter filter, TaskMonitor monitor) throws CancelledException {
        int setting = filter.getFilter(2048);
        if (setting == 0) {
            return;
        }
        ProgramDiffFilter bookmarkDiffFilter = new ProgramDiffFilter(4096);
        AddressSetView bookmarkDiffSet = this.programDiff.getDifferences(bookmarkDiffFilter, monitor);
        AddressSet diffAddrSet = p1MergeSet.intersect(bookmarkDiffSet);
        AddressSet diffAddrSet2 = DiffUtility.getCompatibleAddressSet((AddressSetView)diffAddrSet, this.program2);
        this.merger.mergeBookmarks((AddressSetView)diffAddrSet2, monitor);
    }

    void mergeProperties(AddressSetView p1MergeSet, ProgramMergeFilter filter, TaskMonitor monitor) throws CancelledException {
        int setting = filter.getFilter(4096);
        if (setting == 0) {
            return;
        }
        ProgramDiffFilter propertyDiffFilter = new ProgramDiffFilter(8192);
        AddressSetView propertyDiffSet = this.programDiff.getDifferences(propertyDiffFilter, monitor);
        AddressSet diffAddrSet = p1MergeSet.intersect(propertyDiffSet);
        AddressSet diffAddrSet2 = DiffUtility.getCompatibleAddressSet((AddressSetView)diffAddrSet, this.program2);
        this.merger.mergeProperties((AddressSetView)diffAddrSet2, monitor);
    }
}

