/*
 * Decompiled with CFR 0.152.
 */
package generic.util;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.framework.OperatingSystem;
import java.io.File;

public class Path
implements Comparable<Path> {
    public static final String GHIDRA_HOME = "$GHIDRA_HOME";
    public static final String USER_HOME = "$USER_HOME";
    private ResourceFile path;
    private boolean isEnabled;
    private boolean isEditable;
    private boolean isReadOnly;

    public Path(File path) {
        this(new ResourceFile(path), true, true, false);
    }

    public Path(ResourceFile path) {
        this(path, true, true, false);
    }

    public Path(ResourceFile path, boolean isEnabled, boolean isEditable, boolean isReadOnly) {
        this.path = path;
        this.isEnabled = isEnabled;
        this.isEditable = isEditable;
        this.isReadOnly = isReadOnly;
    }

    public Path(String path) {
        this(path, true, true, false);
    }

    public Path(String path, boolean enabled) {
        this(path, enabled, true, false);
    }

    public Path(String path, boolean isEnabled, boolean isEditable, boolean isReadOnly) {
        if (path.startsWith(GHIDRA_HOME)) {
            this.path = this.resolveGhidraHome(path);
        } else if (path.startsWith(USER_HOME)) {
            String userHome = System.getProperty("user.home");
            int length = USER_HOME.length();
            String relativePath = path.substring(length);
            this.path = new ResourceFile(new File(userHome + relativePath));
        } else {
            this.path = new ResourceFile(path);
        }
        if (OperatingSystem.CURRENT_OPERATING_SYSTEM == OperatingSystem.WINDOWS) {
            this.path = this.path.getCanonicalFile();
        }
        this.isEnabled = isEnabled;
        this.isEditable = isEditable;
        this.isReadOnly = isReadOnly;
    }

    private ResourceFile resolveGhidraHome(String scriptPath) {
        ResourceFile pathFile = null;
        for (ResourceFile root : Application.getApplicationRootDirectories()) {
            int length;
            String relativePath;
            pathFile = new ResourceFile(root, relativePath = scriptPath.substring(length = GHIDRA_HOME.length()));
            if (!pathFile.exists()) continue;
            return pathFile;
        }
        return pathFile;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Path)) {
            return false;
        }
        Path that = (Path)obj;
        return this.path.equals((Object)that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public ResourceFile getPath() {
        return this.path;
    }

    public String getPathAsString() {
        String userHome = System.getProperty("user.home");
        Object absolutePath = this.path.getAbsolutePath();
        for (ResourceFile appRoot : Application.getApplicationRootDirectories()) {
            String ghidraHome = appRoot.getAbsolutePath();
            if (!((String)absolutePath).startsWith(ghidraHome)) continue;
            int length = ghidraHome.length();
            String relativePath = ((String)absolutePath).substring(length);
            absolutePath = GHIDRA_HOME + relativePath;
            return ((String)absolutePath).replace('\\', '/');
        }
        if (((String)absolutePath).startsWith(userHome)) {
            int length = userHome.length();
            String relativePath = ((String)absolutePath).substring(length);
            absolutePath = USER_HOME + relativePath;
            return ((String)absolutePath).replace('\\', '/');
        }
        return ((String)absolutePath).replace('\\', '/');
    }

    public boolean isInstallationFile() {
        String pathAsString = this.getPathAsString();
        return pathAsString.contains(GHIDRA_HOME);
    }

    public void setPath(String path) {
        if (!this.isEditable) {
            throw new IllegalStateException("Path is not editable - " + path);
        }
        this.path = new ResourceFile(path);
    }

    public void setPath(ResourceFile path) {
        if (!this.isEditable) {
            throw new IllegalStateException("Path is not editable - " + path);
        }
        this.path = path;
    }

    public boolean exists() {
        return this.path.exists();
    }

    public String toString() {
        return this.getPathAsString();
    }

    @Override
    public int compareTo(Path p) {
        return this.getPathAsString().compareTo(p.getPathAsString());
    }
}

