/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.scoring.AbstractIterativeScorer;
import edu.uci.ics.jung.algorithms.scoring.VertexScorer;
import edu.uci.ics.jung.algorithms.scoring.util.UniformDegreeWeight;
import edu.uci.ics.jung.graph.Hypergraph;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VoltageScorer<V, E>
extends AbstractIterativeScorer<V, E, Double>
implements VertexScorer<V, Double> {
    protected Map<V, ? extends Number> source_voltages;
    protected Collection<V> sinks;

    public VoltageScorer(Hypergraph<V, E> g, Function<? super E, ? extends Number> edge_weights, Map<V, ? extends Number> source_voltages, Collection<V> sinks) {
        super(g, edge_weights);
        this.source_voltages = source_voltages;
        this.sinks = sinks;
        this.initialize();
    }

    public VoltageScorer(Hypergraph<V, E> g, Function<? super E, ? extends Number> edge_weights, Collection<V> sources, Collection<V> sinks) {
        super(g, edge_weights);
        HashMap<? extends Number, Number> unit_voltages = new HashMap<Number, Number>();
        for (V v : sources) {
            unit_voltages.put((Number)v, (Number)((Number)new Double(1.0)));
        }
        this.source_voltages = unit_voltages;
        this.sinks = sinks;
        this.initialize();
    }

    public VoltageScorer(Hypergraph<V, E> g, Collection<V> sources, Collection<V> sinks) {
        super(g);
        HashMap<? extends Number, Number> unit_voltages = new HashMap<Number, Number>();
        for (V v : sources) {
            unit_voltages.put((Number)v, (Number)((Number)new Double(1.0)));
        }
        this.source_voltages = unit_voltages;
        this.sinks = sinks;
        this.initialize();
    }

    public VoltageScorer(Hypergraph<V, E> g, Map<V, ? extends Number> source_voltages, Collection<V> sinks) {
        super(g);
        this.source_voltages = source_voltages;
        this.sinks = sinks;
        this.edge_weights = new UniformDegreeWeight<V, E>(g);
        this.initialize();
    }

    public VoltageScorer(Hypergraph<V, E> g, Function<? super E, ? extends Number> edge_weights, V source, V sink) {
        this((Hypergraph<List<V>, E>)g, (Function<E, Number>)edge_weights, (List<V>)((Object)Collections.singletonMap(source, 1.0)), Collections.singletonList(sink));
        this.initialize();
    }

    public VoltageScorer(Hypergraph<V, E> g, V source, V sink) {
        this((Hypergraph<List<V>, E>)g, (List<V>)((Object)Collections.singletonMap(source, 1.0)), Collections.singletonList(sink));
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.source_voltages.isEmpty() || this.sinks.isEmpty()) {
            throw new IllegalArgumentException("Both sources and sinks (grounds) must be defined");
        }
        if (this.source_voltages.size() + this.sinks.size() > this.graph.getVertexCount()) {
            throw new IllegalArgumentException("Source/sink sets overlap, or contain vertices not in graph");
        }
        for (Map.Entry<V, Number> entry : this.source_voltages.entrySet()) {
            V v = entry.getKey();
            if (this.sinks.contains(v)) {
                throw new IllegalArgumentException("Vertex " + v + " is incorrectly specified as both source and sink");
            }
            double value = entry.getValue().doubleValue();
            if (!(value <= 0.0)) continue;
            throw new IllegalArgumentException("Source vertex " + v + " has negative voltage");
        }
        for (Map.Entry<Object, Number> v : this.graph.getVertices()) {
            if (this.source_voltages.containsKey(v)) {
                this.setOutputValue(v, this.source_voltages.get(v).doubleValue());
                continue;
            }
            this.setOutputValue(v, 0.0);
        }
    }

    @Override
    public double update(V v) {
        Number source_volts = this.source_voltages.get(v);
        if (source_volts != null) {
            this.setOutputValue(v, source_volts.doubleValue());
            return 0.0;
        }
        if (this.sinks.contains(v)) {
            this.setOutputValue(v, 0.0);
            return 0.0;
        }
        Collection edges = this.graph.getInEdges(v);
        double voltage_sum = 0.0;
        double weight_sum = 0.0;
        for (Object e : edges) {
            int incident_count = this.getAdjustedIncidentCount(e);
            for (Object w : this.graph.getIncidentVertices(e)) {
                if (w.equals(v) && !this.hyperedges_are_self_loops) continue;
                double weight = this.getEdgeWeight(w, e).doubleValue() / (double)incident_count;
                voltage_sum += (Double)this.getCurrentValue(w) * weight;
                weight_sum += weight;
            }
        }
        if (voltage_sum == 0.0 || weight_sum == 0.0) {
            this.setOutputValue(v, 0.0);
            return (Double)this.getCurrentValue(v);
        }
        this.setOutputValue(v, voltage_sum / weight_sum);
        return Math.abs((Double)this.getCurrentValue(v) - voltage_sum / weight_sum);
    }
}

