/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.edge;

import ghidra.graph.GDirectedGraph;
import ghidra.graph.GraphAlgorithms;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphView;
import ghidra.graph.viewer.VisualVertex;
import ghidra.util.task.SwingRunnable;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class InitializeCircuitsRunnable<V extends VisualVertex, E extends VisualEdge<V>, G extends VisualGraph<V, E>>
implements SwingRunnable {
    private final VisualGraph<V, E> graph;
    private final Set<E> allCircuitResults;
    private final Map<V, Set<E>> circuitFlowResults;
    private VisualGraphView<V, E, G> view;

    public InitializeCircuitsRunnable(VisualGraphView<V, E, G> view, VisualGraph<V, E> graph) {
        this.view = Objects.requireNonNull(view);
        this.graph = graph;
        this.allCircuitResults = new HashSet();
        this.circuitFlowResults = new HashMap<V, Set<E>>();
    }

    public void monitoredRun(TaskMonitor monitor) {
        monitor.setMessage("Finding all loops");
        Set<Set<V>> strongs = GraphAlgorithms.getStronglyConnectedComponents(this.graph);
        for (Set<V> vertices : strongs) {
            if (vertices.size() == 1) continue;
            GDirectedGraph<V, E> subGraph = GraphAlgorithms.createSubGraph(this.graph, vertices);
            Collection<E> edges = subGraph.getEdges();
            this.allCircuitResults.addAll(edges);
            HashSet<E> asSet = new HashSet<E>(edges);
            Collection<V> subVertices = subGraph.getVertices();
            for (VisualVertex v : subVertices) {
                this.circuitFlowResults.put((HashSet<E>)((Object)v), asSet);
            }
        }
    }

    public void swingRun(boolean isCancelled) {
        if (isCancelled) {
            return;
        }
    }
}

