/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.markuptype;

import ghidra.feature.vt.api.impl.MarkupItemImpl;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.api.stringable.MultipleSymbolStringable;
import ghidra.feature.vt.api.util.LabelMarkupUtils;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.feature.vt.api.util.VersionTrackingApplyException;
import ghidra.feature.vt.gui.util.VTMatchApplyChoices;
import ghidra.feature.vt.gui.util.VTOptionDefines;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LabelMarkupType
extends VTMarkupType {
    public static final VTMarkupType INSTANCE = new LabelMarkupType();

    @Override
    public List<VTMarkupItem> createMarkupItems(VTAssociation association) {
        ArrayList<VTMarkupItem> list = new ArrayList<VTMarkupItem>();
        this.addLabelMarkup(list, association);
        return list;
    }

    private void addLabelMarkup(List<VTMarkupItem> list, VTAssociation association) {
        AddressSetView addressSet;
        VTSession session = association.getSession();
        Program sourceProgram = session.getSourceProgram();
        Listing sourceListing = sourceProgram.getListing();
        SymbolTable sourceSymbolTable = sourceProgram.getSymbolTable();
        Address sourceAddress = association.getSourceAddress();
        FunctionManager functionManager = sourceProgram.getFunctionManager();
        Function sourceFunction = functionManager.getFunctionAt(sourceAddress);
        if (sourceFunction == null) {
            CodeUnit codeUnit = sourceListing.getCodeUnitAt(sourceAddress);
            Address minAddress = codeUnit == null ? sourceAddress : codeUnit.getMinAddress();
            Address maxAddress = codeUnit == null ? sourceAddress : codeUnit.getMaxAddress();
            addressSet = new AddressSet(minAddress, maxAddress);
        } else {
            addressSet = sourceFunction.getBody();
        }
        SymbolIterator primarySymbolIterator = sourceSymbolTable.getPrimarySymbolIterator(addressSet, true);
        while (primarySymbolIterator.hasNext()) {
            Symbol symbol = primarySymbolIterator.next();
            this.addLabelMarkup(list, association, sourceProgram, symbol.getAddress());
        }
    }

    private Symbol[] getLabelMarkupSymbols(Program sourceProgram, Address sourceAddress) {
        SymbolTable sourceSymbolTable = sourceProgram.getSymbolTable();
        Symbol[] sourceSymbols = sourceSymbolTable.getSymbols(sourceAddress);
        sourceSymbols = this.removeFunctionSymbol(sourceSymbols, sourceProgram.getFunctionManager());
        return sourceSymbols;
    }

    private Symbol[] getNonDefaultLabelMarkupSymbols(Program sourceProgram, Address sourceAddress) {
        SymbolTable sourceSymbolTable = sourceProgram.getSymbolTable();
        Symbol sourceSymbol = sourceSymbolTable.getPrimarySymbol(sourceAddress);
        if (sourceSymbol == null || sourceSymbol.isDynamic()) {
            return new Symbol[0];
        }
        Symbol[] sourceSymbols = sourceSymbolTable.getSymbols(sourceAddress);
        sourceSymbols = this.removeFunctionSymbol(sourceSymbols, sourceProgram.getFunctionManager());
        return sourceSymbols;
    }

    private void addLabelMarkup(List<VTMarkupItem> list, VTAssociation association, Program sourceProgram, Address sourceAddress) {
        Symbol[] sourceSymbols = this.getNonDefaultLabelMarkupSymbols(sourceProgram, sourceAddress);
        if (sourceSymbols.length == 0) {
            return;
        }
        MarkupItemImpl markupItemImpl = new MarkupItemImpl(association, this, sourceAddress);
        list.add(markupItemImpl);
    }

    private Symbol[] removeFunctionSymbol(Symbol[] symbols, FunctionManager functionManager) {
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        for (Symbol symbol : symbols) {
            if (symbol.isPrimary() && functionManager.getFunctionAt(symbol.getAddress()) != null) continue;
            list.add(symbol);
        }
        return list.toArray(new Symbol[list.size()]);
    }

    private LabelMarkupType() {
        super("Label");
    }

    @Override
    public boolean supportsApplyAction(VTMarkupItemApplyActionType applyAction) {
        return applyAction == VTMarkupItemApplyActionType.ADD || applyAction == VTMarkupItemApplyActionType.ADD_AS_PRIMARY || applyAction == VTMarkupItemApplyActionType.REPLACE_DEFAULT_ONLY || applyAction == VTMarkupItemApplyActionType.REPLACE;
    }

    @Override
    public boolean supportsAssociationType(VTAssociationType matchType) {
        return true;
    }

    @Override
    public VTMarkupItemApplyActionType getApplyAction(ToolOptions options) {
        VTMatchApplyChoices.LabelChoices labelChoice = (VTMatchApplyChoices.LabelChoices)options.getEnum("Apply Markup Options.Labels", (Enum)VTMatchApplyChoices.LabelChoices.ADD);
        switch (labelChoice) {
            case ADD: {
                return VTMarkupItemApplyActionType.ADD;
            }
            case ADD_AS_PRIMARY: {
                return VTMarkupItemApplyActionType.ADD;
            }
            case REPLACE_DEFAULT_ONLY: {
                return VTMarkupItemApplyActionType.REPLACE;
            }
            case REPLACE_ALL: {
                return VTMarkupItemApplyActionType.REPLACE;
            }
        }
        return null;
    }

    @Override
    public Options convertOptionsToForceApplyOfMarkupItem(VTMarkupItemApplyActionType applyAction, ToolOptions applyOptions) {
        ToolOptions options = applyOptions.copy();
        switch (applyAction) {
            case ADD: {
                applyOptions.setEnum("Apply Markup Options.Labels", (Enum)VTMatchApplyChoices.LabelChoices.ADD);
            }
            case ADD_AS_PRIMARY: {
                applyOptions.setEnum("Apply Markup Options.Labels", (Enum)VTMatchApplyChoices.LabelChoices.ADD_AS_PRIMARY);
            }
            case REPLACE_DEFAULT_ONLY: {
                applyOptions.setEnum("Apply Markup Options.Labels", (Enum)VTMatchApplyChoices.LabelChoices.REPLACE_DEFAULT_ONLY);
                break;
            }
            case REPLACE: {
                applyOptions.setEnum("Apply Markup Options.Labels", (Enum)VTMatchApplyChoices.LabelChoices.REPLACE_ALL);
            }
        }
        return options;
    }

    private Symbol[] getSourceSymbols(VTAssociation association, Address sourceAddress) {
        Program program = this.getSourceProgram(association);
        return this.getNonDefaultLabelMarkupSymbols(program, sourceAddress);
    }

    @Override
    public Stringable getSourceValue(VTAssociation association, Address sourceAddress) {
        return new MultipleSymbolStringable(this.getSourceSymbols(association, sourceAddress));
    }

    @Override
    public boolean applyMarkup(VTMarkupItem markupItem, ToolOptions markupOptions) throws VersionTrackingApplyException {
        boolean replaceDefault;
        VTMatchApplyChoices.LabelChoices labelChoice = (VTMatchApplyChoices.LabelChoices)markupOptions.getEnum("Apply Markup Options.Labels", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_LABELS);
        if (labelChoice == VTMatchApplyChoices.LabelChoices.EXCLUDE) {
            throw new IllegalArgumentException("Can't apply " + markupItem.getMarkupType().getDisplayName() + " since it is excluded.");
        }
        Address destinationAddress = markupItem.getDestinationAddress();
        if (destinationAddress == null) {
            throw new VersionTrackingApplyException("The destination address cannot be null!");
        }
        if (destinationAddress == Address.NO_ADDRESS) {
            throw new VersionTrackingApplyException("The destination address cannot be No Address!");
        }
        VTAssociation association = markupItem.getAssociation();
        MultipleSymbolStringable sourceStringable = (MultipleSymbolStringable)this.getSourceValue(association, markupItem.getSourceAddress());
        MultipleSymbolStringable destinationStringable = (MultipleSymbolStringable)this.getCurrentDestinationValue(markupItem.getAssociation(), destinationAddress);
        boolean replaceAll = labelChoice == VTMatchApplyChoices.LabelChoices.REPLACE_ALL;
        boolean bl = replaceDefault = labelChoice == VTMatchApplyChoices.LabelChoices.REPLACE_DEFAULT_ONLY && (destinationStringable == null || destinationStringable.isEmpty() || destinationStringable.containsDynamic());
        if (replaceAll) {
            LabelMarkupUtils.removeAllLabels(this.getDestinationProgram(association), destinationAddress);
        } else if (replaceDefault) {
            LabelMarkupUtils.removeDefaultLabels(this.getDestinationProgram(association), destinationAddress);
        }
        Program destinationProgram = this.getDestinationProgram(association);
        try {
            boolean setAsPrimary = labelChoice == VTMatchApplyChoices.LabelChoices.ADD_AS_PRIMARY;
            sourceStringable.setSymbols(destinationProgram, destinationAddress, setAsPrimary);
        }
        catch (DuplicateNameException e) {
            throw new VersionTrackingApplyException("Unable to apply symbol(s) at address " + destinationAddress + " due to a duplicate name: " + sourceStringable.getDisplayString(), e);
        }
        catch (InvalidInputException e) {
            throw new VersionTrackingApplyException("Unable to apply symbol(s) at address " + destinationAddress + " due to invalid input", e);
        }
        return true;
    }

    @Override
    public void unapplyMarkup(VTMarkupItem markupItem) throws VersionTrackingApplyException {
        VTMarkupItemStatus status = markupItem.getStatus();
        if (status == VTMarkupItemStatus.DONT_CARE) {
            return;
        }
        Program destinationProgram = this.getDestinationProgram(markupItem.getAssociation());
        Address appliedAddress = markupItem.getDestinationAddress();
        LabelMarkupUtils.removeAllLabels(destinationProgram, appliedAddress);
        MultipleSymbolStringable destinationStringable = (MultipleSymbolStringable)markupItem.getOriginalDestinationValue();
        if (destinationStringable == null) {
            return;
        }
        try {
            destinationStringable.setSymbols(destinationProgram, appliedAddress, true);
        }
        catch (DuplicateNameException e) {
            throw new VersionTrackingApplyException("Unable to restore symbols at address: " + appliedAddress + " due to a duplicate name", e);
        }
        catch (InvalidInputException e) {
            throw new VersionTrackingApplyException("Unable to restore symbols at address: " + appliedAddress + " due to invalid input", e);
        }
        FunctionManager functionManager = destinationProgram.getFunctionManager();
        Function function = functionManager.getFunctionAt(appliedAddress);
        if (function != null) {
            MultipleSymbolStringable sourceStringable = (MultipleSymbolStringable)markupItem.getSourceValue();
            Symbol symbol = function.getSymbol();
            if (sourceStringable != null && sourceStringable.contains(symbol) && !destinationStringable.contains(symbol)) {
                destinationProgram.getSymbolTable().removeSymbolSpecial(symbol);
            }
        }
    }

    @Override
    public ProgramLocation getDestinationLocation(VTAssociation association, Address destinationAddress) {
        if (destinationAddress == null || destinationAddress == Address.NO_ADDRESS) {
            return null;
        }
        Program destinationProgram = this.getDestinationProgram(association);
        Symbol primarySymbol = destinationProgram.getSymbolTable().getPrimarySymbol(destinationAddress);
        if (primarySymbol == null) {
            return new ProgramLocation(destinationProgram, destinationAddress);
        }
        return new LabelFieldLocation(primarySymbol);
    }

    @Override
    public ProgramLocation getSourceLocation(VTAssociation association, Address sourceAddress) {
        if (sourceAddress == null) {
            return null;
        }
        Program sourceProgram = this.getSourceProgram(association);
        Symbol primarySymbol = sourceProgram.getSymbolTable().getPrimarySymbol(sourceAddress);
        if (primarySymbol == null) {
            return new ProgramLocation(sourceProgram, sourceAddress);
        }
        return new LabelFieldLocation(primarySymbol);
    }

    private Symbol[] getDestinationSymbols(VTAssociation association, Address destinationAddress) {
        Symbol[] symbols = new Symbol[]{};
        if (destinationAddress != null && destinationAddress != Address.NO_ADDRESS) {
            Program program = this.getDestinationProgram(association);
            symbols = this.getLabelMarkupSymbols(program, destinationAddress);
        }
        return symbols;
    }

    @Override
    public Stringable getCurrentDestinationValue(VTAssociation association, Address destinationAddress) {
        return new MultipleSymbolStringable(this.getDestinationSymbols(association, destinationAddress));
    }

    @Override
    public Stringable getOriginalDestinationValue(VTAssociation association, Address destinationAddress) {
        Stringable appliedMarkupOriginalValue = null;
        try {
            appliedMarkupOriginalValue = this.getOriginalDestinationValueForAppliedMarkupOfThisType(association, destinationAddress, TaskMonitorAdapter.DUMMY_MONITOR);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        if (appliedMarkupOriginalValue != null) {
            return appliedMarkupOriginalValue;
        }
        return this.getCurrentDestinationValue(association, destinationAddress);
    }

    @Override
    public boolean hasSameSourceAndDestinationValues(VTMarkupItem markupItem) {
        VTAssociation association = markupItem.getAssociation();
        Address sourceAddress = markupItem.getSourceAddress();
        Address destinationAddress = markupItem.getDestinationAddress();
        if (destinationAddress == null || destinationAddress == Address.NO_ADDRESS) {
            return false;
        }
        Symbol[] sourceSymbols = this.getSourceSymbols(association, sourceAddress);
        Symbol[] destinationSymbols = this.getDestinationSymbols(association, destinationAddress);
        Object[] sourceNames = this.getSymbolNames(sourceSymbols);
        Object[] destinationNames = this.getSymbolNames(destinationSymbols);
        Arrays.sort(sourceNames);
        Arrays.sort(destinationNames);
        return SystemUtilities.isArrayEqual((Object[])sourceNames, (Object[])destinationNames);
    }

    private String[] getSymbolNames(Symbol[] symbols) {
        int length = symbols.length;
        String[] names = new String[length];
        for (int index = 0; index < length; ++index) {
            names[index] = symbols[index].getName();
        }
        return names;
    }
}

