/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.runtime.ResolvedFeatureId;

public class FeatureGroupsBuilder {
    private final Map<String, Group> allgroups = new HashMap<String, Group>();
    private final Group root = Group.fromString("", "###ROOT");
    private String currentPath;

    FeatureGroupsBuilder() {
        this.allgroups.put(this.root.getIdentity().getName(), this.root);
    }

    Group getRoot() {
        return this.root;
    }

    private Group addGroup(String value, Group current, List<String> pathItems, String grpName) {
        if (value != null) {
            current = this.addGroup(current, pathItems, grpName);
            current = this.addGroup(current, pathItems, value);
        }
        return current;
    }

    private Group addGroup(Group current, List<String> pathItems, String grpName) {
        Group fg = this.allgroups.get(this.currentPath + grpName);
        if (fg == null) {
            fg = Group.fromString("", grpName);
            this.allgroups.put(this.currentPath + grpName, fg);
        }
        current.addGroup(fg);
        this.currentPath = this.currentPath + fg.getIdentity().getName() + "/";
        pathItems.add(fg.getIdentity().getName());
        return fg;
    }

    Group buildFeatureGroups(String name, ResolvedFeatureId id, List<String> pathItems) {
        String[] groups = name.split("\\.");
        Group current = this.allgroups.get("###ROOT");
        this.currentPath = "/";
        for (int it = 0; it < groups.length; ++it) {
            String value;
            String g = groups[it];
            String string = value = id == null ? null : (String)id.getParams().get(g);
            if (value != null) {
                String next;
                current = this.addGroup(value, current, pathItems, g);
                if (it >= groups.length - 1 || !(next = groups[it + 1]).equals(value)) continue;
                ++it;
                continue;
            }
            current = this.addGroup(current, pathItems, g);
        }
        return current;
    }

    Group buildFeatureSpecGroups(String name, FeatureSpecInfo info, List<String> pathItems) {
        String[] groups = name.split("\\.");
        Group current = this.allgroups.get("###ROOT");
        this.currentPath = "/";
        for (int it = 0; it < groups.length; ++it) {
            String g = groups[it];
            current = this.addGroup(current, pathItems, g);
        }
        return current;
    }
}

