/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerClob;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

final class SQLServerClobWriter
extends Writer {
    private SQLServerClob parentClob = null;
    private long streamPos;

    SQLServerClobWriter(SQLServerClob sQLServerClob, long l) {
        this.parentClob = sQLServerClob;
        this.streamPos = l;
    }

    public void write(char[] cArray) throws IOException {
        if (null == cArray) {
            return;
        }
        this.write(new String(cArray));
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (null == cArray) {
            return;
        }
        this.write(new String(cArray, n, n2));
    }

    public void write(int n) throws IOException {
        char[] cArray = new char[]{(char)n};
        this.write(new String(cArray));
    }

    public void write(String string, int n, int n2) throws IOException {
        this.checkClosed();
        try {
            int n3 = this.parentClob.setString(this.streamPos, string, n, n2);
            this.streamPos += (long)n3;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public void write(String string) throws IOException {
        if (null == string) {
            return;
        }
        this.write(string, 0, string.length());
    }

    public void flush() throws IOException {
        this.checkClosed();
    }

    public void close() throws IOException {
        this.checkClosed();
        this.parentClob = null;
    }

    private void checkClosed() throws IOException {
        if (null == this.parentClob) {
            throw new IOException(SQLServerException.getErrString("R_streamIsClosed"));
        }
    }
}

