/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.querypen.event;

import ca.sqlpower.query.SQLJoin;
import ca.sqlpower.swingui.CursorManager;
import ca.sqlpower.swingui.querypen.ConstantPNode;
import ca.sqlpower.swingui.querypen.MouseState;
import ca.sqlpower.swingui.querypen.QueryPen;
import ca.sqlpower.swingui.querypen.UnmodifiableItemPNode;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class CreateJoinEventHandler
extends PBasicInputEventHandler {
    private QueryPen queryPen;
    private UnmodifiableItemPNode leftText;
    private UnmodifiableItemPNode rightText;
    private PCanvas canvas;
    private CursorManager cursorManager;
    private double mouseFirstClickX;
    private double mouseSecondClickX;
    private PropertyChangeListener changeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            for (PropertyChangeListener l : CreateJoinEventHandler.this.createJoinListeners) {
                l.propertyChange(evt);
            }
        }
    };
    private List<PropertyChangeListener> createJoinListeners = new ArrayList<PropertyChangeListener>();

    public CreateJoinEventHandler(QueryPen mouseStatePane, PCanvas canvas, CursorManager cursorManager) {
        this.queryPen = mouseStatePane;
        this.canvas = canvas;
        this.cursorManager = cursorManager;
        this.mouseFirstClickX = 0.0;
        this.mouseSecondClickX = 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mousePressed(PInputEvent event) {
        PNode pick;
        super.mousePressed(event);
        if (!this.queryPen.getMouseState().equals((Object)MouseState.MouseStates.CREATE_JOIN)) return;
        for (pick = event.getPickedNode(); pick != null && !(pick instanceof UnmodifiableItemPNode); pick = pick.getParent()) {
            if (!(pick instanceof ConstantPNode)) continue;
            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor((Component)this.canvas), "Joining on constants is not allowed.");
        }
        if (pick != null) {
            if (this.leftText == null) {
                this.mouseFirstClickX = event.getPosition().getX();
                this.leftText = (UnmodifiableItemPNode)pick;
                this.leftText.setJoiningState(true);
                return;
            } else {
                if (this.rightText != null) throw new IllegalStateException("Trying to create a join while both ends have already been specified.");
                this.leftText.setJoiningState(false);
                this.mouseSecondClickX = event.getPosition().getX();
                this.rightText = (UnmodifiableItemPNode)pick;
                if (this.leftText.getParent() == this.rightText.getParent()) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor((Component)this.canvas), "You cannot join to your own Table.");
                    this.resetJoin();
                    return;
                }
                if (this.mouseFirstClickX != 0.0 && this.mouseSecondClickX != 0.0 && this.mouseFirstClickX > this.mouseSecondClickX) {
                    UnmodifiableItemPNode tempNode = this.leftText;
                    this.leftText = this.rightText;
                    this.rightText = tempNode;
                    this.mouseSecondClickX = 0.0;
                    this.mouseFirstClickX = 0.0;
                }
                SQLJoin join = new SQLJoin(this.leftText.getItem(), this.rightText.getItem());
                join.addJoinChangeListener(this.changeListener);
                this.queryPen.getModel().addJoin(join);
                this.resetJoin();
            }
            return;
        } else {
            if (this.leftText != null) {
                this.leftText.setJoiningState(false);
            }
            this.resetJoin();
        }
    }

    private void resetJoin() {
        this.leftText = null;
        this.rightText = null;
        this.cursorManager.placeModeFinished();
        this.queryPen.setMouseState(MouseState.MouseStates.READY);
    }

    public void addCreateJoinListener(PropertyChangeListener l) {
        this.createJoinListeners.add(l);
    }

    public void removeCreateJoinListener(PropertyChangeListener l) {
        this.createJoinListeners.remove(l);
    }
}

