/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.filemonitoring;

import com.almworks.tracklink.codelinks.cache.ArtifactInfoCache;
import com.almworks.tracklink.codelinks.highlight.CodeParser;
import com.almworks.tracklink.codelinks.highlight.PsiLinkHighlighter;
import com.almworks.tracklink.filemonitoring.FileChangeListener;
import com.almworks.tracklink.filemonitoring.FileEditorWatcher;
import com.almworks.util.Log;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.WeakHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileEditorWatcherImpl
implements FileEditorManagerListener,
FileEditorWatcher {
    private static final long MIN_CHECK_PAUSE = 1000L;
    private final Map<VirtualFile, PsiLinkHighlighter> myHighlighters;
    private final CodeParser myParser;
    private final ArtifactInfoCache myCache;
    private final List<FileChangeListener> myListeners;
    @Nullable
    private Project myProject;
    private long myLastCheckTime;

    public FileEditorWatcherImpl(Project project, @NotNull CodeParser parser, @NotNull ArtifactInfoCache cache) {
        if (parser == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/almworks/tracklink/filemonitoring/FileEditorWatcherImpl.<init> must not be null");
        }
        if (cache == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/almworks/tracklink/filemonitoring/FileEditorWatcherImpl.<init> must not be null");
        }
        this.myHighlighters = new WeakHashMap();
        this.myListeners = new CopyOnWriteArrayList<FileChangeListener>();
        this.myLastCheckTime = 0L;
        this.myProject = project;
        this.myParser = parser;
        this.myCache = cache;
    }

    public void fileOpened(FileEditorManager source, VirtualFile file) {
        Log.debug(System.currentTimeMillis() + " fileOpened(" + file.getPresentableName() + ", " + source.getSelectedTextEditor() + ")");
    }

    public void fileClosed(FileEditorManager source, VirtualFile file) {
        this.unwatch(file);
        Log.debug(System.currentTimeMillis() + " fileClosed(" + file.getPresentableName() + ", " + source.getSelectedTextEditor() + ")");
    }

    public void selectionChanged(FileEditorManagerEvent event) {
        Editor editor;
        PsiFile newPsiFile;
        FileEditorManager manager = event.getManager();
        Project project = manager.getProject();
        if (project != this.myProject) {
            assert (false) : this;
            return;
        }
        VirtualFile oldFile = event.getOldFile();
        VirtualFile newFile = event.getNewFile();
        if (newFile == null) {
            if (oldFile != null) {
                this.unwatch(oldFile);
            }
        } else if (!this.myHighlighters.containsKey(newFile) && (newPsiFile = PsiManager.getInstance((Project)project).findFile(newFile)) != null && (editor = manager.getSelectedTextEditor()) != null) {
            this.watch(newFile, newPsiFile, editor);
        }
        this.checkFiles(manager, newFile);
    }

    private void checkFiles(FileEditorManager manager, VirtualFile ignoreFile) {
        VirtualFile[] files;
        long now = System.currentTimeMillis();
        if (now < this.myLastCheckTime + 1000L) {
            return;
        }
        this.myLastCheckTime = now;
        for (VirtualFile file : files = this.myHighlighters.keySet().toArray(new VirtualFile[this.myHighlighters.size()])) {
            if (ignoreFile != null && ignoreFile.equals(file) || manager.isFileOpen(file)) continue;
            this.unwatch(file);
        }
    }

    private void watch(final VirtualFile file, PsiFile psiFile, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/almworks/tracklink/filemonitoring/FileEditorWatcherImpl.watch must not be null");
        }
        PsiLinkHighlighter highlighter = new PsiLinkHighlighter(editor, psiFile, this.myParser, this.myCache);
        highlighter.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                for (FileChangeListener fileChangeListener : FileEditorWatcherImpl.this.myListeners) {
                    fileChangeListener.fileChanged(file);
                }
            }
        });
        highlighter.startListen();
        this.myHighlighters.put(file, highlighter);
    }

    private void unwatch(VirtualFile file) {
        PsiLinkHighlighter highlighter = this.myHighlighters.remove(file);
        if (highlighter != null) {
            highlighter.stopListen();
        }
    }

    public void checkOpenEditors() {
        Collection<PsiLinkHighlighter> psiLinkHighlighters = this.myHighlighters.values();
        for (PsiLinkHighlighter highlighter : psiLinkHighlighters) {
            highlighter.reparseAll();
            highlighter.checkComments();
        }
    }

    public void projectClosed() {
        VirtualFile[] files;
        Project project = this.myProject;
        if (project == null) {
            return;
        }
        Set<VirtualFile> keys = this.myHighlighters.keySet();
        for (VirtualFile file : files = keys.toArray(new VirtualFile[keys.size()])) {
            this.unwatch(file);
        }
        this.myProject = null;
    }

    public void addListener(@NotNull FileChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/filemonitoring/FileEditorWatcherImpl.addListener must not be null");
        }
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull FileChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/filemonitoring/FileEditorWatcherImpl.removeListener must not be null");
        }
        this.myListeners.remove(listener);
    }
}

