/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.settings.BaseKeyStoreCommand;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.env.Environment;

class RemoveSettingKeyStoreCommand
extends BaseKeyStoreCommand {
    private final OptionSpec<String> arguments;

    RemoveSettingKeyStoreCommand() {
        super("Remove settings from the keystore", true);
        this.arguments = this.parser.nonOptions("setting names");
    }

    protected void executeCommand(Terminal terminal, OptionSet options, Environment env) throws Exception {
        List settings = this.arguments.values(options);
        if (settings.isEmpty()) {
            throw new UserException(64, "Must supply at least one setting to remove");
        }
        KeyStoreWrapper keyStore = this.getKeyStore();
        for (String setting : this.arguments.values(options)) {
            if (!keyStore.getSettingNames().contains(setting)) {
                throw new UserException(78, "Setting [" + setting + "] does not exist in the keystore.");
            }
            keyStore.remove(setting);
        }
        keyStore.save(env.configFile(), this.getKeyStorePassword().getChars());
    }
}

