/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.DefaultMustacheVisitor;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.MustacheVisitor;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.PartialCode;
import com.github.mustachejava.util.GuardException;
import com.github.mustachejava.util.InternalArrayList;
import com.github.mustachejava.util.Wrapper;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;

public class DeferringMustacheFactory
extends DefaultMustacheFactory {
    public static final Object DEFERRED = new Object();

    public DeferringMustacheFactory() {
    }

    public DeferringMustacheFactory(String resourceRoot) {
        super(resourceRoot);
    }

    public DeferringMustacheFactory(File fileRoot) {
        super(fileRoot);
    }

    @Override
    public MustacheVisitor createMustacheVisitor() {
        final AtomicLong id = new AtomicLong(0L);
        return new DefaultMustacheVisitor(this){

            @Override
            public void partial(TemplateContext tc, String variable) {
                TemplateContext partialTC = new TemplateContext("{{", "}}", tc.file(), tc.line(), tc.startOfLine());
                final Long divid = id.incrementAndGet();
                this.list.add(new PartialCode(partialTC, this.df, variable){
                    Wrapper deferredWrapper;

                    @Override
                    public Writer execute(Writer writer, List<Object> scopes) {
                        Object object = this.get(scopes);
                        DeferredCallable deferredCallable = this.getDeferred(scopes);
                        if (object == DEFERRED && deferredCallable != null) {
                            try {
                                DeferringMustacheFactory.this.writeTarget(writer, divid);
                                writer.append(this.appended);
                            }
                            catch (IOException e) {
                                throw new MustacheException("Failed to write", e, this.tc);
                            }
                            InternalArrayList<Object> scopesCopy = new InternalArrayList<Object>(scopes);
                            deferredCallable.add(new Deferral(divid, DeferringMustacheFactory.this.getExecutorService().submit(() -> {
                                try {
                                    StringWriter sw = new StringWriter();
                                    this.partial.execute((Writer)sw, scopesCopy).close();
                                    return sw.toString();
                                }
                                catch (IOException e) {
                                    throw new MustacheException("Failed to writer", e, this.tc);
                                }
                            })));
                            return writer;
                        }
                        return this.appendText(this.partial.execute(writer, scopes));
                    }

                    private DeferredCallable getDeferred(List<Object> scopes) {
                        try {
                            if (this.deferredWrapper == null) {
                                this.deferredWrapper = DeferringMustacheFactory.this.getObjectHandler().find("deferred", scopes);
                            }
                            return (DeferredCallable)this.deferredWrapper.call(scopes);
                        }
                        catch (GuardException e) {
                            this.deferredWrapper = null;
                            return this.getDeferred(scopes);
                        }
                    }
                });
            }
        };
    }

    protected void writeTarget(Writer writer, Long divid) throws IOException {
        writer.append("<div id=\"");
        writer.append(divid.toString());
        writer.append("\"></div>");
    }

    protected static void writeDeferral(StringBuilder sb, Deferral deferral, Object o) {
        sb.append("<script>document.getElementById(\"");
        sb.append(deferral.id);
        sb.append("\").innerHTML=\"");
        sb.append(o.toString().replace("<", "&lt;").replace("\"", "\\\"").replace("\n", "\\n"));
        sb.append("\";</script>");
    }

    public static class DeferredCallable
    implements Callable<String> {
        private List<Deferral> deferrals = new ArrayList<Deferral>();

        public void add(Deferral deferral) {
            this.deferrals.add(deferral);
        }

        @Override
        public String call() throws Exception {
            StringBuilder sb = new StringBuilder();
            for (Deferral deferral : this.deferrals) {
                Object o = deferral.future.get();
                if (o == null) continue;
                DeferringMustacheFactory.writeDeferral(sb, deferral, o);
            }
            return sb.toString();
        }
    }

    private static class Deferral {
        final long id;
        final Future<Object> future;

        Deferral(long id, Future<Object> future) {
            this.id = id;
            this.future = future;
        }
    }
}

