/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.crypto.AEADOperatorFactory;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.OutputAEADDecryptor;
import org.bouncycastle.crypto.OutputAEADEncryptor;
import org.bouncycastle.crypto.OutputCipher;
import org.bouncycastle.crypto.OutputDecryptor;
import org.bouncycastle.crypto.OutputEncryptor;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricOperatorFactory;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsAEADOperatorFactory;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsSymmetricOperatorFactory;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.jcajce.PBKDF1Key;
import org.bouncycastle.jcajce.PBKDF2Key;
import org.bouncycastle.jcajce.PBKDFKey;
import org.bouncycastle.jcajce.PKCS12Key;
import org.bouncycastle.jcajce.provider.BaseWrapCipher;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.ClassUtil;
import org.bouncycastle.jcajce.provider.PBEScheme;
import org.bouncycastle.jcajce.provider.PBKDFPBEKey;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import org.bouncycastle.jcajce.provider.ProvPBEPBKDF1;
import org.bouncycastle.jcajce.provider.ProvPBEPBKDF2;
import org.bouncycastle.jcajce.provider.ProvPKCS12;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaseCipher
extends CipherSpi {
    private final BouncyCastleFipsProvider fipsProvider;
    private final FipsSymmetricOperatorFactory fipsFactory;
    private final SymmetricOperatorFactory generalFactory;
    private final FipsAEADOperatorFactory fipsAeadFactory;
    private final AEADOperatorFactory generalAeadFactory;
    private final int blockSizeInBits;
    private final int keySizeInBits;
    private final DigestAlgorithm prf;
    private final Class[] fipsAvailableSpecs;
    private final Class[] generalAvailableSpecs;
    private final ParametersCreatorProvider<FipsParameters> fipsParametersProvider;
    private final ParametersCreatorProvider<Parameters> generalParametersProvider;
    private final Algorithm[] algorithms;
    private final Map<Algorithm, Parameters> baseParametersMap;
    private final PBEScheme scheme;
    private Set<Algorithm> activeAlgorithmSet = new HashSet<Algorithm>();
    private PBEParameterSpec pbeSpec = null;
    private String pbeAlgorithm = null;
    private AlgorithmParameters engineParams = null;
    private String modeName = null;
    private OutputCipher<Parameters> cipher;
    private OutputEncryptor<Parameters> encryptor;
    private OutputDecryptor<Parameters> decryptor;
    private UpdateOutputStream aadStream;
    private UpdateOutputStream processingStream;
    private ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
    private byte[] associatedData = null;

    private BaseCipher(BouncyCastleFipsProvider bouncyCastleFipsProvider, int n, int n2, DigestAlgorithm digestAlgorithm, PBEScheme pBEScheme, FipsSymmetricOperatorFactory fipsSymmetricOperatorFactory, SymmetricOperatorFactory symmetricOperatorFactory, FipsAEADOperatorFactory fipsAEADOperatorFactory, AEADOperatorFactory aEADOperatorFactory, Class[] classArray, ParametersCreatorProvider parametersCreatorProvider, ParametersCreatorProvider parametersCreatorProvider2, Map<Algorithm, Parameters> map, Algorithm ... algorithmArray) {
        this.fipsProvider = bouncyCastleFipsProvider;
        this.keySizeInBits = n2;
        this.prf = digestAlgorithm;
        this.scheme = pBEScheme;
        this.fipsFactory = fipsSymmetricOperatorFactory;
        this.generalFactory = symmetricOperatorFactory;
        this.fipsAeadFactory = fipsAEADOperatorFactory;
        this.generalAeadFactory = aEADOperatorFactory;
        this.blockSizeInBits = n;
        this.fipsAvailableSpecs = classArray;
        this.generalAvailableSpecs = classArray;
        this.fipsParametersProvider = parametersCreatorProvider;
        this.generalParametersProvider = parametersCreatorProvider2;
        this.baseParametersMap = map;
        this.algorithms = algorithmArray;
        this.activeAlgorithmSet.addAll(Arrays.asList(algorithmArray));
    }

    @Override
    protected int engineGetBlockSize() {
        return (this.blockSizeInBits + 7) / 8;
    }

    @Override
    protected byte[] engineGetIV() {
        Parameters parameters = this.cipher.getParameters();
        if (parameters instanceof ParametersWithIV) {
            return ((ParametersWithIV)parameters).getIV();
        }
        return null;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length * 8;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return this.cipher.getMaxOutputSize(n);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.cipher != null) {
            ParametersWithIV parametersWithIV;
            Parameters parameters = this.cipher.getParameters();
            String string = Utils.getBaseName(parameters.getAlgorithm());
            if (parameters instanceof AuthenticationParametersWithIV) {
                try {
                    AuthenticationParametersWithIV authenticationParametersWithIV = (AuthenticationParametersWithIV)parameters;
                    this.engineParams = AlgorithmParameters.getInstance(string, this.fipsProvider);
                    this.engineParams.init(new GCMParameters(authenticationParametersWithIV.getIV(), authenticationParametersWithIV.getMACSizeInBits() / 8).getEncoded());
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception.toString(), exception);
                }
            }
            if (parameters instanceof ParametersWithIV && (parametersWithIV = (ParametersWithIV)parameters).getIV() != null) {
                try {
                    this.engineParams = AlgorithmParameters.getInstance(string, this.fipsProvider);
                    this.engineParams.init(new DEROctetString(parametersWithIV.getIV()).getEncoded());
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception.toString(), exception);
                }
            }
            if (this.pbeSpec != null) {
                try {
                    this.engineParams = AlgorithmParameters.getInstance(this.pbeAlgorithm, this.fipsProvider);
                    this.engineParams.init(this.pbeSpec);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        return this.engineParams;
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        String string2;
        String string3;
        this.modeName = Strings.toUpperCase(string);
        if (this.modeName.equals("CTS")) {
            this.modeName = "CBC/CS3";
        }
        if (this.modeName.equals("SIC")) {
            string3 = "/CTR";
            string2 = "/CTR/";
        } else if (this.modeName.equals("CFB") || this.modeName.equals("OFB")) {
            string3 = "/" + this.modeName + Integer.toString(this.blockSizeInBits);
            string2 = "/" + this.modeName + Integer.toString(this.blockSizeInBits) + "/";
        } else {
            string3 = "/" + this.modeName;
            string2 = "/" + this.modeName + "/";
        }
        HashSet<Algorithm> hashSet = new HashSet<Algorithm>(this.activeAlgorithmSet);
        this.activeAlgorithmSet.clear();
        for (Algorithm algorithm : hashSet) {
            if (!algorithm.getName().endsWith(string3) && !algorithm.getName().contains(string2)) continue;
            this.activeAlgorithmSet.add(algorithm);
        }
        if (this.activeAlgorithmSet.isEmpty()) {
            throw new NoSuchAlgorithmException(this.modeName + " not found");
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        String string2 = Strings.toUpperCase(string);
        HashSet<Algorithm> hashSet = new HashSet<Algorithm>(this.activeAlgorithmSet);
        this.activeAlgorithmSet.clear();
        if (string2.equals("NOPADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (algorithm.getName().indexOf(47) != algorithm.getName().lastIndexOf(47)) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
            if (this.activeAlgorithmSet.isEmpty() && hashSet.size() == 1) {
                for (Algorithm algorithm : hashSet) {
                    if (!algorithm.getName().endsWith("CS3")) continue;
                    this.activeAlgorithmSet.add(algorithm);
                }
            }
        } else if (string2.equals("PKCS5PADDING") || string2.equals("PKCS7PADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (!algorithm.getName().endsWith("PKCS7")) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else if (string2.equals("ISO10126PADDING") || string2.equals("ISO10126-2PADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (!algorithm.getName().endsWith("ISO10126-2")) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else if (string2.equals("X9.23PADDING") || string2.equals("X923PADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (!algorithm.getName().endsWith("X9.23")) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else if (string2.equals("ISO7816-4PADDING") || string2.equals("ISO9797-1PADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (!algorithm.getName().endsWith("ISO7816-4")) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else if (string2.equals("TBCPADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (!algorithm.getName().endsWith("TBC")) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else if (string2.equals("CTSPADDING") || string2.equals("CS3PADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (!algorithm.getName().endsWith("CS3")) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else if (string2.equals("CS1PADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (!algorithm.getName().endsWith("CS1")) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else if (string2.equals("CS2PADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (!algorithm.getName().endsWith("CS2")) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else {
            throw new NoSuchPaddingException("Padding " + string + " unknown");
        }
        if (this.activeAlgorithmSet.isEmpty()) {
            throw new NoSuchPaddingException(string2 + " not found");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object t;
        Object object;
        boolean bl;
        AEADOperatorFactory aEADOperatorFactory;
        SymmetricOperatorFactory symmetricOperatorFactory;
        ParametersCreator parametersCreator;
        Algorithm algorithm;
        this.pbeAlgorithm = null;
        this.engineParams = null;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key for algorithm " + key.getAlgorithm() + " not suitable for symmetric enryption.");
        }
        if (secureRandom == null) {
            secureRandom = this.fipsProvider.getDefaultSecureRandom();
        }
        if ((algorithm = this.getAlgorithm()) instanceof FipsAlgorithm) {
            parametersCreator = this.fipsParametersProvider.get((FipsParameters)this.baseParametersMap.get(algorithm));
            symmetricOperatorFactory = this.fipsFactory;
            aEADOperatorFactory = this.fipsAeadFactory;
        } else {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("Cipher cannot be used in approved mode");
            }
            parametersCreator = this.generalParametersProvider.get(this.baseParametersMap.get(algorithm));
            symmetricOperatorFactory = this.generalFactory;
            aEADOperatorFactory = this.generalAeadFactory;
        }
        switch (n) {
            case 1: 
            case 3: {
                bl = true;
                break;
            }
            case 2: 
            case 4: {
                bl = false;
                break;
            }
            default: {
                throw new InvalidParameterException("unknown opmode " + n + " passed");
            }
        }
        if (key instanceof PBEKey && !(key instanceof PBKDFPBEKey) || this.scheme != null || algorithmParameterSpec instanceof PBEParameterSpec) {
            SecretKey secretKey;
            if (algorithmParameterSpec instanceof PBEParameterSpec) {
                object = (PBEParameterSpec)algorithmParameterSpec;
                this.pbeSpec = object;
            } else if (key instanceof PBEKey) {
                secretKey = (PBEKey)key;
                object = new PBEParameterSpec(secretKey.getSalt(), secretKey.getIterationCount());
                this.pbeSpec = object;
            } else {
                if (key instanceof PBEKey) throw new InvalidAlgorithmParameterException("No algorithm parameters provided when required");
                throw new InvalidKeyException("Algorithm requires a PBE key");
            }
            try {
                secretKey = (SecretKey)key;
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Algorithm requires a PBE key");
            }
            if (this.keySizeInBits == 0) {
                throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: cannot use PBE with variable key size");
            }
            if (key instanceof PBKDF2Key || this.scheme == PBEScheme.PBKDF2) {
                this.pbeAlgorithm = "PBKDF2";
                key = new SecretKeySpec(ProvPBEPBKDF2.getSecretKey(secretKey, (PBEParameterSpec)object, PasswordBasedDeriver.KeyType.CIPHER, this.keySizeInBits), algorithm.getName());
                try {
                    if (algorithm.requiresAlgorithmParameters()) {
                        if (algorithmParameterSpec == null) {
                            throw new InvalidKeyException("No algorithm parameters provided when required");
                        }
                        t = parametersCreator.createParameters(bl, algorithmParameterSpec, secureRandom);
                    }
                    t = parametersCreator.createParameters(bl, null, secureRandom);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + illegalArgumentException.getMessage(), illegalArgumentException);
                }
            } else if (key instanceof PBKDF1Key || this.scheme == PBEScheme.PBKDF1) {
                this.pbeAlgorithm = "PBKDF1";
                if (algorithm.requiresAlgorithmParameters()) {
                    byte[][] byArray = ProvPBEPBKDF1.getSecretKeyAndIV(secretKey, (PBEParameterSpec)object, this.prf, PasswordBasedDeriver.KeyType.CIPHER, this.keySizeInBits, this.blockSizeInBits);
                    key = new SecretKeySpec(byArray[0], algorithm.getName());
                    try {
                        t = parametersCreator.createParameters(bl, algorithmParameterSpec != null && !(algorithmParameterSpec instanceof PBEParameterSpec) ? algorithmParameterSpec : new IvParameterSpec(byArray[1]), secureRandom);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + illegalArgumentException.getMessage(), illegalArgumentException);
                    }
                } else {
                    key = new SecretKeySpec(ProvPBEPBKDF1.getSecretKey(secretKey, (PBEParameterSpec)object, this.prf, PasswordBasedDeriver.KeyType.CIPHER, this.keySizeInBits), algorithm.getName());
                    try {
                        t = parametersCreator.createParameters(bl, null, secureRandom);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + illegalArgumentException.getMessage(), illegalArgumentException);
                    }
                }
            } else {
                if (!(key instanceof PKCS12Key) && this.scheme != PBEScheme.PKCS12) throw new InvalidKeyException("Unable to use passed in key for PBE");
                this.pbeAlgorithm = "PBKDF-PKCS12";
                if (algorithm.requiresAlgorithmParameters()) {
                    byte[][] byArray = ProvPKCS12.getSecretKeyAndIV(secretKey, this.prf, (PBEParameterSpec)object, PasswordBasedDeriver.KeyType.CIPHER, this.keySizeInBits, this.blockSizeInBits);
                    key = new SecretKeySpec(byArray[0], algorithm.getName());
                    try {
                        t = parametersCreator.createParameters(bl, algorithmParameterSpec != null && !(algorithmParameterSpec instanceof PBEParameterSpec) ? algorithmParameterSpec : new IvParameterSpec(byArray[1]), secureRandom);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + illegalArgumentException.getMessage(), illegalArgumentException);
                    }
                } else {
                    key = new SecretKeySpec(ProvPKCS12.getSecretKey(secretKey, (PBEParameterSpec)object, PasswordBasedDeriver.KeyType.CIPHER, this.keySizeInBits), algorithm.getName());
                    try {
                        t = parametersCreator.createParameters(bl, null, secureRandom);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + illegalArgumentException.getMessage(), illegalArgumentException);
                    }
                }
            }
        } else {
            if (key instanceof PBKDFKey) {
                throw new InvalidKeyException("PBE key requires a PBEParameterSpec");
            }
            if (!bl && algorithm.requiresAlgorithmParameters() && algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("No algorithm parameters provided when required");
            }
            try {
                t = parametersCreator.createParameters(bl, algorithmParameterSpec, secureRandom);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
        try {
            object = Utils.convertKey(algorithm, key);
            if (this.keySizeInBits != 0 && Utils.keyNotLength((SymmetricKey)object, this.keySizeInBits)) {
                throw new InvalidKeyException("Cipher requires key of size " + this.keySizeInBits + " bits");
            }
            if (BaseCipher.isAEADMode(algorithm)) {
                if (bl) {
                    this.cipher = this.encryptor = (OutputEncryptor)Utils.addRandomIfNeeded(aEADOperatorFactory.createOutputAEADEncryptor((SymmetricKey)object, t), secureRandom);
                    this.processingStream = this.encryptor.getEncryptingStream(this.resultStream);
                    this.aadStream = ((OutputAEADEncryptor)this.encryptor).getAADStream();
                } else {
                    this.cipher = this.decryptor = (OutputDecryptor)Utils.addRandomIfNeeded(aEADOperatorFactory.createOutputAEADDecryptor((SymmetricKey)object, t), secureRandom);
                    this.processingStream = this.decryptor.getDecryptingStream(this.resultStream);
                    this.aadStream = ((OutputAEADDecryptor)this.decryptor).getAADStream();
                }
                if (!(algorithmParameterSpec instanceof AEADParameterSpec)) return;
                this.associatedData = ((AEADParameterSpec)algorithmParameterSpec).getAssociatedData();
                if (this.associatedData == null) return;
                this.aadStream.update(this.associatedData);
                return;
            } else if (bl) {
                this.encryptor = Utils.addRandomIfNeeded(symmetricOperatorFactory.createOutputEncryptor((SymmetricKey)object, t), secureRandom);
                this.cipher = this.encryptor;
                this.processingStream = this.encryptor.getEncryptingStream(this.resultStream);
                this.aadStream = null;
                return;
            } else {
                this.decryptor = Utils.addRandomIfNeeded(symmetricOperatorFactory.createOutputDecryptor((SymmetricKey)object, t), secureRandom);
                this.cipher = this.decryptor;
                this.processingStream = this.decryptor.getDecryptingStream(this.resultStream);
                this.aadStream = null;
            }
            return;
        }
        catch (InvalidParameterException invalidParameterException) {
            throw invalidParameterException;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (IllegalKeyException illegalKeyException) {
            throw new InvalidKeyException(illegalKeyException.getMessage(), illegalKeyException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidAlgorithmParameterException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (Exception exception) {
            throw new InvalidKeyException(exception.getMessage(), exception);
        }
    }

    private Algorithm getAlgorithm() {
        Algorithm algorithm = this.activeAlgorithmSet.size() == 1 ? this.activeAlgorithmSet.iterator().next() : this.algorithms[0];
        return algorithm;
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null) {
            Class[] classArray = this.getAlgorithm() instanceof FipsAlgorithm ? this.fipsAvailableSpecs : this.generalAvailableSpecs;
            for (int i = 0; i != classArray.length; ++i) {
                if (classArray[i] == null) continue;
                try {
                    algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(classArray[i]);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + algorithmParameters.toString());
            }
        }
        this.engineInit(n, key, algorithmParameterSpec, secureRandom);
        this.engineParams = algorithmParameters;
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
    }

    @Override
    protected void engineUpdateAAD(byte[] byArray, int n, int n2) {
        this.aadStream.update(byArray, n, n2);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.limit() - byteBuffer.position();
        this.aadStream.update(byteBuffer.array(), n, n2);
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.processingStream.update(byArray, n, n2);
        if (this.resultStream.size() > 0) {
            byte[] byArray2 = this.resultStream.toByteArray();
            this.resultStream.reset();
            return byArray2;
        }
        return null;
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (n3 + this.cipher.getUpdateOutputSize(n2) > byArray2.length) {
            throw new ShortBufferException("Output buffer too short for input.");
        }
        byte[] byArray3 = this.engineUpdate(byArray, n, n2);
        if (byArray3 != null) {
            System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
            return byArray3.length;
        }
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        try {
            if (byArray != null && n2 != 0) {
                this.processingStream.update(byArray, n, n2);
            }
            this.processingStream.close();
        }
        catch (IOException iOException) {
            if (this.cipher.getParameters() instanceof AuthenticationParametersWithIV) {
                ClassUtil.throwBadTagException(iOException.getMessage());
            }
            throw new BadPaddingException(iOException.getMessage());
        }
        byte[] byArray2 = this.resultStream.toByteArray();
        Utils.clearAndResetByteArrayOutputStream(this.resultStream);
        if (this.associatedData != null) {
            this.aadStream.update(this.associatedData);
        }
        return byArray2;
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        if (n3 + this.engineGetOutputSize(n2) > byArray2.length) {
            throw new ShortBufferException("Output buffer too short for input.");
        }
        byte[] byArray3 = this.engineDoFinal(byArray, n, n2);
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        Arrays.fill(byArray3, (byte)0);
        return byArray3.length;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Cannot wrap key, null encoding.");
        }
        try {
            return this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new IllegalBlockSizeException(badPaddingException.getMessage());
        }
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2;
        try {
            byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        return BaseWrapCipher.rebuildKey(string, n, byArray2, this.fipsProvider);
    }

    private static boolean isAEADMode(Algorithm algorithm) {
        String string = algorithm.getName();
        return string.contains("/CCM") || string.contains("/EAX") || string.contains("/GCM") || string.contains("/OCB");
    }

    static class Builder {
        private final BouncyCastleFipsProvider fipsProvider;
        private final int blockSize;
        private final Algorithm[] algorithms;
        private final Map<Algorithm, Parameters> baseParametersMap;
        private FipsSymmetricOperatorFactory fipsFactory;
        private SymmetricOperatorFactory generalFactory;
        private FipsAEADOperatorFactory fipsAeadFactory;
        private AEADOperatorFactory generalAeadFactory;
        private Class[] availableSpecs;
        private int keySizeInBits;
        private ParametersCreatorProvider fipsParametersProvider;
        private ParametersCreatorProvider generalParametersProvider;
        private DigestAlgorithm prf = FipsSHS.Algorithm.SHA1;
        private PBEScheme scheme;

        Builder(BouncyCastleFipsProvider bouncyCastleFipsProvider, int n, Parameters ... parametersArray) {
            this.fipsProvider = bouncyCastleFipsProvider;
            this.blockSize = n;
            this.baseParametersMap = new HashMap<Algorithm, Parameters>(parametersArray.length);
            this.algorithms = new Algorithm[parametersArray.length];
            for (int i = 0; i != parametersArray.length; ++i) {
                this.baseParametersMap.put(parametersArray[i].getAlgorithm(), parametersArray[i]);
                this.algorithms[i] = parametersArray[i].getAlgorithm();
            }
        }

        Builder withFixedKeySize(int n) {
            this.keySizeInBits = n;
            return this;
        }

        Builder withFipsOperators(ParametersCreatorProvider parametersCreatorProvider, FipsSymmetricOperatorFactory fipsSymmetricOperatorFactory) {
            this.fipsParametersProvider = parametersCreatorProvider;
            this.fipsFactory = fipsSymmetricOperatorFactory;
            return this;
        }

        Builder withFipsOperators(ParametersCreatorProvider parametersCreatorProvider, FipsSymmetricOperatorFactory fipsSymmetricOperatorFactory, FipsAEADOperatorFactory fipsAEADOperatorFactory) {
            this.fipsParametersProvider = parametersCreatorProvider;
            this.fipsFactory = fipsSymmetricOperatorFactory;
            this.fipsAeadFactory = fipsAEADOperatorFactory;
            return this;
        }

        Builder withGeneralOperators(ParametersCreatorProvider parametersCreatorProvider, SymmetricOperatorFactory symmetricOperatorFactory, AEADOperatorFactory aEADOperatorFactory) {
            this.generalParametersProvider = parametersCreatorProvider;
            this.generalFactory = symmetricOperatorFactory;
            this.generalAeadFactory = aEADOperatorFactory;
            return this;
        }

        Builder withScheme(PBEScheme pBEScheme) {
            this.scheme = pBEScheme;
            return this;
        }

        Builder withPrf(DigestAlgorithm digestAlgorithm) {
            this.prf = digestAlgorithm;
            return this;
        }

        Builder withParameters(Class[] classArray) {
            this.availableSpecs = classArray;
            return this;
        }

        BaseCipher build() {
            boolean bl = CryptoServicesRegistrar.isInApprovedOnlyMode();
            if (!bl) {
                return new BaseCipher(this.fipsProvider, this.blockSize, this.keySizeInBits, this.prf, this.scheme, this.fipsFactory, this.generalFactory, this.fipsAeadFactory, this.generalAeadFactory, this.availableSpecs, this.fipsParametersProvider, this.generalParametersProvider, (Map)this.baseParametersMap, this.algorithms);
            }
            Set<Algorithm> set = Utils.getActiveSet(this.algorithms);
            if (set.isEmpty()) {
                return null;
            }
            return new BaseCipher(this.fipsProvider, this.blockSize, this.keySizeInBits, this.prf, this.scheme, this.fipsFactory, this.generalFactory, this.fipsAeadFactory, this.generalAeadFactory, this.availableSpecs, this.fipsParametersProvider, this.generalParametersProvider, (Map)this.baseParametersMap, set.toArray(new Algorithm[set.size()]));
        }
    }
}

