/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.net.URI;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class XdmDestination
implements Destination {
    TreeModel treeModel = TreeModel.TINY_TREE;
    URI baseURI;
    Builder builder;

    public void setBaseURI(URI baseURI) {
        if (!baseURI.isAbsolute()) {
            throw new IllegalArgumentException("Supplied base URI must be absolute");
        }
        this.baseURI = baseURI;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public void setTreeModel(TreeModel model) {
        this.treeModel = model;
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public Receiver getReceiver(Configuration config) throws SaxonApiException {
        TreeModel model = this.treeModel;
        if (model == null) {
            model = TreeModel.getTreeModel(config.getTreeModel());
        }
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        this.builder = model.makeBuilder(pipe);
        if (this.baseURI != null) {
            this.builder.setBaseURI(this.baseURI.toString());
        }
        TreeProtector protector = new TreeProtector(this.builder);
        ComplexContentOutputter cco = new ComplexContentOutputter(pipe);
        NamespaceReducer reducer = new NamespaceReducer(protector);
        cco.setReceiver(reducer);
        return cco;
    }

    public void close() throws SaxonApiException {
    }

    public XdmNode getXdmNode() {
        if (this.builder == null) {
            throw new IllegalStateException("The document has not yet been built");
        }
        NodeInfo node = this.builder.getCurrentRoot();
        return node == null ? null : (XdmNode)XdmValue.wrap(node);
    }

    public void reset() {
        this.builder = null;
    }

    private static class TreeProtector
    extends ProxyReceiver {
        private int level = 0;
        private boolean ended = false;

        public TreeProtector(Receiver next) {
            super(next);
        }

        public void startDocument(int properties) throws XPathException {
            if (this.ended) {
                throw new XPathException("Only a single document can be written to an XdmDestination");
            }
            super.startDocument(properties);
            ++this.level;
        }

        public void endDocument() throws XPathException {
            super.endDocument();
            --this.level;
            if (this.level == 0) {
                this.ended = true;
            }
        }

        public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
            if (this.ended) {
                throw new XPathException("Only a single root node can be written to an XdmDestination");
            }
            super.startElement(nameCode, typeCode, location, properties);
            ++this.level;
        }

        public void endElement() throws XPathException {
            super.endElement();
            --this.level;
            if (this.level == 0) {
                this.ended = true;
            }
        }

        public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
            if (this.level == 0) {
                throw new XPathException("When writing to an XdmDestination, text nodes are only allowed within a document or element node");
            }
            super.characters(chars, locationId, properties);
        }

        public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
            if (this.level == 0) {
                throw new XPathException("When writing to an XdmDestination, processing instructions are only allowed within a document or element node");
            }
            super.processingInstruction(target, data, locationId, properties);
        }

        public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
            if (this.level == 0) {
                throw new XPathException("When writing to an XdmDestination, comment nodes are only allowed within a document or element node");
            }
            super.comment(chars, locationId, properties);
        }

        public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
            if (this.level == 0 && !(item instanceof NodeInfo)) {
                throw new XPathException("When writing to an XdmDestination, atomic values are only allowed within a document or element node");
            }
            super.append(item, locationId, copyNamespaces);
        }
    }
}

