/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.FeatureGroupXml;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class ConfigXml {
    private static final ConfigXml INSTANCE = new ConfigXml();
    public static final String NAMESPACE_1_0 = "urn:jboss:galleon:config:1.0";

    public static ConfigXml getInstance() {
        return INSTANCE;
    }

    public static void readConfig(XMLExtendedStreamReader reader, ConfigModel.Builder configBuilder) throws XMLStreamException {
        String name = null;
        String model = null;
        Boolean inheritFeatures = null;
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    configBuilder.setName(name);
                    continue block14;
                }
                case MODEL: {
                    model = reader.getAttributeValue(i);
                    configBuilder.setModel(model);
                    continue block14;
                }
                case INHERIT_FEATURES: {
                    inheritFeatures = Boolean.parseBoolean(reader.getAttributeValue(i));
                    configBuilder.setInheritFeatures(inheritFeatures);
                    continue block14;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            if (inheritFeatures != null) {
                throw new XMLStreamException(Attribute.INHERIT_FEATURES + " attribute can't be used w/o attribute " + Attribute.NAME);
            }
            if (model == null) {
                throw new XMLStreamException("Either one name or model or both attributes have to be present", reader.getLocation());
            }
        }
        block15: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element e = (Element)Element.elementsByLocal.get(reader.getName().getLocalPart());
                    if (e != null && e.firstChild) {
                        switch (e) {
                            case CONFIG_DEPS: {
                                ConfigXml.readConfigDeps(reader, configBuilder);
                                continue block15;
                            }
                            case PROPS: {
                                ConfigXml.readProps(reader, configBuilder);
                                continue block15;
                            }
                            case LAYERS: {
                                ConfigXml.readLayers(reader, configBuilder);
                                continue block15;
                            }
                        }
                        throw ParsingUtils.unexpectedContent(reader);
                    }
                    if (FeatureGroupXml.handleFeatureGroupBodyElement(reader, configBuilder)) continue block15;
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readProps(XMLExtendedStreamReader reader, ConfigModel.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case PROP: {
                            ConfigXml.readProp(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readProp(XMLExtendedStreamReader reader, ConfigModel.Builder builder) throws XMLStreamException {
        String name = null;
        String value = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (name == null) {
            if (value == null) {
                HashSet<Attribute> attrs = new HashSet<Attribute>();
                attrs.add(Attribute.NAME);
                attrs.add(Attribute.VALUE);
                throw ParsingUtils.missingAttributes(reader.getLocation(), attrs);
            }
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        if (value == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.VALUE));
        }
        builder.setProperty(name, value);
        ParsingUtils.parseNoContent(reader);
    }

    private static void readConfigDeps(XMLExtendedStreamReader reader, ConfigModel.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case CONFIG_DEP: {
                            ConfigXml.readConfigDep(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readConfigDep(XMLExtendedStreamReader reader, ConfigModel.Builder builder) throws XMLStreamException {
        String id = null;
        String name = null;
        String model = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case ID: {
                    id = reader.getAttributeValue(i);
                    continue block5;
                }
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block5;
                }
                case MODEL: {
                    model = reader.getAttributeValue(i);
                    continue block5;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (id == null || name == null && model == null) {
            if (id == null) {
                throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.ID));
            }
            throw ParsingUtils.missingOneOfAttributes(reader.getLocation(), Attribute.NAME, Attribute.MODEL);
        }
        builder.setConfigDep(id, new ConfigId(model, name));
        ParsingUtils.parseNoContent(reader);
    }

    private static void readLayers(XMLExtendedStreamReader reader, ConfigModel.Builder builder) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case INHERIT: {
                    builder.setInheritLayers(Boolean.parseBoolean(reader.getAttributeValue(i)));
                    continue block13;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        try {
            block14: while (reader.hasNext()) {
                switch (reader.nextTag()) {
                    case 2: {
                        return;
                    }
                    case 1: {
                        Element element = Element.of(reader.getName().getLocalPart());
                        switch (element) {
                            case INCLUDE: {
                                builder.includeLayer(ConfigXml.readLayer(reader, builder));
                                continue block14;
                            }
                            case EXCLUDE: {
                                builder.excludeLayer(ConfigXml.readLayer(reader, builder));
                                continue block14;
                            }
                        }
                        throw ParsingUtils.unexpectedContent(reader);
                    }
                }
                throw ParsingUtils.unexpectedContent(reader);
            }
        }
        catch (ProvisioningDescriptionException e) {
            throw new XMLStreamException("Failed to parse layers configuration: " + e.getMessage(), reader.getLocation());
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static String readLayer(XMLExtendedStreamReader reader, ConfigModel.Builder builder) throws XMLStreamException {
        String name = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        ParsingUtils.parseNoContent(reader);
        return name;
    }

    protected static enum Attribute implements XmlNameProvider
    {
        ID("id"),
        INHERIT("inherit"),
        INHERIT_FEATURES("inherit-features"),
        NAME("name"),
        MODEL("model"),
        VALUE("value"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return null;
        }

        static {
            attributes = new HashMap<QName, Attribute>(7);
            attributes.put(new QName(Attribute.ID.name), ID);
            attributes.put(new QName(INHERIT.getLocalName()), INHERIT);
            attributes.put(new QName(INHERIT_FEATURES.getLocalName()), INHERIT_FEATURES);
            attributes.put(new QName(NAME.getLocalName()), NAME);
            attributes.put(new QName(MODEL.getLocalName()), MODEL);
            attributes.put(new QName(Attribute.VALUE.name), VALUE);
            attributes.put(null, UNKNOWN);
        }
    }

    public static enum Element implements XmlNameProvider
    {
        CONFIG("config", false),
        CONFIG_DEP("config-dep", false),
        CONFIG_DEPS("config-deps", true),
        EXCLUDE("exclude", false),
        INCLUDE("include", false),
        LAYERS("layers", true),
        PROP("prop", false),
        PROPS("props", true),
        UNKNOWN(null, false);

        private static final Map<String, Element> elementsByLocal;
        private final String name;
        private final String namespace = "urn:jboss:galleon:config:1.0";
        private final boolean firstChild;

        static Element of(String localName) {
            Element element = elementsByLocal.get(localName);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name, boolean firstChild) {
            this.name = name;
            this.firstChild = firstChild;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return ConfigXml.NAMESPACE_1_0;
        }

        static {
            elementsByLocal = new HashMap<String, Element>(8);
            elementsByLocal.put(Element.CONFIG.name, CONFIG);
            elementsByLocal.put(Element.CONFIG_DEP.name, CONFIG_DEP);
            elementsByLocal.put(Element.CONFIG_DEPS.name, CONFIG_DEPS);
            elementsByLocal.put(Element.EXCLUDE.name, EXCLUDE);
            elementsByLocal.put(Element.INCLUDE.name, INCLUDE);
            elementsByLocal.put(Element.LAYERS.name, LAYERS);
            elementsByLocal.put(Element.PROP.name, PROP);
            elementsByLocal.put(Element.PROPS.name, PROPS);
            elementsByLocal.put(null, UNKNOWN);
        }
    }
}

