/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.google.common.collect.Interner;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.impl.DefaultFileMetadata;
import org.gradle.internal.fingerprint.GenericFileTreeSnapshotter;
import org.gradle.internal.fingerprint.impl.FileSystemSnapshotBuilder;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class DefaultGenericFileTreeSnapshotter
implements GenericFileTreeSnapshotter {
    private final FileHasher hasher;
    private final Interner<String> stringInterner;

    public DefaultGenericFileTreeSnapshotter(FileHasher hasher, Interner<String> stringInterner) {
        this.hasher = hasher;
        this.stringInterner = stringInterner;
    }

    @Override
    public FileSystemSnapshot snapshotFileTree(FileTreeInternal tree) {
        final FileSystemSnapshotBuilder builder = new FileSystemSnapshotBuilder(this.stringInterner, this.hasher);
        tree.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
                builder.addDir(dirDetails.getFile(), dirDetails.getRelativePath().getSegments());
            }

            public void visitFile(FileVisitDetails fileDetails) {
                builder.addFile(fileDetails.getFile(), fileDetails.getRelativePath().getSegments(), fileDetails.getName(), DefaultFileMetadata.file((long)fileDetails.getLastModified(), (long)fileDetails.getSize(), (FileMetadata.AccessType)FileMetadata.AccessType.viaSymlink((boolean)Files.isSymbolicLink(Paths.get(fileDetails.getPath(), new String[0])))));
            }
        });
        return builder.build();
    }
}

