/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa;

import java.security.KeyPair;
import java.security.SecureRandom;
import net.i2p.crypto.eddsa.EdDSABlinding;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.KeyPairGenerator;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import net.i2p.util.RandomSource;

public final class RedKeyPairGenerator
extends KeyPairGenerator {
    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialized) {
            this.initialize(256, (SecureRandom)RandomSource.getInstance());
        }
        byte[] seed = new byte[this.edParams.getCurve().getField().getb() / 4];
        this.random.nextBytes(seed);
        byte[] b = EdDSABlinding.reduce(seed);
        EdDSAPrivateKeySpec privKey = new EdDSAPrivateKeySpec(b, null, this.edParams);
        EdDSAPublicKeySpec pubKey = new EdDSAPublicKeySpec(privKey.getA(), this.edParams);
        return new KeyPair(new EdDSAPublicKey(pubKey), new EdDSAPrivateKey(privKey));
    }
}

