/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

public final class Spliterators {
    private static final Spliterator<Object> EMPTY_SPLITERATOR = new EmptySpliterator.OfRef<Object>();
    private static final Spliterator.OfInt EMPTY_INT_SPLITERATOR = new EmptySpliterator.OfInt();
    private static final Spliterator.OfLong EMPTY_LONG_SPLITERATOR = new EmptySpliterator.OfLong();
    private static final Spliterator.OfDouble EMPTY_DOUBLE_SPLITERATOR = new EmptySpliterator.OfDouble();

    private Spliterators() {
    }

    public static <T> Spliterator<T> emptySpliterator() {
        return EMPTY_SPLITERATOR;
    }

    public static Spliterator.OfInt emptyIntSpliterator() {
        return EMPTY_INT_SPLITERATOR;
    }

    public static Spliterator.OfLong emptyLongSpliterator() {
        return EMPTY_LONG_SPLITERATOR;
    }

    public static Spliterator.OfDouble emptyDoubleSpliterator() {
        return EMPTY_DOUBLE_SPLITERATOR;
    }

    public static <T> Spliterator<T> spliterator(Object[] objectArray, int n) {
        return new ArraySpliterator(Objects.requireNonNull(objectArray), n);
    }

    public static <T> Spliterator<T> spliterator(Object[] objectArray, int n, int n2, int n3) {
        Spliterators.checkFromToBounds(Objects.requireNonNull(objectArray).length, n, n2);
        return new ArraySpliterator(objectArray, n, n2, n3);
    }

    public static Spliterator.OfInt spliterator(int[] nArray, int n) {
        return new IntArraySpliterator(Objects.requireNonNull(nArray), n);
    }

    public static Spliterator.OfInt spliterator(int[] nArray, int n, int n2, int n3) {
        Spliterators.checkFromToBounds(Objects.requireNonNull(nArray).length, n, n2);
        return new IntArraySpliterator(nArray, n, n2, n3);
    }

    public static Spliterator.OfLong spliterator(long[] lArray, int n) {
        return new LongArraySpliterator(Objects.requireNonNull(lArray), n);
    }

    public static Spliterator.OfLong spliterator(long[] lArray, int n, int n2, int n3) {
        Spliterators.checkFromToBounds(Objects.requireNonNull(lArray).length, n, n2);
        return new LongArraySpliterator(lArray, n, n2, n3);
    }

    public static Spliterator.OfDouble spliterator(double[] dArray, int n) {
        return new DoubleArraySpliterator(Objects.requireNonNull(dArray), n);
    }

    public static Spliterator.OfDouble spliterator(double[] dArray, int n, int n2, int n3) {
        Spliterators.checkFromToBounds(Objects.requireNonNull(dArray).length, n, n2);
        return new DoubleArraySpliterator(dArray, n, n2, n3);
    }

    private static void checkFromToBounds(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new ArrayIndexOutOfBoundsException("origin(" + n2 + ") > fence(" + n3 + ")");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n3 > n) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
    }

    public static <T> Spliterator<T> spliterator(Collection<? extends T> collection, int n) {
        return new IteratorSpliterator<T>(Objects.requireNonNull(collection), n);
    }

    public static <T> Spliterator<T> spliterator(Iterator<? extends T> iterator, long l, int n) {
        return new IteratorSpliterator<T>(Objects.requireNonNull(iterator), l, n);
    }

    public static <T> Spliterator<T> spliteratorUnknownSize(Iterator<? extends T> iterator, int n) {
        return new IteratorSpliterator<T>(Objects.requireNonNull(iterator), n);
    }

    public static Spliterator.OfInt spliterator(PrimitiveIterator.OfInt ofInt, long l, int n) {
        return new IntIteratorSpliterator(Objects.requireNonNull(ofInt), l, n);
    }

    public static Spliterator.OfInt spliteratorUnknownSize(PrimitiveIterator.OfInt ofInt, int n) {
        return new IntIteratorSpliterator(Objects.requireNonNull(ofInt), n);
    }

    public static Spliterator.OfLong spliterator(PrimitiveIterator.OfLong ofLong, long l, int n) {
        return new LongIteratorSpliterator(Objects.requireNonNull(ofLong), l, n);
    }

    public static Spliterator.OfLong spliteratorUnknownSize(PrimitiveIterator.OfLong ofLong, int n) {
        return new LongIteratorSpliterator(Objects.requireNonNull(ofLong), n);
    }

    public static Spliterator.OfDouble spliterator(PrimitiveIterator.OfDouble ofDouble, long l, int n) {
        return new DoubleIteratorSpliterator(Objects.requireNonNull(ofDouble), l, n);
    }

    public static Spliterator.OfDouble spliteratorUnknownSize(PrimitiveIterator.OfDouble ofDouble, int n) {
        return new DoubleIteratorSpliterator(Objects.requireNonNull(ofDouble), n);
    }

    public static <T> Iterator<T> iterator(Spliterator<? extends T> spliterator) {
        Objects.requireNonNull(spliterator);
        class Adapter
        implements Iterator<T>,
        Consumer<T> {
            boolean valueReady = false;
            T nextElement;
            final /* synthetic */ Spliterator val$spliterator;

            Adapter(Spliterator spliterator) {
                this.val$spliterator = spliterator;
            }

            @Override
            public void accept(T t) {
                this.valueReady = true;
                this.nextElement = t;
            }

            @Override
            public boolean hasNext() {
                if (!this.valueReady) {
                    this.val$spliterator.tryAdvance(this);
                }
                return this.valueReady;
            }

            @Override
            public T next() {
                if (!this.valueReady && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.valueReady = false;
                return this.nextElement;
            }
        }
        return new Adapter(spliterator);
    }

    public static PrimitiveIterator.OfInt iterator(Spliterator.OfInt ofInt) {
        Objects.requireNonNull(ofInt);
        class Adapter
        implements PrimitiveIterator.OfInt,
        IntConsumer {
            boolean valueReady = false;
            int nextElement;
            final /* synthetic */ Spliterator.OfInt val$spliterator;

            Adapter(Spliterator.OfInt ofInt) {
                this.val$spliterator = ofInt;
            }

            @Override
            public void accept(int n) {
                this.valueReady = true;
                this.nextElement = n;
            }

            @Override
            public boolean hasNext() {
                if (!this.valueReady) {
                    this.val$spliterator.tryAdvance(this);
                }
                return this.valueReady;
            }

            @Override
            public int nextInt() {
                if (!this.valueReady && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.valueReady = false;
                return this.nextElement;
            }
        }
        return new Adapter(ofInt);
    }

    public static PrimitiveIterator.OfLong iterator(Spliterator.OfLong ofLong) {
        Objects.requireNonNull(ofLong);
        class Adapter
        implements PrimitiveIterator.OfLong,
        LongConsumer {
            boolean valueReady = false;
            long nextElement;
            final /* synthetic */ Spliterator.OfLong val$spliterator;

            Adapter(Spliterator.OfLong ofLong) {
                this.val$spliterator = ofLong;
            }

            @Override
            public void accept(long l) {
                this.valueReady = true;
                this.nextElement = l;
            }

            @Override
            public boolean hasNext() {
                if (!this.valueReady) {
                    this.val$spliterator.tryAdvance(this);
                }
                return this.valueReady;
            }

            @Override
            public long nextLong() {
                if (!this.valueReady && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.valueReady = false;
                return this.nextElement;
            }
        }
        return new Adapter(ofLong);
    }

    public static PrimitiveIterator.OfDouble iterator(Spliterator.OfDouble ofDouble) {
        Objects.requireNonNull(ofDouble);
        class Adapter
        implements PrimitiveIterator.OfDouble,
        DoubleConsumer {
            boolean valueReady = false;
            double nextElement;
            final /* synthetic */ Spliterator.OfDouble val$spliterator;

            Adapter(Spliterator.OfDouble ofDouble) {
                this.val$spliterator = ofDouble;
            }

            @Override
            public void accept(double d) {
                this.valueReady = true;
                this.nextElement = d;
            }

            @Override
            public boolean hasNext() {
                if (!this.valueReady) {
                    this.val$spliterator.tryAdvance(this);
                }
                return this.valueReady;
            }

            @Override
            public double nextDouble() {
                if (!this.valueReady && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.valueReady = false;
                return this.nextElement;
            }
        }
        return new Adapter(ofDouble);
    }

    static final class DoubleIteratorSpliterator
    implements Spliterator.OfDouble {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private PrimitiveIterator.OfDouble it;
        private final int characteristics;
        private long est;
        private int batch;

        public DoubleIteratorSpliterator(PrimitiveIterator.OfDouble ofDouble, long l, int n) {
            this.it = ofDouble;
            this.est = l;
            this.characteristics = (n & 0x1000) == 0 ? n | 0x40 | 0x4000 : n;
        }

        public DoubleIteratorSpliterator(PrimitiveIterator.OfDouble ofDouble, int n) {
            this.it = ofDouble;
            this.est = Long.MAX_VALUE;
            this.characteristics = n & 0xFFFFBFBF;
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            PrimitiveIterator.OfDouble ofDouble = this.it;
            long l = this.est;
            if (l > 1L && ofDouble.hasNext()) {
                int n = this.batch + 1024;
                if ((long)n > l) {
                    n = (int)l;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                double[] dArray = new double[n];
                int n2 = 0;
                do {
                    dArray[n2] = ofDouble.nextDouble();
                } while (++n2 < n && ofDouble.hasNext());
                this.batch = n2;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)n2;
                }
                return new DoubleArraySpliterator(dArray, 0, n2, this.characteristics);
            }
            return null;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
            if (doubleConsumer == null) {
                throw new NullPointerException();
            }
            this.it.forEachRemaining(doubleConsumer);
        }

        @Override
        public boolean tryAdvance(DoubleConsumer doubleConsumer) {
            if (doubleConsumer == null) {
                throw new NullPointerException();
            }
            if (this.it.hasNext()) {
                doubleConsumer.accept(this.it.nextDouble());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Double> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class LongIteratorSpliterator
    implements Spliterator.OfLong {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private PrimitiveIterator.OfLong it;
        private final int characteristics;
        private long est;
        private int batch;

        public LongIteratorSpliterator(PrimitiveIterator.OfLong ofLong, long l, int n) {
            this.it = ofLong;
            this.est = l;
            this.characteristics = (n & 0x1000) == 0 ? n | 0x40 | 0x4000 : n;
        }

        public LongIteratorSpliterator(PrimitiveIterator.OfLong ofLong, int n) {
            this.it = ofLong;
            this.est = Long.MAX_VALUE;
            this.characteristics = n & 0xFFFFBFBF;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            PrimitiveIterator.OfLong ofLong = this.it;
            long l = this.est;
            if (l > 1L && ofLong.hasNext()) {
                int n = this.batch + 1024;
                if ((long)n > l) {
                    n = (int)l;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                long[] lArray = new long[n];
                int n2 = 0;
                do {
                    lArray[n2] = ofLong.nextLong();
                } while (++n2 < n && ofLong.hasNext());
                this.batch = n2;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)n2;
                }
                return new LongArraySpliterator(lArray, 0, n2, this.characteristics);
            }
            return null;
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
            if (longConsumer == null) {
                throw new NullPointerException();
            }
            this.it.forEachRemaining(longConsumer);
        }

        @Override
        public boolean tryAdvance(LongConsumer longConsumer) {
            if (longConsumer == null) {
                throw new NullPointerException();
            }
            if (this.it.hasNext()) {
                longConsumer.accept(this.it.nextLong());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class IntIteratorSpliterator
    implements Spliterator.OfInt {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private PrimitiveIterator.OfInt it;
        private final int characteristics;
        private long est;
        private int batch;

        public IntIteratorSpliterator(PrimitiveIterator.OfInt ofInt, long l, int n) {
            this.it = ofInt;
            this.est = l;
            this.characteristics = (n & 0x1000) == 0 ? n | 0x40 | 0x4000 : n;
        }

        public IntIteratorSpliterator(PrimitiveIterator.OfInt ofInt, int n) {
            this.it = ofInt;
            this.est = Long.MAX_VALUE;
            this.characteristics = n & 0xFFFFBFBF;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            PrimitiveIterator.OfInt ofInt = this.it;
            long l = this.est;
            if (l > 1L && ofInt.hasNext()) {
                int n = this.batch + 1024;
                if ((long)n > l) {
                    n = (int)l;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                int[] nArray = new int[n];
                int n2 = 0;
                do {
                    nArray[n2] = ofInt.nextInt();
                } while (++n2 < n && ofInt.hasNext());
                this.batch = n2;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)n2;
                }
                return new IntArraySpliterator(nArray, 0, n2, this.characteristics);
            }
            return null;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            if (intConsumer == null) {
                throw new NullPointerException();
            }
            this.it.forEachRemaining(intConsumer);
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            if (intConsumer == null) {
                throw new NullPointerException();
            }
            if (this.it.hasNext()) {
                intConsumer.accept(this.it.nextInt());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static class IteratorSpliterator<T>
    implements Spliterator<T> {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final Collection<? extends T> collection;
        private Iterator<? extends T> it;
        private final int characteristics;
        private long est;
        private int batch;

        public IteratorSpliterator(Collection<? extends T> collection, int n) {
            this.collection = collection;
            this.it = null;
            this.characteristics = (n & 0x1000) == 0 ? n | 0x40 | 0x4000 : n;
        }

        public IteratorSpliterator(Iterator<? extends T> iterator, long l, int n) {
            this.collection = null;
            this.it = iterator;
            this.est = l;
            this.characteristics = (n & 0x1000) == 0 ? n | 0x40 | 0x4000 : n;
        }

        public IteratorSpliterator(Iterator<? extends T> iterator, int n) {
            this.collection = null;
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = n & 0xFFFFBFBF;
        }

        @Override
        public Spliterator<T> trySplit() {
            long l;
            Iterator<Object> iterator = this.it;
            if (iterator == null) {
                this.it = this.collection.iterator();
                iterator = this.it;
                l = this.est = (long)this.collection.size();
            } else {
                l = this.est;
            }
            if (l > 1L && iterator.hasNext()) {
                int n = this.batch + 1024;
                if ((long)n > l) {
                    n = (int)l;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                Object[] objectArray = new Object[n];
                int n2 = 0;
                do {
                    objectArray[n2] = iterator.next();
                } while (++n2 < n && iterator.hasNext());
                this.batch = n2;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)n2;
                }
                return new ArraySpliterator(objectArray, 0, n2, this.characteristics);
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Iterator<T> iterator = this.it;
            if (iterator == null) {
                this.it = this.collection.iterator();
                iterator = this.it;
                this.est = this.collection.size();
            }
            iterator.forEachRemaining(consumer);
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            if (this.it == null) {
                this.it = this.collection.iterator();
                this.est = this.collection.size();
            }
            if (this.it.hasNext()) {
                consumer.accept(this.it.next());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            if (this.it == null) {
                this.it = this.collection.iterator();
                this.est = this.collection.size();
                return this.est;
            }
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super T> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    public static abstract class AbstractDoubleSpliterator
    implements Spliterator.OfDouble {
        static final int MAX_BATCH = 0x2000000;
        static final int BATCH_UNIT = 1024;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractDoubleSpliterator(long l, int n) {
            this.est = l;
            this.characteristics = (n & 0x40) != 0 ? n | 0x4000 : n;
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            HoldingDoubleConsumer holdingDoubleConsumer = new HoldingDoubleConsumer();
            long l = this.est;
            if (l > 1L && this.tryAdvance(holdingDoubleConsumer)) {
                int n = this.batch + 1024;
                if ((long)n > l) {
                    n = (int)l;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                double[] dArray = new double[n];
                int n2 = 0;
                do {
                    dArray[n2] = holdingDoubleConsumer.value;
                } while (++n2 < n && this.tryAdvance(holdingDoubleConsumer));
                this.batch = n2;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)n2;
                }
                return new DoubleArraySpliterator(dArray, 0, n2, this.characteristics());
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        static final class HoldingDoubleConsumer
        implements DoubleConsumer {
            double value;

            HoldingDoubleConsumer() {
            }

            @Override
            public void accept(double d) {
                this.value = d;
            }
        }
    }

    public static abstract class AbstractLongSpliterator
    implements Spliterator.OfLong {
        static final int MAX_BATCH = 0x2000000;
        static final int BATCH_UNIT = 1024;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractLongSpliterator(long l, int n) {
            this.est = l;
            this.characteristics = (n & 0x40) != 0 ? n | 0x4000 : n;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            HoldingLongConsumer holdingLongConsumer = new HoldingLongConsumer();
            long l = this.est;
            if (l > 1L && this.tryAdvance(holdingLongConsumer)) {
                int n = this.batch + 1024;
                if ((long)n > l) {
                    n = (int)l;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                long[] lArray = new long[n];
                int n2 = 0;
                do {
                    lArray[n2] = holdingLongConsumer.value;
                } while (++n2 < n && this.tryAdvance(holdingLongConsumer));
                this.batch = n2;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)n2;
                }
                return new LongArraySpliterator(lArray, 0, n2, this.characteristics());
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        static final class HoldingLongConsumer
        implements LongConsumer {
            long value;

            HoldingLongConsumer() {
            }

            @Override
            public void accept(long l) {
                this.value = l;
            }
        }
    }

    public static abstract class AbstractIntSpliterator
    implements Spliterator.OfInt {
        static final int MAX_BATCH = 0x2000000;
        static final int BATCH_UNIT = 1024;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractIntSpliterator(long l, int n) {
            this.est = l;
            this.characteristics = (n & 0x40) != 0 ? n | 0x4000 : n;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            HoldingIntConsumer holdingIntConsumer = new HoldingIntConsumer();
            long l = this.est;
            if (l > 1L && this.tryAdvance(holdingIntConsumer)) {
                int n = this.batch + 1024;
                if ((long)n > l) {
                    n = (int)l;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                int[] nArray = new int[n];
                int n2 = 0;
                do {
                    nArray[n2] = holdingIntConsumer.value;
                } while (++n2 < n && this.tryAdvance(holdingIntConsumer));
                this.batch = n2;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)n2;
                }
                return new IntArraySpliterator(nArray, 0, n2, this.characteristics());
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        static final class HoldingIntConsumer
        implements IntConsumer {
            int value;

            HoldingIntConsumer() {
            }

            @Override
            public void accept(int n) {
                this.value = n;
            }
        }
    }

    public static abstract class AbstractSpliterator<T>
    implements Spliterator<T> {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final int characteristics;
        private long est;
        private int batch;

        protected AbstractSpliterator(long l, int n) {
            this.est = l;
            this.characteristics = (n & 0x40) != 0 ? n | 0x4000 : n;
        }

        @Override
        public Spliterator<T> trySplit() {
            HoldingConsumer holdingConsumer = new HoldingConsumer();
            long l = this.est;
            if (l > 1L && this.tryAdvance(holdingConsumer)) {
                int n = this.batch + 1024;
                if ((long)n > l) {
                    n = (int)l;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                Object[] objectArray = new Object[n];
                int n2 = 0;
                do {
                    objectArray[n2] = holdingConsumer.value;
                } while (++n2 < n && this.tryAdvance(holdingConsumer));
                this.batch = n2;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)n2;
                }
                return new ArraySpliterator(objectArray, 0, n2, this.characteristics());
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        static final class HoldingConsumer<T>
        implements Consumer<T> {
            Object value;

            HoldingConsumer() {
            }

            @Override
            public void accept(T t) {
                this.value = t;
            }
        }
    }

    static final class DoubleArraySpliterator
    implements Spliterator.OfDouble {
        private final double[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public DoubleArraySpliterator(double[] dArray, int n) {
            this(dArray, 0, dArray.length, n);
        }

        public DoubleArraySpliterator(double[] dArray, int n, int n2, int n3) {
            this.array = dArray;
            this.index = n;
            this.fence = n2;
            this.characteristics = n3 | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            DoubleArraySpliterator doubleArraySpliterator;
            int n = this.index;
            int n2 = n + this.fence >>> 1;
            if (n >= n2) {
                doubleArraySpliterator = null;
            } else {
                this.index = n2;
                DoubleArraySpliterator doubleArraySpliterator2 = new DoubleArraySpliterator(this.array, n, this.index, this.characteristics);
                doubleArraySpliterator = doubleArraySpliterator2;
            }
            return doubleArraySpliterator;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
            int n;
            if (doubleConsumer == null) {
                throw new NullPointerException();
            }
            double[] dArray = this.array;
            int n2 = this.fence;
            if (this.array.length >= n2 && (n = this.index) >= 0 && n < (this.index = n2)) {
                do {
                    doubleConsumer.accept(dArray[n]);
                } while (++n < n2);
            }
        }

        @Override
        public boolean tryAdvance(DoubleConsumer doubleConsumer) {
            if (doubleConsumer == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                doubleConsumer.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Double> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class LongArraySpliterator
    implements Spliterator.OfLong {
        private final long[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public LongArraySpliterator(long[] lArray, int n) {
            this(lArray, 0, lArray.length, n);
        }

        public LongArraySpliterator(long[] lArray, int n, int n2, int n3) {
            this.array = lArray;
            this.index = n;
            this.fence = n2;
            this.characteristics = n3 | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            LongArraySpliterator longArraySpliterator;
            int n = this.index;
            int n2 = n + this.fence >>> 1;
            if (n >= n2) {
                longArraySpliterator = null;
            } else {
                this.index = n2;
                LongArraySpliterator longArraySpliterator2 = new LongArraySpliterator(this.array, n, this.index, this.characteristics);
                longArraySpliterator = longArraySpliterator2;
            }
            return longArraySpliterator;
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
            int n;
            if (longConsumer == null) {
                throw new NullPointerException();
            }
            long[] lArray = this.array;
            int n2 = this.fence;
            if (this.array.length >= n2 && (n = this.index) >= 0 && n < (this.index = n2)) {
                do {
                    longConsumer.accept(lArray[n]);
                } while (++n < n2);
            }
        }

        @Override
        public boolean tryAdvance(LongConsumer longConsumer) {
            if (longConsumer == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                longConsumer.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class IntArraySpliterator
    implements Spliterator.OfInt {
        private final int[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public IntArraySpliterator(int[] nArray, int n) {
            this(nArray, 0, nArray.length, n);
        }

        public IntArraySpliterator(int[] nArray, int n, int n2, int n3) {
            this.array = nArray;
            this.index = n;
            this.fence = n2;
            this.characteristics = n3 | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            IntArraySpliterator intArraySpliterator;
            int n = this.index;
            int n2 = n + this.fence >>> 1;
            if (n >= n2) {
                intArraySpliterator = null;
            } else {
                this.index = n2;
                IntArraySpliterator intArraySpliterator2 = new IntArraySpliterator(this.array, n, this.index, this.characteristics);
                intArraySpliterator = intArraySpliterator2;
            }
            return intArraySpliterator;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            int n;
            if (intConsumer == null) {
                throw new NullPointerException();
            }
            int[] nArray = this.array;
            int n2 = this.fence;
            if (this.array.length >= n2 && (n = this.index) >= 0 && n < (this.index = n2)) {
                do {
                    intConsumer.accept(nArray[n]);
                } while (++n < n2);
            }
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            if (intConsumer == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                intConsumer.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class ArraySpliterator<T>
    implements Spliterator<T> {
        private final Object[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public ArraySpliterator(Object[] objectArray, int n) {
            this(objectArray, 0, objectArray.length, n);
        }

        public ArraySpliterator(Object[] objectArray, int n, int n2, int n3) {
            this.array = objectArray;
            this.index = n;
            this.fence = n2;
            this.characteristics = n3 | 0x40 | 0x4000;
        }

        @Override
        public Spliterator<T> trySplit() {
            ArraySpliterator<T> arraySpliterator;
            int n = this.index;
            int n2 = n + this.fence >>> 1;
            if (n >= n2) {
                arraySpliterator = null;
            } else {
                this.index = n2;
                ArraySpliterator<T> arraySpliterator2 = new ArraySpliterator<T>(this.array, n, this.index, this.characteristics);
                arraySpliterator = arraySpliterator2;
            }
            return arraySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> consumer) {
            int n;
            if (consumer == null) {
                throw new NullPointerException();
            }
            Object[] objectArray = this.array;
            int n2 = this.fence;
            if (this.array.length >= n2 && (n = this.index) >= 0 && n < (this.index = n2)) {
                do {
                    consumer.accept(objectArray[n]);
                } while (++n < n2);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                Object object = this.array[this.index++];
                consumer.accept(object);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super T> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    private static abstract class EmptySpliterator<T, S extends Spliterator<T>, C> {
        EmptySpliterator() {
        }

        public S trySplit() {
            return null;
        }

        public boolean tryAdvance(C c) {
            Objects.requireNonNull(c);
            return false;
        }

        public void forEachRemaining(C c) {
            Objects.requireNonNull(c);
        }

        public long estimateSize() {
            return 0L;
        }

        public int characteristics() {
            return 16448;
        }

        private static final class OfDouble
        extends EmptySpliterator<Double, Spliterator.OfDouble, DoubleConsumer>
        implements Spliterator.OfDouble {
            OfDouble() {
            }
        }

        private static final class OfLong
        extends EmptySpliterator<Long, Spliterator.OfLong, LongConsumer>
        implements Spliterator.OfLong {
            OfLong() {
            }
        }

        private static final class OfInt
        extends EmptySpliterator<Integer, Spliterator.OfInt, IntConsumer>
        implements Spliterator.OfInt {
            OfInt() {
            }
        }

        private static final class OfRef<T>
        extends EmptySpliterator<T, Spliterator<T>, Consumer<? super T>>
        implements Spliterator<T> {
            OfRef() {
            }
        }
    }
}

