"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var __1 = require("../../..");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var goal_spec_1 = require("./goal_spec");
var picked_shapes_1 = require("./picked_shapes");
function createOnElementOutCaller() {
    var prevPickedShapes = null;
    var selector = null;
    return function (state) {
        if (selector === null && state.chartType === __1.ChartTypes.Goal) {
            selector = re_reselect_1.default([goal_spec_1.getSpecOrNull, picked_shapes_1.getPickedShapesLayerValues, get_settings_specs_1.getSettingsSpecSelector], function (spec, pickedShapes, settings) {
                if (!spec) {
                    return;
                }
                if (!settings.onElementOut) {
                    return;
                }
                var nextPickedShapes = pickedShapes.length;
                if (prevPickedShapes !== null && prevPickedShapes > 0 && nextPickedShapes === 0) {
                    settings.onElementOut();
                }
                prevPickedShapes = nextPickedShapes;
            })({
                keySelector: get_chart_id_1.getChartIdSelector,
            });
        }
        if (selector) {
            selector(state);
        }
    };
}
exports.createOnElementOutCaller = createOnElementOutCaller;
//# sourceMappingURL=on_element_out_caller.js.map