/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.notifications.filter;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.notifications.NotificationImpl;
import org.netbeans.modules.notifications.filter.CategoryFilter;
import org.netbeans.modules.notifications.filter.Util;

public class NotificationFilter {
    public static final NotificationFilter EMPTY = new EmptyNotificationFilter();
    private String name;
    private CategoryFilter categoryFilter = new CategoryFilter();

    NotificationFilter(String name) {
        this.name = name;
    }

    NotificationFilter() {
    }

    private NotificationFilter(NotificationFilter src) {
        this.name = src.getName();
        this.categoryFilter = null == src.getCategoryFilter() ? null : src.getCategoryFilter().clone();
    }

    public boolean isEnabled(NotificationImpl notification) {
        return this.categoryFilter == null ? true : this.categoryFilter.isEnabled(notification.getCategory().getName());
    }

    public String getName() {
        return this.name;
    }

    void setName(String newName) {
        this.name = newName;
    }

    CategoryFilter getCategoryFilter() {
        return this.categoryFilter;
    }

    void setCategoryFilter(CategoryFilter categoryFilter) {
        this.categoryFilter = categoryFilter;
    }

    public Object clone() {
        return new NotificationFilter(this);
    }

    public String toString() {
        return this.name;
    }

    void load(Preferences prefs, String prefix) throws BackingStoreException {
        this.name = prefs.get(prefix + "_name", "Filter");
        if (prefs.getBoolean(prefix + "_types", false)) {
            this.categoryFilter = new CategoryFilter();
            this.categoryFilter.load(prefs, prefix + "_types");
        } else {
            this.categoryFilter = null;
        }
    }

    void save(Preferences prefs, String prefix) throws BackingStoreException {
        prefs.put(prefix + "_name", this.name);
        if (null != this.categoryFilter) {
            prefs.putBoolean(prefix + "_types", true);
            this.categoryFilter.save(prefs, prefix + "_types");
        } else {
            prefs.putBoolean(prefix + "_types", false);
        }
    }

    private static class EmptyNotificationFilter
    extends NotificationFilter {
        public EmptyNotificationFilter() {
            super(Util.getString("no-filter"));
        }

        @Override
        public boolean isEnabled(NotificationImpl notification) {
            return true;
        }
    }
}

