/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee.ide;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.payara.jakartaee.ide.Hk2Target;

public class Hk2TargetModuleID
implements TargetModuleID {
    private final Hk2Target target;
    private final String docBaseURI;
    private String contextPath;
    private final String location;
    private TargetModuleID parent;
    private final Vector<TargetModuleID> children;
    private static final Map<String, Hk2TargetModuleID> knownModules = new HashMap<String, Hk2TargetModuleID>();

    private Hk2TargetModuleID(Hk2Target target, String docBaseURI, String contextPath, String location) {
        this.target = target;
        this.docBaseURI = docBaseURI;
        this.contextPath = contextPath;
        this.location = location;
        this.parent = null;
        this.children = new Vector();
    }

    public static Hk2TargetModuleID get(Hk2Target target, String docBaseURI, String contextPath, String location) {
        return Hk2TargetModuleID.get(target, docBaseURI, contextPath, location, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hk2TargetModuleID get(Hk2Target target, String docBaseURI, String contextPath, String location, boolean clearChildren) {
        Map<String, Hk2TargetModuleID> map = knownModules;
        synchronized (map) {
            String key;
            Hk2TargetModuleID retVal;
            if (!location.endsWith(File.separator)) {
                location = location + File.separator;
            }
            if (null == (retVal = knownModules.get(key = target.getServerUri() + docBaseURI + location))) {
                retVal = new Hk2TargetModuleID(target, docBaseURI, contextPath, location);
                knownModules.put(key, retVal);
            } else if (null != contextPath) {
                retVal.setPath(contextPath);
            }
            if (clearChildren) {
                retVal.children.clear();
            }
            return retVal;
        }
    }

    public Target getTarget() {
        return this.target;
    }

    public String getModuleID() {
        return this.docBaseURI;
    }

    public String getWebURL() {
        if (null != this.contextPath) {
            if (!this.contextPath.startsWith("/")) {
                return this.target.getServerUri() + "/" + this.contextPath.replaceAll(" ", "%20");
            }
            return this.target.getServerUri() + this.contextPath.replaceAll(" ", "%20");
        }
        return null;
    }

    public String getLocation() {
        return this.location;
    }

    public TargetModuleID getParentTargetModuleID() {
        return this.parent;
    }

    public TargetModuleID[] getChildTargetModuleID() {
        return this.children.toArray(new TargetModuleID[this.children.size()]);
    }

    public void setParent(Hk2TargetModuleID parent) {
        this.parent = parent;
    }

    public void setPath(String p) {
        this.contextPath = p;
    }

    public String getContextRoot() {
        return this.contextPath;
    }

    public void addChild(Hk2TargetModuleID child) {
        this.children.add(child);
        child.setParent(this);
    }

    public String toString() {
        return this.getModuleID();
    }
}

