/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.v8debug;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.v8debug.V8Body;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8Packet;
import org.netbeans.lib.v8debug.V8Type;
import org.netbeans.lib.v8debug.vars.ReferencedValue;
import org.netbeans.lib.v8debug.vars.V8Value;

public final class V8Response
extends V8Packet {
    private final long requestSequence;
    private final V8Command command;
    private final V8Body body;
    private final ReferencedValue[] referencedValues;
    private Map<Long, V8Value> valuesByReferences;
    private final boolean running;
    private final boolean success;
    private final String errorMessage;

    V8Response(long sequence, long requestSequence, V8Command command, V8Body body, ReferencedValue[] referencedValues, boolean running, boolean success, String errorMessage) {
        super(sequence, V8Type.response);
        this.requestSequence = requestSequence;
        this.command = command;
        this.body = body;
        this.referencedValues = referencedValues;
        this.running = running;
        this.success = success;
        this.errorMessage = errorMessage;
    }

    public long getRequestSequence() {
        return this.requestSequence;
    }

    public V8Command getCommand() {
        return this.command;
    }

    public V8Body getBody() {
        return this.body;
    }

    public ReferencedValue[] getReferencedValues() {
        return this.referencedValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V8Value getReferencedValue(long reference) {
        if (this.referencedValues == null || this.referencedValues.length == 0) {
            return null;
        }
        V8Response v8Response = this;
        synchronized (v8Response) {
            if (this.valuesByReferences == null) {
                this.valuesByReferences = V8Response.createValuesByReference(this.referencedValues);
            }
            return this.valuesByReferences.get(reference);
        }
    }

    static Map<Long, V8Value> createValuesByReference(ReferencedValue[] referencedValues) {
        HashMap<Long, V8Value> valuesByReferences = new HashMap<Long, V8Value>();
        for (int i = 0; i < referencedValues.length; ++i) {
            valuesByReferences.put(referencedValues[i].getReference(), (V8Value)referencedValues[i].getValue());
        }
        return valuesByReferences;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

