/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ArrayTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.ArrayFieldVariable;
import org.netbeans.modules.debugger.jpda.models.ClassFieldVariable;
import org.netbeans.modules.debugger.jpda.models.ClassVariableImpl;
import org.netbeans.modules.debugger.jpda.models.FieldVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ObjectArrayFieldVariable;
import org.netbeans.modules.debugger.jpda.models.ObjectFieldVariable;
import org.netbeans.modules.debugger.jpda.models.ShortenedStrings;
import org.netbeans.modules.debugger.jpda.models.SuperVariable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class AbstractObjectVariable
extends AbstractVariable
implements ObjectVariable {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.getValue");
    public static final int MAX_STRING_LENGTH = 100000;
    private String genericType;
    private org.netbeans.api.debugger.jpda.Field[] fields;
    private org.netbeans.api.debugger.jpda.Field[] staticFields;
    private org.netbeans.api.debugger.jpda.Field[] inheritedFields;
    private boolean refreshFields;
    private final Object fieldsLock = new Object();
    private Type valueType;
    private String valueTypeName;
    private final boolean[] valueTypeLoaded = new boolean[]{false};
    private boolean valueTypeLoading = false;
    private Super superClass;
    private final boolean[] superClassLoaded = new boolean[]{false};
    private boolean superClassLoading = false;
    private DebuggetStateListener stateChangeListener = new DebuggetStateListener();
    private int cloneNumber = 1;

    public AbstractObjectVariable(JPDADebuggerImpl debugger, Value value, String id) {
        this(debugger, value, (Type)null, id);
    }

    protected AbstractObjectVariable(JPDADebuggerImpl debugger, Value value, Type valueType, String id) {
        super(debugger, value, id);
        if (valueType != null) {
            this.valueType = valueType;
            try {
                this.valueTypeName = TypeWrapper.name(valueType);
            }
            catch (InternalExceptionWrapper ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                // empty catch block
            }
            this.valueTypeLoaded[0] = true;
        }
        debugger.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.stateChangeListener, (Object)((Object)debugger)));
    }

    public AbstractObjectVariable(JPDADebuggerImpl debugger, Value value, String genericSignature, String id) {
        this(debugger, value, id);
        try {
            if (genericSignature != null) {
                this.genericType = AbstractObjectVariable.getTypeDescription(new PushbackReader(new StringReader(genericSignature), 1));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFieldsCount() {
        Value v = this.getInnerValue();
        if (v == null) {
            return 0;
        }
        if (v instanceof ArrayReference) {
            return ArrayReferenceWrapper.length0((ArrayReference)v);
        }
        Object object = this.fieldsLock;
        synchronized (object) {
            if (this.fields == null || this.refreshFields) {
                this.initFields();
            }
            return this.fields.length;
        }
    }

    public org.netbeans.api.debugger.jpda.Field getField(String name) {
        Field f;
        Value v = this.getInnerValue();
        if (v == null) {
            return null;
        }
        try {
            f = ReferenceTypeWrapper.fieldByName((ReferenceType)ValueWrapper.type(v), name);
        }
        catch (ClassNotPreparedExceptionWrapper ex) {
            return null;
        }
        catch (InternalExceptionWrapper iex) {
            return null;
        }
        catch (ObjectCollectedExceptionWrapper ocex) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return null;
        }
        if (f == null) {
            return null;
        }
        return this.getField(f, (ObjectReference)this.getInnerValue(), this.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.netbeans.api.debugger.jpda.Field[] getFields(int from, int to) {
        Value v = this.getInnerValue();
        if (v == null) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        try {
            if (v instanceof ArrayReference && (from > 0 || to < ArrayReferenceWrapper.length((ArrayReference)v))) {
                Type type = ValueWrapper.type(v);
                ReferenceType rt = (ReferenceType)type;
                if (to == 0) {
                    to = ArrayReferenceWrapper.length((ArrayReference)v);
                }
                org.netbeans.api.debugger.jpda.Field[] elements = this.getFieldsOfArray((ArrayReference)v, ArrayTypeWrapper.componentTypeName((ArrayType)rt), this.getID(), from, to);
                return elements;
            }
            Object type = this.fieldsLock;
            synchronized (type) {
                if (this.fields == null || this.refreshFields) {
                    this.initFields();
                }
                return AbstractObjectVariable.getSubFields(this.fields, from, to);
            }
        }
        catch (InternalExceptionWrapper e) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        catch (ObjectCollectedExceptionWrapper e) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.netbeans.api.debugger.jpda.Field[] getAllStaticFields(int from, int to) {
        Value v = this.getInnerValue();
        if (v == null || v instanceof ArrayReference) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        Object object = this.fieldsLock;
        synchronized (object) {
            if (this.fields == null || this.refreshFields) {
                this.initFields();
            }
            return AbstractObjectVariable.getSubFields(this.staticFields, from, to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.netbeans.api.debugger.jpda.Field[] getInheritedFields(int from, int to) {
        Value v = this.getInnerValue();
        if (v == null || v instanceof ArrayReference) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        Object object = this.fieldsLock;
        synchronized (object) {
            if (this.fields == null || this.refreshFields) {
                this.initFields();
            }
            return AbstractObjectVariable.getSubFields(this.inheritedFields, from, to);
        }
    }

    private static org.netbeans.api.debugger.jpda.Field[] getSubFields(org.netbeans.api.debugger.jpda.Field[] fields, int from, int to) {
        if (fields == null) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        if (to != 0) {
            to = Math.min(fields.length, to);
            from = Math.min(fields.length, from);
            org.netbeans.api.debugger.jpda.Field[] fv = new org.netbeans.api.debugger.jpda.Field[to - from];
            System.arraycopy(fields, from, fv, 0, to - from);
            fields = fv;
        }
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Super getSuper() {
        boolean[] blArray = this.superClassLoaded;
        synchronized (this.superClassLoaded) {
            if (this.superClassLoaded[0]) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.superClass;
            }
            if (this.superClassLoading) {
                try {
                    this.superClassLoaded.wait();
                }
                catch (InterruptedException ex) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
                if (this.superClassLoaded[0]) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return this.superClass;
                }
            } else {
                this.superClassLoading = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            SuperVariable sup = null;
            try {
                SuperVariable s;
                ClassType superType;
                Type t = this.getCachedType();
                if (!(t instanceof ClassType) || (superType = ClassTypeWrapper.superclass((ClassType)t)) == null) return sup;
                sup = s = new SuperVariable(this.getDebugger(), (ObjectReference)this.getInnerValue(), superType, this.getID());
                return sup;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                boolean[] blArray2 = this.superClassLoaded;
                synchronized (this.superClassLoaded) {
                    if (!this.superClassLoading) return sup;
                    this.superClass = sup;
                    this.superClassLoading = false;
                    this.superClassLoaded[0] = true;
                    this.superClassLoaded.notifyAll();
                    // ** MonitorExit[var2_5] (shouldn't be in output)
                    return sup;
                }
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                boolean[] blArray3 = this.superClassLoaded;
                synchronized (this.superClassLoaded) {
                    if (!this.superClassLoading) return sup;
                    this.superClass = sup;
                    this.superClassLoading = false;
                    this.superClassLoaded[0] = true;
                    this.superClassLoaded.notifyAll();
                    // ** MonitorExit[var2_7] (shouldn't be in output)
                    return sup;
                }
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                boolean[] blArray4 = this.superClassLoaded;
                synchronized (this.superClassLoaded) {
                    if (!this.superClassLoading) return sup;
                    this.superClass = sup;
                    this.superClassLoading = false;
                    this.superClassLoaded[0] = true;
                    this.superClassLoaded.notifyAll();
                    // ** MonitorExit[var2_9] (shouldn't be in output)
                    return sup;
                }
            }
            finally {
                boolean[] blArray5 = this.superClassLoaded;
                synchronized (this.superClassLoaded) {
                    if (this.superClassLoading) {
                        this.superClass = sup;
                        this.superClassLoading = false;
                        this.superClassLoaded[0] = true;
                        this.superClassLoaded.notifyAll();
                    }
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasAllTypes() {
        if (this.getInnerValue() == null) {
            return true;
        }
        boolean[] blArray = this.valueTypeLoaded;
        synchronized (this.valueTypeLoaded) {
            if (!this.valueTypeLoaded[0]) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return false;
            }
            Type t = this.valueType;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (!(t instanceof ClassType)) return true;
            ClassType ct = (ClassType)t;
            if (!this.getDebugger().hasAllInterfaces(ct)) {
                return false;
            }
            boolean[] blArray2 = this.superClassLoaded;
            synchronized (this.superClassLoaded) {
                if (this.superClassLoaded[0]) return true;
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return false;
            }
        }
    }

    public void loadAllTypes() {
        this.getAllInterfaces();
        for (Super s = this.getSuper(); s != null; s = s.getSuper()) {
        }
    }

    public List<JPDAClassType> getAllInterfaces() {
        if (this.getInnerValue() == null) {
            return null;
        }
        try {
            Type t = this.getCachedType();
            if (!(t instanceof ClassType)) {
                return null;
            }
            ClassType ct = (ClassType)t;
            return this.getDebugger().getAllInterfaces(ct);
        }
        catch (ObjectCollectedExceptionWrapper ocex) {
            return null;
        }
        catch (InternalExceptionWrapper ex) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return null;
        }
    }

    public String getToStringValue() throws InvalidExpressionException {
        Value v = this.getInnerValue();
        return AbstractObjectVariable.getToStringValue(v, this.getDebugger(), 0);
    }

    public String getToStringValue(int maxLength) throws InvalidExpressionException {
        Value v = this.getInnerValue();
        try {
            return AbstractObjectVariable.getToStringValue(v, this.getCachedType(), this.getDebugger(), maxLength);
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_Disconnected");
        }
        catch (ObjectCollectedExceptionWrapper ocex) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_ObjCollected");
        }
    }

    static String getToStringValue(Value v, JPDADebuggerImpl debugger, int maxLength) throws InvalidExpressionException {
        Type type;
        if (v == null) {
            return null;
        }
        try {
            type = ValueWrapper.type(v);
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_Disconnected");
        }
        catch (ObjectCollectedExceptionWrapper ocex) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_ObjCollected");
        }
        return AbstractObjectVariable.getToStringValue(v, type, debugger, maxLength);
    }

    static String getToStringValue(Value v, Type type, JPDADebuggerImpl debugger, int maxLength) throws InvalidExpressionException {
        if (v == null) {
            return null;
        }
        try {
            Method toStringMethod;
            StringReference sr;
            if (!(type instanceof ClassType)) {
                return AbstractVariable.getValue(v);
            }
            ClassType ct = (ClassType)type;
            if (v instanceof CharValue) {
                return "'" + v.toString() + "'";
            }
            boolean addQuotation = false;
            boolean addDots = false;
            int n = maxLength = maxLength > 0 && maxLength < 100000 ? maxLength : 100000;
            if (v instanceof StringReference) {
                sr = (StringReference)v;
                addQuotation = true;
            } else if (maxLength > 0 && maxLength < Integer.MAX_VALUE) {
                toStringMethod = ClassTypeWrapper.concreteMethodByName(ct, "toString", "()Ljava/lang/String;");
                if (toStringMethod == null) {
                    return NbBundle.getMessage(AbstractObjectVariable.class, (String)"MSG_No_toString");
                }
                sr = (StringReference)debugger.invokeMethod((ObjectReference)v, toStringMethod, new Value[0], maxLength + 1);
            } else {
                toStringMethod = ClassTypeWrapper.concreteMethodByName(ct, "toString", "()Ljava/lang/String;");
                if (toStringMethod == null) {
                    return NbBundle.getMessage(AbstractObjectVariable.class, (String)"MSG_No_toString");
                }
                sr = (StringReference)debugger.invokeMethod((ObjectReference)v, toStringMethod, new Value[0]);
            }
            if (sr == null) {
                return null;
            }
            String str = ShortenedStrings.getStringWithLengthControl(sr);
            if (addQuotation) {
                str = "\"" + str + "\"";
            }
            return str;
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_Disconnected");
        }
        catch (ObjectCollectedExceptionWrapper ocex) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_ObjCollected");
        }
        catch (ClassNotPreparedExceptionWrapper cnpex) {
            return cnpex.getLocalizedMessage();
        }
    }

    public Variable invokeMethod(String methodName, String signature, Variable[] arguments) throws NoSuchMethodException, InvalidExpressionException {
        return this.invokeMethod(null, methodName, signature, arguments);
    }

    public Variable invokeMethod(JPDAThread thread, String methodName, String signature, Variable[] arguments) throws NoSuchMethodException, InvalidExpressionException {
        try {
            int j;
            int jj;
            List<Method> l;
            Value v = this.getInnerValue();
            if (v == null) {
                return null;
            }
            ClassType ct = (ClassType)this.getCachedType();
            Method method = null;
            if (signature != null) {
                method = ClassTypeWrapper.concreteMethodByName(ct, methodName, signature);
            } else {
                l = ReferenceTypeWrapper.methodsByName(ct, methodName);
                jj = l.size();
                for (j = 0; j < jj; ++j) {
                    if (MethodWrapper.isAbstract(l.get(j)) || !MethodWrapper.argumentTypeNames(l.get(j)).isEmpty()) continue;
                    method = l.get(j);
                    break;
                }
            }
            if (method == null) {
                l = ReferenceTypeWrapper.methodsByName(ct, methodName);
                jj = l.size();
                logger.log(Level.INFO, "No method {0}.{1} with signature {2}", new Object[]{TypeWrapper.name(ct), methodName, signature});
                logger.info("Found following methods with signatures:");
                for (j = 0; j < jj; ++j) {
                    logger.info(TypeComponentWrapper.signature(l.get(j)));
                }
                throw new NoSuchMethodException(TypeWrapper.name(ct) + "." + methodName + " : " + signature);
            }
            Value[] vs = new Value[arguments.length];
            int k = arguments.length;
            for (int i = 0; i < k; ++i) {
                vs[i] = arguments[i] == null ? null : ((AbstractVariable)arguments[i]).getInnerValue();
            }
            v = this.getDebugger().invokeMethod((JPDAThreadImpl)thread, (ObjectReference)v, method, vs);
            if (v instanceof ObjectReference) {
                return new AbstractObjectVariable(this.getDebugger(), (ObjectReference)v, this.getID() + method + "^");
            }
            return new AbstractVariable(this.getDebugger(), v, this.getID() + method);
        }
        catch (InternalExceptionWrapper ex) {
            return null;
        }
        catch (ClassNotPreparedExceptionWrapper ex) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return null;
        }
        catch (ObjectCollectedExceptionWrapper ocex) {
            return null;
        }
    }

    public Variable evaluate(String expression) throws InvalidExpressionException {
        if ("toString()".equals(expression) && String.class.getName().equals(this.getType())) {
            return this;
        }
        return this.getDebugger().evaluate(expression, this);
    }

    private Type getCachedType() throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        return this.getCachedType(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type getCachedType(String[] namePtr) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        boolean[] blArray = this.valueTypeLoaded;
        synchronized (this.valueTypeLoaded) {
            if (this.valueTypeLoaded[0]) {
                if (namePtr != null) {
                    namePtr[0] = this.valueTypeName;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.valueType;
            }
            if (this.valueTypeLoading) {
                try {
                    this.valueTypeLoaded.wait();
                }
                catch (InterruptedException ex) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                if (this.valueTypeLoaded[0]) {
                    if (namePtr != null) {
                        namePtr[0] = this.valueTypeName;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.valueType;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            this.valueTypeLoading = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Value v = this.getInnerValue();
            Type type = null;
            String typeName = "";
            try {
                if (v != null) {
                    type = ValueWrapper.type(v);
                    typeName = TypeWrapper.name(type);
                }
            }
            finally {
                boolean[] blArray2 = this.valueTypeLoaded;
                synchronized (this.valueTypeLoaded) {
                    if (this.valueTypeLoading) {
                        this.valueType = type;
                        this.valueTypeName = typeName;
                        this.valueTypeLoading = false;
                        this.valueTypeLoaded[0] = true;
                        this.valueTypeLoaded.notifyAll();
                    }
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                }
            }
            if (namePtr != null) {
                namePtr[0] = typeName;
            }
            return type;
        }
    }

    @Override
    public String getType() {
        if (this.genericType != null) {
            return this.genericType;
        }
        try {
            String[] typeNamePtr = new String[1];
            this.getCachedType(typeNamePtr);
            return typeNamePtr[0];
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vmdex) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_Disconnected");
        }
        catch (ObjectCollectedExceptionWrapper ocex) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_ObjCollected");
        }
    }

    @Override
    public JPDAClassType getClassType() {
        try {
            Type type = this.getCachedType();
            if (type instanceof ReferenceType) {
                return this.getDebugger().getClassType((ReferenceType)type);
            }
            return null;
        }
        catch (ObjectCollectedExceptionWrapper e) {
            return null;
        }
        catch (InternalExceptionWrapper e) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof AbstractObjectVariable && this.getID().equals(((AbstractObjectVariable)o).getID());
    }

    @Override
    public int hashCode() {
        return this.getID().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setInnerValue(Value v) {
        super.setInnerValue(v);
        Object object = this.fieldsLock;
        synchronized (object) {
            this.fields = null;
            this.staticFields = null;
            this.inheritedFields = null;
        }
        object = this.superClassLoaded;
        synchronized (this.superClassLoaded) {
            this.superClassLoading = false;
            this.superClassLoaded[0] = false;
            this.superClassLoaded.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            object = this.valueTypeLoaded;
            synchronized (this.valueTypeLoaded) {
                this.valueTypeLoading = false;
                this.valueTypeLoaded[0] = false;
                this.valueTypeLoaded.notifyAll();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    private static String getTypeDescription(PushbackReader signature) throws IOException {
        int c = signature.read();
        switch (c) {
            case 90: {
                return "boolean";
            }
            case 66: {
                return "byte";
            }
            case 67: {
                return "char";
            }
            case 83: {
                return "short";
            }
            case 73: {
                return "int";
            }
            case 74: {
                return "long";
            }
            case 70: {
                return "float";
            }
            case 68: {
                return "double";
            }
            case 91: {
                int arrayCount = 1;
                while (true) {
                    if ((c = signature.read()) != 91) break;
                    ++arrayCount;
                }
                signature.unread(c);
                return AbstractObjectVariable.getTypeDescription(signature) + " " + AbstractObjectVariable.brackets(arrayCount);
            }
            case 76: {
                StringBuilder typeName = new StringBuilder(50);
                while (true) {
                    if ((c = signature.read()) == 59) {
                        int idx = typeName.lastIndexOf("/");
                        return idx == -1 ? typeName.toString() : typeName.substring(idx + 1);
                    }
                    if (c == 60) {
                        int idx = typeName.lastIndexOf("/");
                        if (idx != -1) {
                            typeName.delete(0, idx + 1);
                        }
                        typeName.append("<");
                        while (true) {
                            String td = AbstractObjectVariable.getTypeDescription(signature);
                            typeName.append(td);
                            c = signature.read();
                            if (c == 62) break;
                            signature.unread(c);
                            typeName.append(',');
                        }
                        signature.read();
                        typeName.append(">");
                        return typeName.toString();
                    }
                    typeName.append((char)c);
                }
            }
        }
        throw new IOException();
    }

    private static String brackets(int arrayCount) {
        StringBuilder sb = new StringBuilder(arrayCount * 2);
        do {
            sb.append("[]");
        } while (--arrayCount > 0);
        return sb.toString();
    }

    private void initFields() {
        Type type;
        assert (Thread.holdsLock(this.fieldsLock));
        this.refreshFields = false;
        Value value = this.getInnerValue();
        if (value != null) {
            try {
                type = ValueWrapper.type(value);
            }
            catch (InternalExceptionWrapper ocex) {
                type = null;
            }
            catch (ObjectCollectedExceptionWrapper ocex) {
                type = null;
            }
            catch (VMDisconnectedExceptionWrapper e) {
                type = null;
            }
        } else {
            type = null;
        }
        if (!(value instanceof ObjectReference) || !(type instanceof ReferenceType)) {
            this.fields = new org.netbeans.api.debugger.jpda.Field[0];
            this.staticFields = new org.netbeans.api.debugger.jpda.Field[0];
            this.inheritedFields = new org.netbeans.api.debugger.jpda.Field[0];
        } else {
            try {
                ObjectReference or = (ObjectReference)value;
                ReferenceType rt = (ReferenceType)type;
                if (or instanceof ArrayReference) {
                    this.fields = this.getFieldsOfArray((ArrayReference)or, ArrayTypeWrapper.componentTypeName((ArrayType)rt), this.getID(), 0, ArrayReferenceWrapper.length((ArrayReference)or));
                    this.staticFields = new org.netbeans.api.debugger.jpda.Field[0];
                    this.inheritedFields = new org.netbeans.api.debugger.jpda.Field[0];
                } else {
                    this.initFieldsOfClass(or, rt, this.getID());
                }
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                // empty catch block
            }
        }
    }

    private org.netbeans.api.debugger.jpda.Field[] getFieldsOfArray(ArrayReference ar, String componentType, String parentID, int from, int to) {
        List<Value> l;
        try {
            l = ArrayReferenceWrapper.getValues(ar, from, to - from);
        }
        catch (InternalExceptionWrapper ex) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        int k = l.size();
        org.netbeans.api.debugger.jpda.Field[] ch = new org.netbeans.api.debugger.jpda.Field[k];
        for (int i = 0; i < k; ++i) {
            Value v = l.get(i);
            ch[i] = v == null || v instanceof ObjectReference ? new ObjectArrayFieldVariable(this.getDebugger(), (ObjectReference)v, componentType, this, from + i, to - 1, parentID) : new ArrayFieldVariable(this.getDebugger(), (PrimitiveValue)v, componentType, this, from + i, to - 1, parentID);
        }
        return ch;
    }

    private void initFieldsOfClass(ObjectReference or, ReferenceType rt, String parentID) {
        ArrayList<org.netbeans.api.debugger.jpda.Field> classFields = new ArrayList<org.netbeans.api.debugger.jpda.Field>();
        ArrayList<org.netbeans.api.debugger.jpda.Field> classStaticFields = new ArrayList<org.netbeans.api.debugger.jpda.Field>();
        ArrayList<org.netbeans.api.debugger.jpda.Field> allInheretedFields = new ArrayList<org.netbeans.api.debugger.jpda.Field>();
        try {
            List<Field> l = ReferenceTypeWrapper.allFields0(rt);
            HashSet<Field> s = new HashSet<Field>(ReferenceTypeWrapper.fields0(rt));
            int k = l.size();
            for (int i = 0; i < k; ++i) {
                Field f = l.get(i);
                org.netbeans.api.debugger.jpda.Field field = this.getField(f, or, this.getID());
                if (TypeComponentWrapper.isStatic(f)) {
                    classStaticFields.add(field);
                    continue;
                }
                if (s.contains(f)) {
                    classFields.add(field);
                    continue;
                }
                allInheretedFields.add(field);
            }
        }
        catch (ClassNotPreparedExceptionWrapper i) {
        }
        catch (InternalExceptionWrapper i) {
        }
        catch (VMDisconnectedExceptionWrapper e) {
            classFields.clear();
            classStaticFields.clear();
            allInheretedFields.clear();
        }
        this.fields = classFields.toArray(new org.netbeans.api.debugger.jpda.Field[classFields.size()]);
        this.inheritedFields = allInheretedFields.toArray(new org.netbeans.api.debugger.jpda.Field[allInheretedFields.size()]);
        this.staticFields = classStaticFields.toArray(new org.netbeans.api.debugger.jpda.Field[classStaticFields.size()]);
    }

    org.netbeans.api.debugger.jpda.Field getField(Field f, ObjectReference or, String parentID) {
        return AbstractObjectVariable.getField(this.getDebugger(), f, or, parentID);
    }

    public static org.netbeans.api.debugger.jpda.Field getField(JPDADebuggerImpl debugger, Field f, ObjectReference or, String parentID) {
        String signature = f.signature();
        if (signature.length() == 1) {
            return new FieldVariable(debugger, f, parentID, or);
        }
        boolean isClassRef = "Ljava/lang/Class;".equals(signature);
        if (isClassRef) {
            return new ClassFieldVariable(debugger, f, parentID, JPDADebuggerImpl.getGenericSignature(f), or);
        }
        return new ObjectFieldVariable(debugger, f, parentID, JPDADebuggerImpl.getGenericSignature(f), or);
    }

    public List<ObjectVariable> getReferringObjects(long maxReferrers) {
        Value v = this.getJDIValue();
        if (v instanceof ObjectReference) {
            List<ObjectReference> referrers;
            final String name = Long.toString(this.getUniqueID());
            try {
                referrers = ObjectReferenceWrapper.referringObjects((ObjectReference)v, maxReferrers);
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return Collections.emptyList();
            }
            catch (InternalExceptionWrapper ex) {
                return Collections.emptyList();
            }
            catch (ObjectCollectedExceptionWrapper ex) {
                return Collections.emptyList();
            }
            return new AbstractList<ObjectVariable>(){

                @Override
                public ObjectVariable get(int i) {
                    ObjectReference obj = (ObjectReference)referrers.get(i);
                    if (obj instanceof ClassObjectReference) {
                        ClassObjectReference clobj = (ClassObjectReference)obj;
                        return new ClassVariableImpl(AbstractObjectVariable.this.getDebugger(), clobj, name + " referrer " + i);
                    }
                    return new AbstractObjectVariable(AbstractObjectVariable.this.getDebugger(), obj, name + " referrer " + i);
                }

                @Override
                public int size() {
                    return referrers.size();
                }
            };
        }
        return Collections.emptyList();
    }

    public long getUniqueID() {
        Value value = this.getJDIValue();
        if (!(value instanceof ObjectReference)) {
            return 0L;
        }
        try {
            return ObjectReferenceWrapper.uniqueID((ObjectReference)value);
        }
        catch (InternalExceptionWrapper ex) {
            return 0L;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return 0L;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return 0L;
        }
    }

    @Override
    public Variable clone() {
        AbstractObjectVariable clon = new AbstractObjectVariable(this.getDebugger(), this.getJDIValue(), this.getID() + "_clone" + this.cloneNumber++);
        clon.genericType = this.genericType;
        return clon;
    }

    @Override
    public String toString() {
        return "ObjectVariable ";
    }

    private class DebuggetStateListener
    implements PropertyChangeListener {
        private DebuggetStateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object newValue;
            if ("state".equals(evt.getPropertyName()) && (newValue = evt.getNewValue()) instanceof Integer && 2 == (Integer)newValue) {
                Object object = AbstractObjectVariable.this.fieldsLock;
                synchronized (object) {
                    AbstractObjectVariable.this.refreshFields = true;
                }
            }
        }
    }
}

