/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.api.beans.model;

import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.spring.api.beans.model.ModelUnit;
import org.netbeans.modules.spring.api.beans.model.SpringModel;
import org.netbeans.modules.spring.api.beans.model.SpringModelFactory;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public final class SpringMetaModelSupport {
    private final Project project;
    private static final String TYPE_WEB_INF = "web_inf";

    public SpringMetaModelSupport(Project project) {
        this.project = project;
    }

    public MetadataModel<SpringModel> getMetaModel() {
        ModelUnit modelUnit = this.getModelUnit();
        if (modelUnit == null) {
            return null;
        }
        return SpringModelFactory.getMetaModel(modelUnit);
    }

    public ModelUnit getModelUnit() {
        if (this.project == null) {
            return null;
        }
        ClassPath boot = this.getClassPath("classpath/boot");
        ClassPath compile = this.getClassPath("classpath/compile");
        ClassPath src = this.getClassPath("classpath/source");
        return ModelUnit.create(boot, compile, src);
    }

    public ClassPath getClassPath(String type) {
        FileObject rootFolder;
        ClassPathProvider provider = (ClassPathProvider)this.project.getLookup().lookup(ClassPathProvider.class);
        if (provider == null) {
            return null;
        }
        Sources sources = (Sources)this.project.getLookup().lookup(Sources.class);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        SourceGroup[] webGroup = sources.getSourceGroups(TYPE_WEB_INF);
        ClassPath[] paths = new ClassPath[sourceGroups.length + webGroup.length];
        int i = 0;
        for (SourceGroup sourceGroup : sourceGroups) {
            rootFolder = sourceGroup.getRootFolder();
            paths[i] = provider.findClassPath(rootFolder, type);
            ++i;
        }
        for (SourceGroup sourceGroup : webGroup) {
            rootFolder = sourceGroup.getRootFolder();
            paths[i] = provider.findClassPath(rootFolder, type);
            ++i;
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])paths);
    }
}

