/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.util.EventListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.openide.util.WeakListeners;

public final class OptionCodeCompletionSettings {
    private static boolean caseSensitive;
    private static boolean inited;
    private static PreferenceChangeListener settingsListener;

    private OptionCodeCompletionSettings() {
    }

    public static boolean isCaseSensitive() {
        OptionCodeCompletionSettings.lazyInit();
        return caseSensitive;
    }

    private static void setCaseSensitive(boolean b) {
        OptionCodeCompletionSettings.lazyInit();
        caseSensitive = b;
    }

    private static void lazyInit() {
        if (!inited) {
            inited = true;
            Preferences prefs = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
            prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)settingsListener, (Object)prefs));
            OptionCodeCompletionSettings.setCaseSensitive(prefs.getBoolean("completion-case-sensitive", false));
        }
    }

    static {
        settingsListener = new SettingsListener();
    }

    private static class SettingsListener
    implements PreferenceChangeListener {
        private SettingsListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            if ("completion-case-sensitive".equals(evt.getKey())) {
                OptionCodeCompletionSettings.setCaseSensitive(Boolean.valueOf(evt.getNewValue()));
            }
        }
    }
}

