/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.hyperlink;

import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.modules.spring.beans.editor.BeanClassFinder;
import org.netbeans.modules.spring.beans.hyperlink.Bundle;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkEnv;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkProcessor;
import org.netbeans.modules.spring.beans.utils.ElementSeekerTask;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.MatchType;
import org.netbeans.modules.spring.java.Property;
import org.netbeans.modules.spring.java.PropertyFinder;

public class PropertyHyperlinkProcessor
extends HyperlinkProcessor {
    @Override
    public void process(HyperlinkEnv env) {
        String className = new BeanClassFinder(env.getBeanAttributes(), env.getFileObject()).findImplementationClass(false);
        if (className == null) {
            return;
        }
        String propChain = this.getPropertyChainUptoPosition(env);
        if (propChain == null || propChain.equals("")) {
            return;
        }
        JavaSource js = JavaUtils.getJavaSource(env.getFileObject());
        if (js == null) {
            return;
        }
        boolean jumpToGetter = StringUtils.occurs(env.getValueString(), ".", propChain.length());
        PropertySeekerTask propertySeeker = new PropertySeekerTask(js, className, propChain, jumpToGetter);
        propertySeeker.runAsUserTask();
        if (!propertySeeker.wasElementFound()) {
            ScanDialog.runWhenScanFinished((Runnable)propertySeeker, (String)Bundle.title_property_searching());
        }
    }

    @Override
    public int[] getSpan(HyperlinkEnv env) {
        int addOffset = env.getTokenStartOffset() + 1;
        String propChain = this.getPropertyChainUptoPosition(env);
        if (propChain == null || propChain.equals("")) {
            return null;
        }
        int endPos = env.getTokenStartOffset() + propChain.length() + 1;
        int startPos = propChain.lastIndexOf(".");
        startPos = startPos == -1 ? 0 : ++startPos;
        return new int[]{startPos += addOffset, endPos};
    }

    private String getPropertyChainUptoPosition(HyperlinkEnv env) {
        int relOffset = env.getOffset() - env.getTokenStartOffset() - 1;
        int endPos = env.getValueString().indexOf(".", relOffset);
        if (endPos == -1) {
            return env.getValueString();
        }
        return env.getValueString().substring(0, endPos);
    }

    private class PropertySeekerTask
    extends ElementSeekerTask {
        private final String className;
        private final String propChain;
        private final boolean jumpToGetter;

        public PropertySeekerTask(JavaSource javaSource, String className, String propChain, boolean jumpToGetter) {
            super(javaSource);
            this.className = className;
            this.propChain = propChain;
            this.jumpToGetter = jumpToGetter;
        }

        public void run(CompilationController cc) throws Exception {
            cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            int dotIndex = this.propChain.lastIndexOf(".");
            if (this.className == null) {
                return;
            }
            TypeElement te = JavaUtils.findClassElementByBinaryName(this.className, cc);
            if (te == null) {
                return;
            }
            TypeMirror startType = te.asType();
            ElementUtilities eu = cc.getElementUtilities();
            if (dotIndex != -1) {
                String getterChain = this.propChain.substring(0, dotIndex);
                StringTokenizer tokenizer = new StringTokenizer(getterChain, ".");
                while (tokenizer.hasMoreTokens() && startType != null) {
                    String propertyName = tokenizer.nextToken();
                    Property[] props = new PropertyFinder(startType, propertyName, eu, MatchType.PREFIX).findProperties();
                    if (props.length == 0 || props[0].getGetter() == null) {
                        startType = null;
                        break;
                    }
                    TypeMirror retType = props[0].getGetter().getReturnType();
                    if (retType.getKind() == TypeKind.DECLARED) {
                        startType = retType;
                        continue;
                    }
                    startType = null;
                }
            }
            if (startType == null) {
                return;
            }
            this.elementFound.set(true);
            String setterProp = this.propChain.substring(dotIndex + 1);
            Property[] sProps = new PropertyFinder(startType, setterProp, eu, MatchType.PREFIX).findProperties();
            if (sProps.length > 0) {
                ExecutableElement element;
                ExecutableElement executableElement = element = this.jumpToGetter ? sProps[0].getGetter() : sProps[0].getSetter();
                if (element != null) {
                    ElementOpen.open((ClasspathInfo)cc.getClasspathInfo(), (Element)element);
                }
            }
        }
    }
}

