/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeanProperty;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.beans.model.SpringBeanSource;
import org.netbeans.modules.spring.beans.model.impl.ConfigFileLocation;
import org.netbeans.modules.spring.beans.model.impl.ConfigFileSpringBean;
import org.netbeans.modules.spring.beans.model.impl.ConfigFileSpringBeanProperty;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigFileSpringBeanSource
implements SpringBeanSource {
    private static final Logger LOGGER = Logger.getLogger(ConfigFileSpringBeanSource.class.getName());
    private final Map<String, ConfigFileSpringBean> id2Bean = new HashMap<String, ConfigFileSpringBean>();
    private final Map<String, ConfigFileSpringBean> name2Bean = new HashMap<String, ConfigFileSpringBean>();
    private final Map<String, String> alias2Name = new HashMap<String, String>();
    private final List<ConfigFileSpringBean> beans = new ArrayList<ConfigFileSpringBean>();

    public void parse(BaseDocument document) throws IOException {
        FileObject fo = NbEditorUtilities.getFileObject((Document)document);
        if (fo == null) {
            LOGGER.log(Level.WARNING, "Could not get a FileObject for document {0}", document);
            return;
        }
        LOGGER.log(Level.FINE, "Parsing {0}", fo);
        File file = FileUtil.toFile((FileObject)fo);
        if (file == null) {
            LOGGER.log(Level.WARNING, "{0} resolves to a null File, aborting", fo);
            return;
        }
        new DocumentParser(file, (Document)document).run();
        LOGGER.log(Level.FINE, "Parsed {0}", fo);
    }

    @Override
    public List<SpringBean> getBeans() {
        return Collections.unmodifiableList(this.beans);
    }

    @Override
    public SpringBean findBeanByID(String id) {
        return this.id2Bean.get(id);
    }

    @Override
    public SpringBean findBean(String name) {
        SpringBean bean = this.findBeanByID(name);
        if (bean == null) {
            bean = this.name2Bean.get(name);
        }
        return bean;
    }

    @Override
    public String findAliasName(String alias) {
        return this.alias2Name.get(alias);
    }

    @Override
    public Set<String> getAliases() {
        return this.alias2Name.keySet();
    }

    private final class DocumentParser
    implements Runnable {
        private final File file;
        private final Document document;
        private static final String REF_SUFFIX = "-ref";
        private static final String NULL_PREFIX = "null_prefix";
        private XMLSyntaxSupport support;

        public DocumentParser(File file, Document document) {
            this.file = file;
            this.document = document;
        }

        @Override
        public void run() {
            ConfigFileSpringBeanSource.this.id2Bean.clear();
            ConfigFileSpringBeanSource.this.name2Bean.clear();
            ConfigFileSpringBeanSource.this.beans.clear();
            ConfigFileSpringBeanSource.this.alias2Name.clear();
            Node rootNode = SpringXMLConfigEditorUtils.getDocumentRoot(this.document);
            if (rootNode == null) {
                return;
            }
            this.support = XMLSyntaxSupport.getSyntaxSupport((Document)this.document);
            NodeList childNodes = rootNode.getChildNodes();
            HashMap<String, String> prefixesMap = new HashMap<String, String>();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                String nodeName = node.getNodeName();
                if ("alias".equals(nodeName)) {
                    this.parseAlias(node);
                    continue;
                }
                if (!"bean".equals(nodeName)) continue;
                this.parseBean(node, prefixesMap);
            }
        }

        private void parseAlias(Node node) {
            String name = this.getTrimmedAttr(node, "name");
            String alias = this.getTrimmedAttr(node, "alias");
            if (StringUtils.hasText(name) && StringUtils.hasText(alias)) {
                ConfigFileSpringBeanSource.this.alias2Name.put(alias, name);
            }
        }

        private void parseBean(Node node, Map<String, String> prefixesMap) {
            String id = this.getTrimmedAttr(node, "id");
            String name = this.getTrimmedAttr(node, "name");
            List<String> names = name != null ? Collections.unmodifiableList(StringUtils.tokenize(name, ",; ")) : Collections.emptyList();
            String clazz = this.getTrimmedAttr(node, "class");
            String parent = this.getTrimmedAttr(node, "parent");
            String factoryBean = this.getTrimmedAttr(node, "factory-bean");
            String factoryMethod = this.getTrimmedAttr(node, "factory-method");
            ConfigFileLocation location = new ConfigFileLocation(FileUtil.toFileObject((File)this.file), this.support.getNodeOffset(node));
            Set<SpringBeanProperty> properties = this.parseBeanProperties(node, prefixesMap);
            ConfigFileSpringBean bean = new ConfigFileSpringBean(id, names, clazz, parent, factoryBean, factoryMethod, properties, location);
            if (id != null) {
                this.addBeanID(id, bean);
            }
            for (String each : names) {
                this.addBeanName(each, bean);
            }
            if (clazz != null) {
                ConfigFileSpringBeanSource.this.beans.add(bean);
            }
        }

        private Set<SpringBeanProperty> parseBeanProperties(Node node, Map<String, String> prefixesMap) {
            HashMap<String, ConfigFileSpringBeanProperty> name2Properties = new HashMap<String, ConfigFileSpringBeanProperty>();
            NodeList nl = node.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                String name;
                Node n = nl.item(i);
                if (!"property".equals(n.getNodeName()) || !StringUtils.hasText(name = this.getTrimmedAttr(n, "name")) || name2Properties.containsKey(name)) continue;
                name2Properties.put(name, new ConfigFileSpringBeanProperty(name));
            }
            String tagName = node.getNodeName();
            String prefix = prefixesMap.get(tagName);
            if (prefix == null) {
                prefix = SpringXMLConfigEditorUtils.getPNamespacePrefix(this.document, this.support.getNodeOffset(node));
                if (prefix == null) {
                    prefixesMap.put(tagName, NULL_PREFIX);
                } else {
                    prefixesMap.put(tagName, prefix);
                }
            } else if (NULL_PREFIX.equals(prefix)) {
                prefix = null;
            }
            if (prefix != null) {
                NamedNodeMap attribs = node.getAttributes();
                for (int i = 0; i < attribs.getLength(); ++i) {
                    Node attribNode = attribs.item(i);
                    String attribName = attribNode.getNodeName();
                    if (attribName.length() <= prefix.length() + 1 || !prefix.equals(ContextUtilities.getPrefixFromNodeName(attribName))) continue;
                    int endIndex = attribName.endsWith(REF_SUFFIX) ? attribName.lastIndexOf(REF_SUFFIX) : attribName.length();
                    String name = attribName.substring(prefix.length() + 1, endIndex);
                    if (!StringUtils.hasText(name) || name2Properties.containsKey(name)) continue;
                    name2Properties.put(name, new ConfigFileSpringBeanProperty(name));
                }
            }
            return Collections.unmodifiableSet(new HashSet(name2Properties.values()));
        }

        private void addBeanID(String id, ConfigFileSpringBean bean) {
            if (ConfigFileSpringBeanSource.this.id2Bean.get(id) == null) {
                ConfigFileSpringBeanSource.this.id2Bean.put(id, bean);
            }
        }

        private void addBeanName(String name, ConfigFileSpringBean bean) {
            if (ConfigFileSpringBeanSource.this.name2Bean.get(name) == null) {
                ConfigFileSpringBeanSource.this.name2Bean.put(name, bean);
            }
        }

        private String getTrimmedAttr(Node node, String attrName) {
            String attrValue = SpringXMLConfigEditorUtils.getAttribute(node, attrName);
            if (attrValue != null) {
                attrValue = attrValue.trim();
            }
            return attrValue;
        }
    }
}

